//! @file mathlib-toeplitz.c
//
//! @section copyright
//
// This file is part of VIF - vintage fortran compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section license
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the gnu general public license as published by the 
// free software foundation; either version 3 of the license, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// without any warranty; without even the implied warranty of merchantability 
// or fitness for a particular purpose. See the GNU general public license for 
// more details. you should have received a copy of the GNU general public 
// license along with this program. If not, see <http://www.gnu.org/licenses/>.
//
//! @Synopsis
//
//! 19 subprograms from TOEPLITZ

// Compiled from Fortran source code by VIF.
// Selected subprograms are:
//
// CCCSLZ CCSLZ  CGSLZ  CQRZ   CTGSLZ SALWZ  TGSLD1 TGSLZ1 TSLD1  TSLZ1
// CCGSLZ CCTSLZ CQRD   CSLZ   CTSLZ  TGSLD  TGSLZ  TSLD   TSLZ

// TOEPLITZ solves a variety of Toeplitz and circulant linear systems. The package can also handle 
// circulant Toeplitz systems, and some other more complicated but related forms. The package was 
// written in the early 1980's by a joint working group of American and Soviet mathematicians.
// 
// The package lives on for instance as a Python package.
// 
// Reference:
//   Oleg Arushanian, MK Samarin, Valentin Voevodin, Evgeny Tyrtyshnikov, 
//   Burton Garbow, James Boyle, Wayne Cowell, Kenneth Dritz.
//   The TOEPLITZ Package User's Guide.
//   Argonne National Laboratory.
//   ANL-83-16, 1983. 

// The license for TOEPLITZ Fortran source code is:
//
// TOEPLITZ can be obtained from:
//   https://people.sc.fsu.edu/~jburkardt/f77_src/toeplitz/toeplitz.html
// distributed under MIT license.
// 
// The original code can be obtained from:
//   netlib.org/toeplitz
// 
// 
// MIT License
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 
// 
// Reference:
// 
//   Oleg Arushanian, MK Samarin, Valentin Voevodin, Evgeny Tyrtyshnikov, 
//   Burton Garbow, James Boyle, Wayne Cowell, Kenneth Dritz.
//   The TOEPLITZ Package User's Guide.
//   Argonne National Laboratory.
//   ANL-83-16, 1983. 

/*
Generated by VIF - experimental VIntage Fortran compiler.
VIF release 1.2.16
*/
#include <vif.h>
static int_4 _km1 = -1, _k0 = 0, _k1 = 1;
static FORMAT *__fmt_a = NULL;
#define __ncalls 20
static CALLS __calls[__ncalls] = {
  {"cccslz", 0}, // subroutine
  {"ccgslz", 0}, // subroutine
  {"ccslz", 0}, // subroutine
  {"cctslz", 0}, // subroutine
  {"cgslz", 0}, // subroutine
  {"cqrd", 0}, // subroutine
  {"cqrz", 0}, // subroutine
  {"cslz", 0}, // subroutine
  {"ctgslz", 0}, // subroutine
  {"ctslz", 0}, // subroutine
  {"salwz", 0}, // subroutine
  {"tgsld1", 0}, // subroutine
  {"tgsld", 0}, // subroutine
  {"tgslz1", 0}, // subroutine
  {"tgslz", 0}, // subroutine
  {"tsld1", 0}, // subroutine
  {"tsld", 0}, // subroutine
  {"tslz1", 0}, // subroutine
  {"tslz", 0}, // subroutine
  {NULL, 0}
};

prototype int_4 _cccslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
k_, int_4 _p_ lda_);
prototype int_4 _ccgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
k_, int_4 _p_ lda_);
prototype int_4 _ccslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
lda_);
prototype int_4 _cctslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
k_, int_4 _p_ lda_);
prototype int_4 _cgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
lda_);
prototype int_4 _cqrd (real_8 _p_ a_, real_8 _p_ q_, real_8 _p_ s_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ ldq_, int_4 
_p_ lds_);
prototype int_4 _cqrz (complex_16 _p_ a_, complex_16 _p_ q_, complex_16 _p_ s_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
ldq_, int_4 _p_ lds_);
prototype int_4 _cslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_);
prototype int_4 _ctgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
k_, int_4 _p_ lda_);
prototype int_4 _ctslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
lda_);
prototype int_4 _salwz (complex_16 _p_ a_, complex_16 _p_ r1_, complex_16 _p_ r2_, int_4 _p_ m_, int_4 _p_ l_, int_4 
_p_ lda_, int_4 _p_ job_);
prototype int_4 _tgsld1 (real_8 _p_ a1_, real_8 _p_ a2_, real_8 _p_ b_, real_8 _p_ x_, real_8 _p_ c1_, real_8 _p_ c2_, 
real_8 _p_ r1_, real_8 _p_ r2_, real_8 _p_ r3_, real_8 _p_ r5_, real_8 _p_ r6_, real_8 _p_ r_, int_4 _p_ m_, int_4 _p_ 
l_, int_4 _p_ lda_);
prototype int_4 _tgsld (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_);
prototype int_4 _tgslz1 (complex_16 _p_ a1_, complex_16 _p_ a2_, complex_16 _p_ b_, complex_16 _p_ x_, complex_16 _p_ 
c1_, complex_16 _p_ c2_, complex_16 _p_ r1_, complex_16 _p_ r2_, complex_16 _p_ r3_, complex_16 _p_ r5_, complex_16 _p_ 
r6_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_);
prototype int_4 _tgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ 
lda_);
prototype int_4 _tsld1 (real_8 _p_ a1_, real_8 _p_ a2_, real_8 _p_ b_, real_8 _p_ x_, real_8 _p_ c1_, real_8 _p_ c2_, 
int_4 _p_ m_);
prototype int_4 _tsld (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ r_, int_4 _p_ m_);
prototype int_4 _tslz1 (complex_16 _p_ a1_, complex_16 _p_ a2_, complex_16 _p_ b_, complex_16 _p_ x_, complex_16 _p_ 
c1_, complex_16 _p_ c2_, int_4 _p_ m_);
prototype int_4 _tslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_);
int_4 _cccslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ k_, int_4 
_p_ lda_)
{
  static int_4 i1_, i2_, i3_, ml_;
  static real_8 rk_;
  rk_ = (real_8) ((*k_));
  ml_ = (*m_) * (*l_);
  (void) _salwz (a_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, lda_, &_km1);
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_k1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    (void) _ccslz (&a_[0 + ((*lda_)) * ((i3_ - 1))], &x_[0 + ((*m_)) * ((0) + ((*l_)) * ((i3_ - 1)))], r_, m_, l_, m_);
  }
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_km1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
      for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
        x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 1)))] = x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 
        1)))] / rk_;
      }
    }
  }
  __calls[0].calls++;
  return 0;
}

int_4 _ccgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ k_, int_4 
_p_ lda_)
{
  static int_4 i1_, i2_, i3_, ml_, mm_;
  static real_8 rk_;
  int_4 $0_;
  rk_ = (real_8) ((*k_));
  mm_ = ((*m_) * (*m_));
  ml_ = (*m_) * (*l_);
  (void) _salwz (a_, r_, &r_[(*k_) + 1 - 1], ($0_ = mm_ * (*l_), &$0_), k_, lda_, &_km1);
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_k1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    (void) _cgslz (&a_[0 + ((*lda_)) * ((i3_ - 1))], &x_[0 + ((*m_)) * ((0) + ((*l_)) * ((i3_ - 1)))], r_, m_, l_, &mm_);
  }
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_km1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
      for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
        x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 1)))] = x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 
        1)))] / rk_;
      }
    }
  }
  __calls[1].calls++;
  return 0;
}

int_4 _ccslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_)
{
  static int_4 i1_, i2_;
  static real_8 rl_;
  rl_ = (real_8) ((*l_));
  (void) _salwz (a_, r_, &r_[(*l_) + 1 - 1], m_, l_, lda_, &_km1);
  (void) _salwz (x_, r_, &r_[(*l_) + 1 - 1], m_, l_, m_, &_k1);
  for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
    (void) _cslz (&a_[0 + ((*lda_)) * ((i2_ - 1))], &x_[0 + ((*m_)) * ((i2_ - 1))], r_, m_);
  }
  (void) _salwz (x_, r_, &r_[(*l_) + 1 - 1], m_, l_, m_, &_km1);
  for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
    for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
      x_[i1_ - 1 + ((*m_)) * ((i2_ - 1))] = x_[i1_ - 1 + ((*m_)) * ((i2_ - 1))] / rl_;
    }
  }
  __calls[2].calls++;
  return 0;
}

int_4 _cctslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ k_, int_4 
_p_ lda_)
{
  static int_4 i1_, i2_, i3_, m2_, ml_;
  static real_8 rk_;
  int_4 $0_;
  rk_ = (real_8) ((*k_));
  m2_ = 2 * (*m_) - 1;
  ml_ = (*m_) * (*l_);
  (void) _salwz (a_, r_, &r_[(*k_) + 1 - 1], ($0_ = m2_ * (*l_), &$0_), k_, lda_, &_km1);
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_k1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    (void) _ctslz (&a_[0 + ((*lda_)) * ((i3_ - 1))], &x_[0 + ((*m_)) * ((0) + ((*l_)) * ((i3_ - 1)))], r_, m_, l_, &m2_);
  }
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_km1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
      for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
        x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 1)))] = x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 
        1)))] / rk_;
      }
    }
  }
  __calls[3].calls++;
  return 0;
}

int_4 _cgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_)
{
  static int_4 i1_, i2_, ii_;
  static real_8 rl_;
  int_4 $0_;
  rl_ = (real_8) ((*l_));
  (void) _salwz (a_, r_, &r_[(*l_) + 1 - 1], ($0_ = ((*m_) * (*m_)), &$0_), l_, lda_, &_km1);
  (void) _salwz (x_, r_, &r_[(*l_) + 1 - 1], m_, l_, m_, &_k1);
  for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
    (void) _zgefa (&a_[0 + ((*lda_)) * ((i2_ - 1))], m_, m_, r_, &ii_);
    (void) _zgesl (&a_[0 + ((*lda_)) * ((i2_ - 1))], m_, m_, r_, &x_[0 + ((*m_)) * ((i2_ - 1))], &_k0);
  }
  (void) _salwz (x_, r_, &r_[(*l_) + 1 - 1], m_, l_, m_, &_km1);
  for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
    for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
      x_[i1_ - 1 + ((*m_)) * ((i2_ - 1))] = x_[i1_ - 1 + ((*m_)) * ((i2_ - 1))] / rl_;
    }
  }
  __calls[4].calls++;
  return 0;
}

int_4 _cqrd (real_8 _p_ a_, real_8 _p_ q_, real_8 _p_ s_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ ldq_, int_4 _p_ lds_)
{
  static int_4 i_, j_, j1_, ji_;
  static real_8 scale_, c_;
  int_4 $0_, $1_;
  extern real_8 _dnrm2 ();
  extern real_8 _ddot ();
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    q_[i_ - 1 + ((*ldq_)) * ((0))] = a_[i_ - 1];
    q_[i_ - 1 + ((*ldq_)) * (((*l_) - 1))] = a_[i_ - 1];
  }
  for (j1_ = 1; j1_ <= (*l_); (j1_)++) {
    j_ = j1_ + 1;
    scale_ = 1.0e0 / _dnrm2 (m_, &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1);
    if (j1_ == (*l_)) {
      goto _l60;
    }
    c_ = -scale_ * (q_[(*m_) - 1 + ((*ldq_)) * ((j1_ - 1))] * q_[0 + ((*ldq_)) * (((*l_) - 1))] + _ddot (($0_ = (*m_) - 1, 
    &$0_), &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1, &q_[1 + ((*ldq_)) * (((*l_) - 1))], &_k1)) / _dnrm2 (m_, &q_[0 + 
    ((*ldq_)) * (((*l_) - 1))], &_k1);
    q_[0 + ((*ldq_)) * ((j_ - 1))] = q_[(*m_) - 1 + ((*ldq_)) * ((j1_ - 1))] + c_ * q_[0 + ((*ldq_)) * (((*l_) - 1))];
    for (i_ = 2; i_ <= (*m_); (i_)++) {
      q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] = q_[i_ - 1 - 1 + ((*ldq_)) * ((j1_ - 1))] + c_ * q_[i_ - 1 + ((*ldq_)) * (((*l_) - 
      1))];
    }
    if (j_ == (*l_)) {
      goto _l30;
    }
    q_[0 + ((*ldq_)) * (((*l_) - 1))] = q_[0 + ((*ldq_)) * (((*l_) - 1))] + c_ * q_[(*m_) - 1 + ((*ldq_)) * ((j1_ - 1))];
    (void) _daxpy (($1_ = (*m_) - 1, &$1_), &c_, &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1, &q_[1 + ((*ldq_)) * (((*l_) - 
    1))], &_k1);
    _l30:;
    s_[0 + ((*lds_)) * ((j_ - 1))] = c_;
    if (j_ == 2) {
      goto _l50;
    }
    for (i_ = 2; i_ <= j1_; (i_)++) {
      ji_ = j_ - i_;
      s_[i_ - 1 + ((*lds_)) * ((j_ - 1))] = s_[i_ - 1 - 1 + ((*lds_)) * ((j1_ - 1))] + c_ * s_[ji_ - 1 + ((*lds_)) * ((j1_ - 
      1))];
    }
    _l50:;
    _l60:;
    (void) _dscal (m_, &scale_, &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1);
    s_[j1_ - 1 + ((*lds_)) * ((j1_ - 1))] = 1.0;
    (void) _dscal (&j1_, &scale_, &s_[0 + ((*lds_)) * ((j1_ - 1))], &_k1);
  }
  __calls[5].calls++;
  return 0;
}
int_4 _cqrz (complex_16 _p_ a_, complex_16 _p_ q_, complex_16 _p_ s_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ ldq_, int_4 
_p_ lds_)
{
  static int_4 i_, j_, j1_, ji_;
  static real_8 scale_;
  static complex_16 c_;
  int_4 $0_, $1_;
  extern real_8 _dznrm2 ();
  extern complex_16 _zdotc ();
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    q_[i_ - 1 + ((*ldq_)) * ((0))] = a_[i_ - 1];
    q_[i_ - 1 + ((*ldq_)) * (((*l_) - 1))] = a_[i_ - 1];
  }
  for (j1_ = 1; j1_ <= (*l_); (j1_)++) {
    j_ = j1_ + 1;
    scale_ = 1.0e0 / _dznrm2 (m_, &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1);
    if (j1_ == (*l_)) {
      goto _l60;
    }
    c_ = -scale_ * (conj (q_[(*m_) - 1 + ((*ldq_)) * ((j1_ - 1))]) * q_[0 + ((*ldq_)) * (((*l_) - 1))] + _zdotc (($0_ = 
    (*m_) - 1, &$0_), &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1, &q_[1 + ((*ldq_)) * (((*l_) - 1))], &_k1)) / _dznrm2 (m_, 
    &q_[0 + ((*ldq_)) * (((*l_) - 1))], &_k1);
    q_[0 + ((*ldq_)) * ((j_ - 1))] = q_[(*m_) - 1 + ((*ldq_)) * ((j1_ - 1))] + c_ * q_[0 + ((*ldq_)) * (((*l_) - 1))];
    for (i_ = 2; i_ <= (*m_); (i_)++) {
      q_[i_ - 1 + ((*ldq_)) * ((j_ - 1))] = q_[i_ - 1 - 1 + ((*ldq_)) * ((j1_ - 1))] + c_ * q_[i_ - 1 + ((*ldq_)) * (((*l_) - 
      1))];
    }
    if (j_ == (*l_)) {
      goto _l30;
    }
    q_[0 + ((*ldq_)) * (((*l_) - 1))] = q_[0 + ((*ldq_)) * (((*l_) - 1))] + c_ * q_[(*m_) - 1 + ((*ldq_)) * ((j1_ - 1))];
    (void) _zaxpy (($1_ = (*m_) - 1, &$1_), &c_, &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1, &q_[1 + ((*ldq_)) * (((*l_) - 
    1))], &_k1);
    _l30:;
    s_[0 + ((*lds_)) * ((j_ - 1))] = c_;
    if (j_ == 2) {
      goto _l50;
    }
    for (i_ = 2; i_ <= j1_; (i_)++) {
      ji_ = j_ - i_;
      s_[i_ - 1 + ((*lds_)) * ((j_ - 1))] = s_[i_ - 1 - 1 + ((*lds_)) * ((j1_ - 1))] + c_ * s_[ji_ - 1 + ((*lds_)) * ((j1_ - 
      1))];
    }
    _l50:;
    _l60:;
    (void) _zdscal (m_, &scale_, &q_[0 + ((*ldq_)) * ((j1_ - 1))], &_k1);
    s_[j1_ - 1 + ((*lds_)) * ((j1_ - 1))] = CMPLX (1.0, 0.0);
    (void) _zdscal (&j1_, &scale_, &s_[0 + ((*lds_)) * ((j1_ - 1))], &_k1);
  }
  __calls[6].calls++;
  return 0;
}

int_4 _cslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_)
{
  static int_4 i1_, i2_;
  static real_8 p_, ri_, rm_, v1_, v2_;
  static complex_16 e_, e1_, f_, f1_, t_, t1_;
  t1_ = x_[0];
  x_[0] = t1_ / a_[0];
  if ((*m_) == 1) {
    goto _l50;
  }
  rm_ = (real_8) ((*m_));
  t_ = CMPLX (0.0, 0.0);
  ri_ = -1.0;
  for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
    ri_ = ri_ + 1.0e0;
    p_ = (6.28125 * ri_ + 1.93530717958647692528e-3 * ri_) / rm_;
    v1_ = cos (p_);
    v2_ = sin (p_);
    e_ = CMPLX (v1_, -v2_);
    e1_ = CMPLX (v1_, v2_);
    f_ = a_[0];
    f1_ = t1_;
    for (i2_ = 2; i2_ <= (*m_); (i2_)++) {
      f_ = e_ * f_ + a_[i2_ - 1];
      f1_ = e1_ * f1_ + x_[i2_ - 1];
    }
    r_[i1_ - 1] = (e1_ * f1_) / (e_ * f_);
    t_ = t_ + r_[i1_ - 1];
  }
  x_[0] = t_ / rm_;
  ri_ = 0.0;
  for (i1_ = 2; i1_ <= (*m_); (i1_)++) {
    ri_ = ri_ + 1.0e0;
    p_ = (6.28125 * ri_ + 1.93530717958647692528e-3 * ri_) / rm_;
    v1_ = cos (p_);
    v2_ = sin (p_);
    e_ = CMPLX (v1_, -v2_);
    f_ = r_[0];
    for (i2_ = 2; i2_ <= (*m_); (i2_)++) {
      f_ = e_ * f_ + r_[i2_ - 1];
    }
    x_[i1_ - 1] = e_ * f_ / rm_;
  }
  _l50:;
  __calls[7].calls++;
  return 0;
}

int_4 _ctgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ k_, int_4 
_p_ lda_)
{
  static int_4 i1_, i2_, i3_, ml_, mm_;
  static real_8 rk_;
  int_4 $0_;
  rk_ = (real_8) ((*k_));
  mm_ = ((*m_) * (*m_));
  ml_ = (*m_) * (*l_);
  (void) _salwz (a_, r_, &r_[(*k_) + 1 - 1], ($0_ = mm_ * (2 * (*l_) - 1), &$0_), k_, lda_, &_km1);
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_k1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    (void) _tgslz (&a_[0 + ((*lda_)) * ((i3_ - 1))], &x_[0 + ((*m_)) * ((0) + ((*l_)) * ((i3_ - 1)))], r_, m_, l_, &mm_);
  }
  (void) _salwz (x_, r_, &r_[(*k_) + 1 - 1], &ml_, k_, &ml_, &_km1);
  for (i3_ = 1; i3_ <= (*k_); (i3_)++) {
    for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
      for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
        x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 1)))] = x_[i1_ - 1 + ((*m_)) * ((i2_ - 1) + ((*l_)) * ((i3_ - 
        1)))] / rk_;
      }
    }
  }
  __calls[8].calls++;
  return 0;
}

int_4 _ctslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_)
{
  static int_4 i1_, i2_;
  static real_8 rl_;
  int_4 $0_;
  rl_ = (real_8) ((*l_));
  (void) _salwz (a_, r_, &r_[(*l_) + 1 - 1], ($0_ = 2 * (*m_) - 1, &$0_), l_, lda_, &_km1);
  (void) _salwz (x_, r_, &r_[(*l_) + 1 - 1], m_, l_, m_, &_k1);
  for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
    (void) _tslz (&a_[0 + ((*lda_)) * ((i2_ - 1))], &x_[0 + ((*m_)) * ((i2_ - 1))], r_, m_);
  }
  (void) _salwz (x_, r_, &r_[(*l_) + 1 - 1], m_, l_, m_, &_km1);
  for (i2_ = 1; i2_ <= (*l_); (i2_)++) {
    for (i1_ = 1; i1_ <= (*m_); (i1_)++) {
      x_[i1_ - 1 + ((*m_)) * ((i2_ - 1))] = x_[i1_ - 1 + ((*m_)) * ((i2_ - 1))] / rl_;
    }
  }
  __calls[9].calls++;
  return 0;
}

int_4 _salwz (complex_16 _p_ a_, complex_16 _p_ r1_, complex_16 _p_ r2_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_, 
int_4 _p_ job_)
{
  static int_4 i_, i1_, i2_;
  static real_8 p_, ri_, rl_, v1_, v2_;
  static complex_16 e_, f_;
  if ((*l_) == 1) {
    goto _l60;
  }
  rl_ = (real_8) ((*l_));
  r1_[0] = CMPLX (1.0, 0.0);
  ri_ = 0.0;
  for (i1_ = 2; i1_ <= (*l_); (i1_)++) {
    ri_ = ri_ + 1.0e0;
    p_ = (6.28125 * ri_ + 1.93530717958647692528e-3 * ri_) / rl_;
    v1_ = cos (p_);
    v2_ = sin (p_);
    if ((*job_) == -1) {
      v2_ = -v2_;
    }
    r1_[i1_ - 1] = CMPLX (v1_, v2_);
  }
  for (i_ = 1; i_ <= (*m_); (i_)++) {
    for (i1_ = 1; i1_ <= (*l_); (i1_)++) {
      e_ = r1_[i1_ - 1];
      f_ = a_[i_ - 1 + ((*lda_)) * ((0))];
      for (i2_ = 2; i2_ <= (*l_); (i2_)++) {
        f_ = e_ * f_ + a_[i_ - 1 + ((*lda_)) * ((i2_ - 1))];
      }
      r2_[i1_ - 1] = e_ * f_;
    }
    for (i1_ = 1; i1_ <= (*l_); (i1_)++) {
      a_[i_ - 1 + ((*lda_)) * ((i1_ - 1))] = r2_[i1_ - 1];
    }
  }
  _l60:;
  __calls[10].calls++;
  return 0;
}

int_4 _tgsld1 (real_8 _p_ a1_, real_8 _p_ a2_, real_8 _p_ b_, real_8 _p_ x_, real_8 _p_ c1_, real_8 _p_ c2_, real_8 _p_ 
r1_, real_8 _p_ r2_, real_8 _p_ r3_, real_8 _p_ r5_, real_8 _p_ r6_, real_8 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 
_p_ lda_)
{
  static int_4 i_, i1_, i2_, i3_, ii_, j_, n_, n1_, n2_;
  real_8 $0_;
  i3_ = 1;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))] = a1_[i3_ - 1 + ((*lda_)) * ((0))];
      r1_[i_ - 1 + ((*m_)) * ((j_ - 1))] = a1_[i3_ - 1 + ((*lda_)) * ((0))];
      r3_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r1_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      i3_ = i3_ + 1;
    }
    x_[j_ - 1 + ((*m_)) * ((0))] = b_[j_ - 1 + ((*m_)) * ((0))];
  }
  (void) _dgefa (r3_, m_, m_, r_, &ii_);
  (void) _dgesl (r3_, m_, m_, r_, &x_[0 + ((*m_)) * ((0))], &_k0);
  if ((*l_) == 1) {
    goto _l420;
  }
  for (n_ = 2; n_ <= (*l_); (n_)++) {
    n1_ = n_ - 1;
    n2_ = n_ - 2;
    i3_ = 1;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r5_[i_ - 1 + ((*m_)) * ((j_ - 1))] = a2_[i3_ - 1 + ((*lda_)) * ((n1_ - 1))];
        r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = a1_[i3_ - 1 + ((*lda_)) * ((n_ - 1))];
        i3_ = i3_ + 1;
      }
    }
    if (n_ == 2) {
      goto _l100;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((n1_ - 1)))] = r2_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
    }
    for (i1_ = 1; i1_ <= n2_; (i1_)++) {
      i2_ = n_ - i1_;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        i3_ = 1;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          (void) _daxpy (m_, &c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i2_ - 1)))], &a2_[i3_ - 1 + ((*lda_)) * ((i1_ - 
          1))], &_k1, &r5_[0 + ((*m_)) * ((j_ - 1))], &_k1);
          (void) _daxpy (m_, &c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))], &a1_[i3_ - 1 + ((*lda_)) * ((i1_ + 1 - 
          1))], &_k1, &r6_[0 + ((*m_)) * ((j_ - 1))], &_k1);
          i3_ = i3_ + (*m_);
        }
      }
    }
    _l100:;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r2_[i_ - 1 + ((*m_)) * ((j_ - 1))] = -r5_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
      (void) _dgesl (r3_, m_, m_, r_, &r2_[0 + ((*m_)) * ((j_ - 1))], &_k0);
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r3_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r6_[i_ - 1 + ((*m_)) * ((j_ - 1))];
        r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = -c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))];
      }
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _daxpy (m_, &r2_[i_ - 1 + ((*m_)) * ((j_ - 1))], &r3_[0 + ((*m_)) * ((i_ - 1))], &_k1, &c1_[0 + ((*m_)) * ((j_ - 
        1) + ((*m_)) * ((0)))], &_k1);
      }
    }
    (void) _dgefa (r6_, m_, m_, r_, &ii_);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      (void) _dgesl (r6_, m_, m_, r_, &r3_[0 + ((*m_)) * ((j_ - 1))], &_k0);
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _daxpy (m_, &r3_[i_ - 1 + ((*m_)) * ((j_ - 1))], &r5_[0 + ((*m_)) * ((i_ - 1))], &_k1, &r1_[0 + ((*m_)) * ((j_ - 
        1))], &_k1);
      }
    }
    if (n_ == 2) {
      goto _l320;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))];
      }
    }
    for (i1_ = 2; i1_ <= n1_; (i1_)++) {
      if (i1_ == n1_) {
        goto _l230;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          r5_[i_ - 1 + ((*m_)) * ((j_ - 1))] = c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))];
        }
      }
      _l230:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))] = r6_[i_ - 1 + ((*m_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          (void) _daxpy (m_, &r3_[i_ - 1 + ((*m_)) * ((j_ - 1))], &c1_[0 + ((*m_)) * ((i_ - 1) + ((*m_)) * ((i1_ - 1)))], &_k1, 
          &c2_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))], &_k1);
        }
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          (void) _daxpy (m_, &r2_[i_ - 1 + ((*m_)) * ((j_ - 1))], &r6_[0 + ((*m_)) * ((i_ - 1))], &_k1, &c1_[0 + ((*m_)) * ((j_ - 
          1) + ((*m_)) * ((i1_ - 1)))], &_k1);
        }
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r5_[i_ - 1 + ((*m_)) * ((j_ - 1))];
        }
      }
    }
    _l320:;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))] = r3_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r3_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r1_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
      x_[j_ - 1 + ((*m_)) * ((n_ - 1))] = b_[j_ - 1 + ((*m_)) * ((n_ - 1))];
    }
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      i2_ = n_ - i1_;
      i3_ = 1;
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _daxpy (m_, ($0_ = -x_[i_ - 1 + ((*m_)) * ((i2_ - 1))], &$0_), &a2_[i3_ - 1 + ((*lda_)) * ((i1_ - 1))], &_k1, 
        &x_[0 + ((*m_)) * ((n_ - 1))], &_k1);
        i3_ = i3_ + (*m_);
      }
    }
    (void) _dgefa (r3_, m_, m_, r_, &ii_);
    (void) _dgesl (r3_, m_, m_, r_, &x_[0 + ((*m_)) * ((n_ - 1))], &_k0);
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _daxpy (m_, &x_[i_ - 1 + ((*m_)) * ((n_ - 1))], &c2_[0 + ((*m_)) * ((i_ - 1) + ((*m_)) * ((i1_ - 1)))], &_k1, 
        &x_[0 + ((*m_)) * ((i1_ - 1))], &_k1);
      }
    }
  }
  _l420:;
  __calls[11].calls++;
  return 0;
}

int_4 _tgsld (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_)
{
  static int_4 mm_, mml_, mml1_, mml2_, mml3_, mml4_, mml5_, mml6_;
  mm_ = ((*m_) * (*m_));
  mml_ = mm_ * ((*l_) - 1) + 1;
  mml1_ = 2 * mml_ - 1;
  mml2_ = mml1_ + mm_;
  mml3_ = mml2_ + mm_;
  mml4_ = mml3_ + mm_;
  mml5_ = mml4_ + mm_;
  mml6_ = mml5_ + mm_;
  (void) _tgsld1 (a_, &a_[0 + ((*lda_)) * (((*l_) + 1 - 1))], x_, x_, r_, &r_[mml_ - 1], &r_[mml1_ - 1], &r_[mml2_ - 1], 
  &r_[mml3_ - 1], &r_[mml4_ - 1], &r_[mml5_ - 1], &r_[mml6_ - 1], m_, l_, lda_);
  __calls[12].calls++;
  return 0;
}

int_4 _tgslz1 (complex_16 _p_ a1_, complex_16 _p_ a2_, complex_16 _p_ b_, complex_16 _p_ x_, complex_16 _p_ c1_, 
complex_16 _p_ c2_, complex_16 _p_ r1_, complex_16 _p_ r2_, complex_16 _p_ r3_, complex_16 _p_ r5_, complex_16 _p_ r6_, 
complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_)
{
  static int_4 i_, i1_, i2_, i3_, ii_, j_, n_, n1_, n2_;
  complex_16 $0_;
  i3_ = 1;
  for (j_ = 1; j_ <= (*m_); (j_)++) {
    for (i_ = 1; i_ <= (*m_); (i_)++) {
      c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))] = a1_[i3_ - 1 + ((*lda_)) * ((0))];
      r1_[i_ - 1 + ((*m_)) * ((j_ - 1))] = a1_[i3_ - 1 + ((*lda_)) * ((0))];
      r3_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r1_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      i3_ = i3_ + 1;
    }
    x_[j_ - 1 + ((*m_)) * ((0))] = b_[j_ - 1 + ((*m_)) * ((0))];
  }
  (void) _zgefa (r3_, m_, m_, r_, &ii_);
  (void) _zgesl (r3_, m_, m_, r_, &x_[0 + ((*m_)) * ((0))], &_k0);
  if ((*l_) == 1) {
    goto _l420;
  }
  for (n_ = 2; n_ <= (*l_); (n_)++) {
    n1_ = n_ - 1;
    n2_ = n_ - 2;
    i3_ = 1;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r5_[i_ - 1 + ((*m_)) * ((j_ - 1))] = a2_[i3_ - 1 + ((*lda_)) * ((n1_ - 1))];
        r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = a1_[i3_ - 1 + ((*lda_)) * ((n_ - 1))];
        i3_ = i3_ + 1;
      }
    }
    if (n_ == 2) {
      goto _l100;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((n1_ - 1)))] = r2_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
    }
    for (i1_ = 1; i1_ <= n2_; (i1_)++) {
      i2_ = n_ - i1_;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        i3_ = 1;
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          (void) _zaxpy (m_, &c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i2_ - 1)))], &a2_[i3_ - 1 + ((*lda_)) * ((i1_ - 
          1))], &_k1, &r5_[0 + ((*m_)) * ((j_ - 1))], &_k1);
          (void) _zaxpy (m_, &c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))], &a1_[i3_ - 1 + ((*lda_)) * ((i1_ + 1 - 
          1))], &_k1, &r6_[0 + ((*m_)) * ((j_ - 1))], &_k1);
          i3_ = i3_ + (*m_);
        }
      }
    }
    _l100:;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r2_[i_ - 1 + ((*m_)) * ((j_ - 1))] = -r5_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
      (void) _zgesl (r3_, m_, m_, r_, &r2_[0 + ((*m_)) * ((j_ - 1))], &_k0);
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r3_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r6_[i_ - 1 + ((*m_)) * ((j_ - 1))];
        r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = -c1_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))];
      }
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _zaxpy (m_, &r2_[i_ - 1 + ((*m_)) * ((j_ - 1))], &r3_[0 + ((*m_)) * ((i_ - 1))], &_k1, &c1_[0 + ((*m_)) * ((j_ - 
        1) + ((*m_)) * ((0)))], &_k1);
      }
    }
    (void) _zgefa (r6_, m_, m_, r_, &ii_);
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      (void) _zgesl (r6_, m_, m_, r_, &r3_[0 + ((*m_)) * ((j_ - 1))], &_k0);
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _zaxpy (m_, &r3_[i_ - 1 + ((*m_)) * ((j_ - 1))], &r5_[0 + ((*m_)) * ((i_ - 1))], &_k1, &r1_[0 + ((*m_)) * ((j_ - 
        1))], &_k1);
      }
    }
    if (n_ == 2) {
      goto _l320;
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))];
      }
    }
    for (i1_ = 2; i1_ <= n1_; (i1_)++) {
      if (i1_ == n1_) {
        goto _l230;
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          r5_[i_ - 1 + ((*m_)) * ((j_ - 1))] = c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))];
        }
      }
      _l230:;
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))] = r6_[i_ - 1 + ((*m_)) * ((j_ - 1))];
        }
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          (void) _zaxpy (m_, &r3_[i_ - 1 + ((*m_)) * ((j_ - 1))], &c1_[0 + ((*m_)) * ((i_ - 1) + ((*m_)) * ((i1_ - 1)))], &_k1, 
          &c2_[0 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((i1_ - 1)))], &_k1);
        }
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          (void) _zaxpy (m_, &r2_[i_ - 1 + ((*m_)) * ((j_ - 1))], &r6_[0 + ((*m_)) * ((i_ - 1))], &_k1, &c1_[0 + ((*m_)) * ((j_ - 
          1) + ((*m_)) * ((i1_ - 1)))], &_k1);
        }
      }
      for (j_ = 1; j_ <= (*m_); (j_)++) {
        for (i_ = 1; i_ <= (*m_); (i_)++) {
          r6_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r5_[i_ - 1 + ((*m_)) * ((j_ - 1))];
        }
      }
    }
    _l320:;
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        c2_[i_ - 1 + ((*m_)) * ((j_ - 1) + ((*m_)) * ((0)))] = r3_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
    }
    for (j_ = 1; j_ <= (*m_); (j_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        r3_[i_ - 1 + ((*m_)) * ((j_ - 1))] = r1_[i_ - 1 + ((*m_)) * ((j_ - 1))];
      }
      x_[j_ - 1 + ((*m_)) * ((n_ - 1))] = b_[j_ - 1 + ((*m_)) * ((n_ - 1))];
    }
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      i2_ = n_ - i1_;
      i3_ = 1;
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _zaxpy (m_, ($0_ = -x_[i_ - 1 + ((*m_)) * ((i2_ - 1))], &$0_), &a2_[i3_ - 1 + ((*lda_)) * ((i1_ - 1))], &_k1, 
        &x_[0 + ((*m_)) * ((n_ - 1))], &_k1);
        i3_ = i3_ + (*m_);
      }
    }
    (void) _zgefa (r3_, m_, m_, r_, &ii_);
    (void) _zgesl (r3_, m_, m_, r_, &x_[0 + ((*m_)) * ((n_ - 1))], &_k0);
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      for (i_ = 1; i_ <= (*m_); (i_)++) {
        (void) _zaxpy (m_, &x_[i_ - 1 + ((*m_)) * ((n_ - 1))], &c2_[0 + ((*m_)) * ((i_ - 1) + ((*m_)) * ((i1_ - 1)))], &_k1, 
        &x_[0 + ((*m_)) * ((i1_ - 1))], &_k1);
      }
    }
  }
  _l420:;
  __calls[13].calls++;
  return 0;
}

int_4 _tgslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_, int_4 _p_ l_, int_4 _p_ lda_)
{
  static int_4 mm_, mml_, mml1_, mml2_, mml3_, mml4_, mml5_, mml6_;
  mm_ = ((*m_) * (*m_));
  mml_ = mm_ * ((*l_) - 1) + 1;
  mml1_ = 2 * mml_ - 1;
  mml2_ = mml1_ + mm_;
  mml3_ = mml2_ + mm_;
  mml4_ = mml3_ + mm_;
  mml5_ = mml4_ + mm_;
  mml6_ = mml5_ + mm_;
  (void) _tgslz1 (a_, &a_[0 + ((*lda_)) * (((*l_) + 1 - 1))], x_, x_, r_, &r_[mml_ - 1], &r_[mml1_ - 1], &r_[mml2_ - 1], 
  &r_[mml3_ - 1], &r_[mml4_ - 1], &r_[mml5_ - 1], &r_[mml6_ - 1], m_, l_, lda_);
  __calls[14].calls++;
  return 0;
}

int_4 _tsld1 (real_8 _p_ a1_, real_8 _p_ a2_, real_8 _p_ b_, real_8 _p_ x_, real_8 _p_ c1_, real_8 _p_ c2_, int_4 _p_ 
m_)
{
  static int_4 i1_, i2_, n_, n1_, n2_;
  static real_8 r1_, r2_, r3_, r5_, r6_;
  r1_ = a1_[0];
  x_[0] = b_[0] / r1_;
  if ((*m_) == 1) {
    goto _l80;
  }
  for (n_ = 2; n_ <= (*m_); (n_)++) {
    n1_ = n_ - 1;
    n2_ = n_ - 2;
    r5_ = a2_[n1_ - 1];
    r6_ = a1_[n_ - 1];
    if (n_ == 2) {
      goto _l20;
    }
    c1_[n1_ - 1] = r2_;
    for (i1_ = 1; i1_ <= n2_; (i1_)++) {
      i2_ = n_ - i1_;
      r5_ = r5_ + a2_[i1_ - 1] * c1_[i2_ - 1];
      r6_ = r6_ + a1_[i1_ + 1 - 1] * c2_[i1_ - 1];
    }
    _l20:;
    r2_ = -r5_ / r1_;
    r3_ = -r6_ / r1_;
    r1_ = r1_ + r5_ * r3_;
    if (n_ == 2) {
      goto _l40;
    }
    r6_ = c2_[0];
    c2_[n1_ - 1] = 0.0;
    for (i1_ = 2; i1_ <= n1_; (i1_)++) {
      r5_ = c2_[i1_ - 1];
      c2_[i1_ - 1] = c1_[i1_ - 1] * r3_ + r6_;
      c1_[i1_ - 1] = c1_[i1_ - 1] + r6_ * r2_;
      r6_ = r5_;
    }
    _l40:;
    c2_[0] = r3_;
    r5_ = 0.0;
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      i2_ = n_ - i1_;
      r5_ = r5_ + a2_[i1_ - 1] * x_[i2_ - 1];
    }
    r6_ = (b_[n_ - 1] - r5_) / r1_;
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      x_[i1_ - 1] = x_[i1_ - 1] + c2_[i1_ - 1] * r6_;
    }
    x_[n_ - 1] = r6_;
  }
  _l80:;
  __calls[15].calls++;
  return 0;
}

int_4 _tsld (real_8 _p_ a_, real_8 _p_ x_, real_8 _p_ r_, int_4 _p_ m_)
{
  (void) _tsld1 (a_, &a_[(*m_) + 1 - 1], x_, x_, r_, &r_[(*m_) - 1], m_);
  __calls[16].calls++;
  return 0;
}

int_4 _tslz1 (complex_16 _p_ a1_, complex_16 _p_ a2_, complex_16 _p_ b_, complex_16 _p_ x_, complex_16 _p_ c1_, 
complex_16 _p_ c2_, int_4 _p_ m_)
{
  static int_4 i1_, i2_, n_, n1_, n2_;
  static complex_16 r1_, r2_, r3_, r5_, r6_;
  r1_ = a1_[0];
  x_[0] = b_[0] / r1_;
  if ((*m_) == 1) {
    goto _l80;
  }
  for (n_ = 2; n_ <= (*m_); (n_)++) {
    n1_ = n_ - 1;
    n2_ = n_ - 2;
    r5_ = a2_[n1_ - 1];
    r6_ = a1_[n_ - 1];
    if (n_ == 2) {
      goto _l20;
    }
    c1_[n1_ - 1] = r2_;
    for (i1_ = 1; i1_ <= n2_; (i1_)++) {
      i2_ = n_ - i1_;
      r5_ = r5_ + a2_[i1_ - 1] * c1_[i2_ - 1];
      r6_ = r6_ + a1_[i1_ + 1 - 1] * c2_[i1_ - 1];
    }
    _l20:;
    r2_ = -r5_ / r1_;
    r3_ = -r6_ / r1_;
    r1_ = r1_ + r5_ * r3_;
    if (n_ == 2) {
      goto _l40;
    }
    r6_ = c2_[0];
    c2_[n1_ - 1] = CMPLX (0.0, 0.0);
    for (i1_ = 2; i1_ <= n1_; (i1_)++) {
      r5_ = c2_[i1_ - 1];
      c2_[i1_ - 1] = c1_[i1_ - 1] * r3_ + r6_;
      c1_[i1_ - 1] = c1_[i1_ - 1] + r6_ * r2_;
      r6_ = r5_;
    }
    _l40:;
    c2_[0] = r3_;
    r5_ = CMPLX (0.0, 0.0);
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      i2_ = n_ - i1_;
      r5_ = r5_ + a2_[i1_ - 1] * x_[i2_ - 1];
    }
    r6_ = (b_[n_ - 1] - r5_) / r1_;
    for (i1_ = 1; i1_ <= n1_; (i1_)++) {
      x_[i1_ - 1] = x_[i1_ - 1] + c2_[i1_ - 1] * r6_;
    }
    x_[n_ - 1] = r6_;
  }
  _l80:;
  __calls[17].calls++;
  return 0;
}

int_4 _tslz (complex_16 _p_ a_, complex_16 _p_ x_, complex_16 _p_ r_, int_4 _p_ m_)
{
  (void) _tslz1 (a_, &a_[(*m_) + 1 - 1], x_, x_, r_, &r_[(*m_) - 1], m_);
  __calls[18].calls++;
  return 0;
}

