#pragma -xO
* source: lapack-3.1.1
      program cblat1
*     test program for the complex    level 1 blas.
*     based upon the original blas test routine together with:
*     f06gaf example program text
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      real             sfac
      integer          ic
*     .. external subroutines ..
      external         check1, check2, header
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             sfac/9.765625e-4/
*     .. executable statements ..
      write (nout,99999)
      do 20 ic = 1, 10
         icase = ic
         call header
*
*        initialize pass, incx, incy, and mode for a new case.
*        the value 9999 for incx, incy or mode will appear in the
*        detailed  output, if any, for cases that do not involve
*        these parameters.
*
         pass = .true.
         incx = 9999
         incy = 9999
         mode = 9999
         if (icase.le.5) then
            call check2(sfac)
         else if (icase.ge.6) then
            call check1(sfac)
         end if
*        -- print
         if (pass) write (nout,99998)
   20 continue
      stop
*
99999 format (' complex blas test program results',/1x)
99998 format ('                                    ----- pass -----')
      end
      subroutine header
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local arrays ..
      character*6      l(10)
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             l(1)/'cdotc '/
      data             l(2)/'cdotu '/
      data             l(3)/'caxpy '/
      data             l(4)/'ccopy '/
      data             l(5)/'cswap '/
      data             l(6)/'scnrm2'/
      data             l(7)/'scasum'/
      data             l(8)/'cscal '/
      data             l(9)/'csscal'/
      data             l(10)/'icamax'/
*     .. executable statements ..
      write (nout,99999) icase, l(icase)
      return
*
99999 format (/' test of subprogram number',i3,12x,a6)
      end
      subroutine check1(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      real              sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      complex           ca
      real              sa
      integer           i, j, len, np1
*     .. local arrays ..
      complex           ctrue5(8,5,2), ctrue6(8,5,2), cv(8,5,2), cx(8),
     +                  mwpcs(5), mwpct(5)
      real              strue2(5), strue4(5)
      integer           itrue3(5)
*     .. external functions ..
      real              scasum, scnrm2
      integer           icamax
      external          scasum, scnrm2, icamax
*     .. external subroutines ..
      external          cscal, csscal, ctest, itest1, stest1
*     .. intrinsic functions ..
      intrinsic         max
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa, ca/0.3e0, (0.4e0,-0.7e0)/
      data              ((cv(i,j,1),i=1,8),j=1,5)/(0.1e0,0.1e0),
     +                  (1.0e0,2.0e0), (1.0e0,2.0e0), (1.0e0,2.0e0),
     +                  (1.0e0,2.0e0), (1.0e0,2.0e0), (1.0e0,2.0e0),
     +                  (1.0e0,2.0e0), (0.3e0,-0.4e0), (3.0e0,4.0e0),
     +                  (3.0e0,4.0e0), (3.0e0,4.0e0), (3.0e0,4.0e0),
     +                  (3.0e0,4.0e0), (3.0e0,4.0e0), (3.0e0,4.0e0),
     +                  (0.1e0,-0.3e0), (0.5e0,-0.1e0), (5.0e0,6.0e0),
     +                  (5.0e0,6.0e0), (5.0e0,6.0e0), (5.0e0,6.0e0),
     +                  (5.0e0,6.0e0), (5.0e0,6.0e0), (0.1e0,0.1e0),
     +                  (-0.6e0,0.1e0), (0.1e0,-0.3e0), (7.0e0,8.0e0),
     +                  (7.0e0,8.0e0), (7.0e0,8.0e0), (7.0e0,8.0e0),
     +                  (7.0e0,8.0e0), (0.3e0,0.1e0), (0.5e0,0.0e0),
     +                  (0.0e0,0.5e0), (0.0e0,0.2e0), (2.0e0,3.0e0),
     +                  (2.0e0,3.0e0), (2.0e0,3.0e0), (2.0e0,3.0e0)/
      data              ((cv(i,j,2),i=1,8),j=1,5)/(0.1e0,0.1e0),
     +                  (4.0e0,5.0e0), (4.0e0,5.0e0), (4.0e0,5.0e0),
     +                  (4.0e0,5.0e0), (4.0e0,5.0e0), (4.0e0,5.0e0),
     +                  (4.0e0,5.0e0), (0.3e0,-0.4e0), (6.0e0,7.0e0),
     +                  (6.0e0,7.0e0), (6.0e0,7.0e0), (6.0e0,7.0e0),
     +                  (6.0e0,7.0e0), (6.0e0,7.0e0), (6.0e0,7.0e0),
     +                  (0.1e0,-0.3e0), (8.0e0,9.0e0), (0.5e0,-0.1e0),
     +                  (2.0e0,5.0e0), (2.0e0,5.0e0), (2.0e0,5.0e0),
     +                  (2.0e0,5.0e0), (2.0e0,5.0e0), (0.1e0,0.1e0),
     +                  (3.0e0,6.0e0), (-0.6e0,0.1e0), (4.0e0,7.0e0),
     +                  (0.1e0,-0.3e0), (7.0e0,2.0e0), (7.0e0,2.0e0),
     +                  (7.0e0,2.0e0), (0.3e0,0.1e0), (5.0e0,8.0e0),
     +                  (0.5e0,0.0e0), (6.0e0,9.0e0), (0.0e0,0.5e0),
     +                  (8.0e0,3.0e0), (0.0e0,0.2e0), (9.0e0,4.0e0)/
      data              strue2/0.0e0, 0.5e0, 0.6e0, 0.7e0, 0.8e0/
      data              strue4/0.0e0, 0.7e0, 1.0e0, 1.3e0, 1.6e0/
      data              ((ctrue5(i,j,1),i=1,8),j=1,5)/(0.1e0,0.1e0),
     +                  (1.0e0,2.0e0), (1.0e0,2.0e0), (1.0e0,2.0e0),
     +                  (1.0e0,2.0e0), (1.0e0,2.0e0), (1.0e0,2.0e0),
     +                  (1.0e0,2.0e0), (-0.16e0,-0.37e0), (3.0e0,4.0e0),
     +                  (3.0e0,4.0e0), (3.0e0,4.0e0), (3.0e0,4.0e0),
     +                  (3.0e0,4.0e0), (3.0e0,4.0e0), (3.0e0,4.0e0),
     +                  (-0.17e0,-0.19e0), (0.13e0,-0.39e0),
     +                  (5.0e0,6.0e0), (5.0e0,6.0e0), (5.0e0,6.0e0),
     +                  (5.0e0,6.0e0), (5.0e0,6.0e0), (5.0e0,6.0e0),
     +                  (0.11e0,-0.03e0), (-0.17e0,0.46e0),
     +                  (-0.17e0,-0.19e0), (7.0e0,8.0e0), (7.0e0,8.0e0),
     +                  (7.0e0,8.0e0), (7.0e0,8.0e0), (7.0e0,8.0e0),
     +                  (0.19e0,-0.17e0), (0.20e0,-0.35e0),
     +                  (0.35e0,0.20e0), (0.14e0,0.08e0),
     +                  (2.0e0,3.0e0), (2.0e0,3.0e0), (2.0e0,3.0e0),
     +                  (2.0e0,3.0e0)/
      data              ((ctrue5(i,j,2),i=1,8),j=1,5)/(0.1e0,0.1e0),
     +                  (4.0e0,5.0e0), (4.0e0,5.0e0), (4.0e0,5.0e0),
     +                  (4.0e0,5.0e0), (4.0e0,5.0e0), (4.0e0,5.0e0),
     +                  (4.0e0,5.0e0), (-0.16e0,-0.37e0), (6.0e0,7.0e0),
     +                  (6.0e0,7.0e0), (6.0e0,7.0e0), (6.0e0,7.0e0),
     +                  (6.0e0,7.0e0), (6.0e0,7.0e0), (6.0e0,7.0e0),
     +                  (-0.17e0,-0.19e0), (8.0e0,9.0e0),
     +                  (0.13e0,-0.39e0), (2.0e0,5.0e0), (2.0e0,5.0e0),
     +                  (2.0e0,5.0e0), (2.0e0,5.0e0), (2.0e0,5.0e0),
     +                  (0.11e0,-0.03e0), (3.0e0,6.0e0),
     +                  (-0.17e0,0.46e0), (4.0e0,7.0e0),
     +                  (-0.17e0,-0.19e0), (7.0e0,2.0e0), (7.0e0,2.0e0),
     +                  (7.0e0,2.0e0), (0.19e0,-0.17e0), (5.0e0,8.0e0),
     +                  (0.20e0,-0.35e0), (6.0e0,9.0e0),
     +                  (0.35e0,0.20e0), (8.0e0,3.0e0),
     +                  (0.14e0,0.08e0), (9.0e0,4.0e0)/
      data              ((ctrue6(i,j,1),i=1,8),j=1,5)/(0.1e0,0.1e0),
     +                  (1.0e0,2.0e0), (1.0e0,2.0e0), (1.0e0,2.0e0),
     +                  (1.0e0,2.0e0), (1.0e0,2.0e0), (1.0e0,2.0e0),
     +                  (1.0e0,2.0e0), (0.09e0,-0.12e0), (3.0e0,4.0e0),
     +                  (3.0e0,4.0e0), (3.0e0,4.0e0), (3.0e0,4.0e0),
     +                  (3.0e0,4.0e0), (3.0e0,4.0e0), (3.0e0,4.0e0),
     +                  (0.03e0,-0.09e0), (0.15e0,-0.03e0),
     +                  (5.0e0,6.0e0), (5.0e0,6.0e0), (5.0e0,6.0e0),
     +                  (5.0e0,6.0e0), (5.0e0,6.0e0), (5.0e0,6.0e0),
     +                  (0.03e0,0.03e0), (-0.18e0,0.03e0),
     +                  (0.03e0,-0.09e0), (7.0e0,8.0e0), (7.0e0,8.0e0),
     +                  (7.0e0,8.0e0), (7.0e0,8.0e0), (7.0e0,8.0e0),
     +                  (0.09e0,0.03e0), (0.15e0,0.00e0),
     +                  (0.00e0,0.15e0), (0.00e0,0.06e0), (2.0e0,3.0e0),
     +                  (2.0e0,3.0e0), (2.0e0,3.0e0), (2.0e0,3.0e0)/
      data              ((ctrue6(i,j,2),i=1,8),j=1,5)/(0.1e0,0.1e0),
     +                  (4.0e0,5.0e0), (4.0e0,5.0e0), (4.0e0,5.0e0),
     +                  (4.0e0,5.0e0), (4.0e0,5.0e0), (4.0e0,5.0e0),
     +                  (4.0e0,5.0e0), (0.09e0,-0.12e0), (6.0e0,7.0e0),
     +                  (6.0e0,7.0e0), (6.0e0,7.0e0), (6.0e0,7.0e0),
     +                  (6.0e0,7.0e0), (6.0e0,7.0e0), (6.0e0,7.0e0),
     +                  (0.03e0,-0.09e0), (8.0e0,9.0e0),
     +                  (0.15e0,-0.03e0), (2.0e0,5.0e0), (2.0e0,5.0e0),
     +                  (2.0e0,5.0e0), (2.0e0,5.0e0), (2.0e0,5.0e0),
     +                  (0.03e0,0.03e0), (3.0e0,6.0e0),
     +                  (-0.18e0,0.03e0), (4.0e0,7.0e0),
     +                  (0.03e0,-0.09e0), (7.0e0,2.0e0), (7.0e0,2.0e0),
     +                  (7.0e0,2.0e0), (0.09e0,0.03e0), (5.0e0,8.0e0),
     +                  (0.15e0,0.00e0), (6.0e0,9.0e0), (0.00e0,0.15e0),
     +                  (8.0e0,3.0e0), (0.00e0,0.06e0), (9.0e0,4.0e0)/
      data              itrue3/0, 1, 2, 2, 2/
*     .. executable statements ..
      do 60 incx = 1, 2
         do 40 np1 = 1, 5
            n = np1 - 1
            len = 2*max(n,1)
*           .. set vector arguments ..
            do 20 i = 1, len
               cx(i) = cv(i,np1,incx)
   20       continue
            if (icase.eq.6) then
*              .. scnrm2 ..
               call stest1(scnrm2(n,cx,incx),strue2(np1),strue2(np1),
     +                     sfac)
            else if (icase.eq.7) then
*              .. scasum ..
               call stest1(scasum(n,cx,incx),strue4(np1),strue4(np1),
     +                     sfac)
            else if (icase.eq.8) then
*              .. cscal ..
               call cscal(n,ca,cx,incx)
               call ctest(len,cx,ctrue5(1,np1,incx),ctrue5(1,np1,incx),
     +                    sfac)
            else if (icase.eq.9) then
*              .. csscal ..
               call csscal(n,sa,cx,incx)
               call ctest(len,cx,ctrue6(1,np1,incx),ctrue6(1,np1,incx),
     +                    sfac)
            else if (icase.eq.10) then
*              .. icamax ..
               call itest1(icamax(n,cx,incx),itrue3(np1))
            else
               write (nout,*) ' shouldn''t be here in check1'
               stop
            end if
*
   40    continue
   60 continue
*
      incx = 1
      if (icase.eq.8) then
*        cscal
*        add a test for alpha equal to zero.
         ca = (0.0e0,0.0e0)
         do 80 i = 1, 5
            mwpct(i) = (0.0e0,0.0e0)
            mwpcs(i) = (1.0e0,1.0e0)
   80    continue
         call cscal(5,ca,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
      else if (icase.eq.9) then
*        csscal
*        add a test for alpha equal to zero.
         sa = 0.0e0
         do 100 i = 1, 5
            mwpct(i) = (0.0e0,0.0e0)
            mwpcs(i) = (1.0e0,1.0e0)
  100    continue
         call csscal(5,sa,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
*        add a test for alpha equal to one.
         sa = 1.0e0
         do 120 i = 1, 5
            mwpct(i) = cx(i)
            mwpcs(i) = cx(i)
  120    continue
         call csscal(5,sa,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
*        add a test for alpha equal to minus one.
         sa = -1.0e0
         do 140 i = 1, 5
            mwpct(i) = -cx(i)
            mwpcs(i) = -cx(i)
  140    continue
         call csscal(5,sa,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
      end if
      return
      end
      subroutine check2(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      real              sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      complex           ca
      integer           i, j, ki, kn, ksize, lenx, leny, mx, my
*     .. local arrays ..
      complex           cdot(1), csize1(4), csize2(7,2), csize3(14),
     +                  ct10x(7,4,4), ct10y(7,4,4), ct6(4,4), ct7(4,4),
     +                  ct8(7,4,4), cx(7), cx1(7), cy(7), cy1(7)
      integer           incxs(4), incys(4), lens(4,2), ns(4)
*     .. external functions ..
      complex           cdotc, cdotu
      external          cdotc, cdotu
*     .. external subroutines ..
      external          caxpy, ccopy, cswap, ctest
*     .. intrinsic functions ..
      intrinsic         abs, min
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              ca/(0.4e0,-0.7e0)/
      data              incxs/1, 2, -2, -1/
      data              incys/1, -2, 1, -2/
      data              lens/1, 1, 2, 4, 1, 1, 3, 7/
      data              ns/0, 1, 2, 4/
      data              cx1/(0.7e0,-0.8e0), (-0.4e0,-0.7e0),
     +                  (-0.1e0,-0.9e0), (0.2e0,-0.8e0),
     +                  (-0.9e0,-0.4e0), (0.1e0,0.4e0), (-0.6e0,0.6e0)/
      data              cy1/(0.6e0,-0.6e0), (-0.9e0,0.5e0),
     +                  (0.7e0,-0.6e0), (0.1e0,-0.5e0), (-0.1e0,-0.2e0),
     +                  (-0.5e0,-0.3e0), (0.8e0,-0.7e0)/
      data              ((ct8(i,j,1),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.32e0,-1.41e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.32e0,-1.41e0),
     +                  (-1.55e0,0.5e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.32e0,-1.41e0), (-1.55e0,0.5e0),
     +                  (0.03e0,-0.89e0), (-0.38e0,-0.96e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0)/
      data              ((ct8(i,j,2),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.32e0,-1.41e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (-0.07e0,-0.89e0),
     +                  (-0.9e0,0.5e0), (0.42e0,-1.41e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.78e0,0.06e0), (-0.9e0,0.5e0),
     +                  (0.06e0,-0.13e0), (0.1e0,-0.5e0),
     +                  (-0.77e0,-0.49e0), (-0.5e0,-0.3e0),
     +                  (0.52e0,-1.51e0)/
      data              ((ct8(i,j,3),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.32e0,-1.41e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (-0.07e0,-0.89e0),
     +                  (-1.18e0,-0.31e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.78e0,0.06e0), (-1.54e0,0.97e0),
     +                  (0.03e0,-0.89e0), (-0.18e0,-1.31e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0)/
      data              ((ct8(i,j,4),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.32e0,-1.41e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.32e0,-1.41e0), (-0.9e0,0.5e0),
     +                  (0.05e0,-0.6e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.32e0,-1.41e0),
     +                  (-0.9e0,0.5e0), (0.05e0,-0.6e0), (0.1e0,-0.5e0),
     +                  (-0.77e0,-0.49e0), (-0.5e0,-0.3e0),
     +                  (0.32e0,-1.16e0)/
      data              ct7/(0.0e0,0.0e0), (-0.06e0,-0.90e0),
     +                  (0.65e0,-0.47e0), (-0.34e0,-1.22e0),
     +                  (0.0e0,0.0e0), (-0.06e0,-0.90e0),
     +                  (-0.59e0,-1.46e0), (-1.04e0,-0.04e0),
     +                  (0.0e0,0.0e0), (-0.06e0,-0.90e0),
     +                  (-0.83e0,0.59e0), (0.07e0,-0.37e0),
     +                  (0.0e0,0.0e0), (-0.06e0,-0.90e0),
     +                  (-0.76e0,-1.15e0), (-1.33e0,-1.82e0)/
      data              ct6/(0.0e0,0.0e0), (0.90e0,0.06e0),
     +                  (0.91e0,-0.77e0), (1.80e0,-0.10e0),
     +                  (0.0e0,0.0e0), (0.90e0,0.06e0), (1.45e0,0.74e0),
     +                  (0.20e0,0.90e0), (0.0e0,0.0e0), (0.90e0,0.06e0),
     +                  (-0.55e0,0.23e0), (0.83e0,-0.39e0),
     +                  (0.0e0,0.0e0), (0.90e0,0.06e0), (1.04e0,0.79e0),
     +                  (1.95e0,1.22e0)/
      data              ((ct10x(i,j,1),i=1,7),j=1,4)/(0.7e0,-0.8e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.6e0,-0.6e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.6e0,-0.6e0), (-0.9e0,0.5e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.6e0,-0.6e0),
     +                  (-0.9e0,0.5e0), (0.7e0,-0.6e0), (0.1e0,-0.5e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0)/
      data              ((ct10x(i,j,2),i=1,7),j=1,4)/(0.7e0,-0.8e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.6e0,-0.6e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.7e0,-0.6e0), (-0.4e0,-0.7e0),
     +                  (0.6e0,-0.6e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.8e0,-0.7e0),
     +                  (-0.4e0,-0.7e0), (-0.1e0,-0.2e0),
     +                  (0.2e0,-0.8e0), (0.7e0,-0.6e0), (0.1e0,0.4e0),
     +                  (0.6e0,-0.6e0)/
      data              ((ct10x(i,j,3),i=1,7),j=1,4)/(0.7e0,-0.8e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.6e0,-0.6e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (-0.9e0,0.5e0), (-0.4e0,-0.7e0),
     +                  (0.6e0,-0.6e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.1e0,-0.5e0),
     +                  (-0.4e0,-0.7e0), (0.7e0,-0.6e0), (0.2e0,-0.8e0),
     +                  (-0.9e0,0.5e0), (0.1e0,0.4e0), (0.6e0,-0.6e0)/
      data              ((ct10x(i,j,4),i=1,7),j=1,4)/(0.7e0,-0.8e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.6e0,-0.6e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.6e0,-0.6e0), (0.7e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.6e0,-0.6e0),
     +                  (0.7e0,-0.6e0), (-0.1e0,-0.2e0), (0.8e0,-0.7e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0)/
      data              ((ct10y(i,j,1),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.7e0,-0.8e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.7e0,-0.8e0), (-0.4e0,-0.7e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.7e0,-0.8e0),
     +                  (-0.4e0,-0.7e0), (-0.1e0,-0.9e0),
     +                  (0.2e0,-0.8e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0)/
      data              ((ct10y(i,j,2),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.7e0,-0.8e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (-0.1e0,-0.9e0), (-0.9e0,0.5e0),
     +                  (0.7e0,-0.8e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (-0.6e0,0.6e0),
     +                  (-0.9e0,0.5e0), (-0.9e0,-0.4e0), (0.1e0,-0.5e0),
     +                  (-0.1e0,-0.9e0), (-0.5e0,-0.3e0),
     +                  (0.7e0,-0.8e0)/
      data              ((ct10y(i,j,3),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.7e0,-0.8e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (-0.1e0,-0.9e0), (0.7e0,-0.8e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (-0.6e0,0.6e0),
     +                  (-0.9e0,-0.4e0), (-0.1e0,-0.9e0),
     +                  (0.7e0,-0.8e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0)/
      data              ((ct10y(i,j,4),i=1,7),j=1,4)/(0.6e0,-0.6e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.7e0,-0.8e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.7e0,-0.8e0), (-0.9e0,0.5e0),
     +                  (-0.4e0,-0.7e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.7e0,-0.8e0),
     +                  (-0.9e0,0.5e0), (-0.4e0,-0.7e0), (0.1e0,-0.5e0),
     +                  (-0.1e0,-0.9e0), (-0.5e0,-0.3e0),
     +                  (0.2e0,-0.8e0)/
      data              csize1/(0.0e0,0.0e0), (0.9e0,0.9e0),
     +                  (1.63e0,1.73e0), (2.90e0,2.78e0)/
      data              csize3/(0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (1.17e0,1.17e0),
     +                  (1.17e0,1.17e0), (1.17e0,1.17e0),
     +                  (1.17e0,1.17e0), (1.17e0,1.17e0),
     +                  (1.17e0,1.17e0), (1.17e0,1.17e0)/
      data              csize2/(0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (0.0e0,0.0e0),
     +                  (0.0e0,0.0e0), (0.0e0,0.0e0), (1.54e0,1.54e0),
     +                  (1.54e0,1.54e0), (1.54e0,1.54e0),
     +                  (1.54e0,1.54e0), (1.54e0,1.54e0),
     +                  (1.54e0,1.54e0), (1.54e0,1.54e0)/
*     .. executable statements ..
      do 60 ki = 1, 4
         incx = incxs(ki)
         incy = incys(ki)
         mx = abs(incx)
         my = abs(incy)
*
         do 40 kn = 1, 4
            n = ns(kn)
            ksize = min(2,kn)
            lenx = lens(kn,mx)
            leny = lens(kn,my)
*           .. initialize all argument arrays ..
            do 20 i = 1, 7
               cx(i) = cx1(i)
               cy(i) = cy1(i)
   20       continue
            if (icase.eq.1) then
*              .. cdotc ..
               cdot(1) = cdotc(n,cx,incx,cy,incy)
               call ctest(1,cdot,ct6(kn,ki),csize1(kn),sfac)
            else if (icase.eq.2) then
*              .. cdotu ..
               cdot(1) = cdotu(n,cx,incx,cy,incy)
               call ctest(1,cdot,ct7(kn,ki),csize1(kn),sfac)
            else if (icase.eq.3) then
*              .. caxpy ..
               call caxpy(n,ca,cx,incx,cy,incy)
               call ctest(leny,cy,ct8(1,kn,ki),csize2(1,ksize),sfac)
            else if (icase.eq.4) then
*              .. ccopy ..
               call ccopy(n,cx,incx,cy,incy)
               call ctest(leny,cy,ct10y(1,kn,ki),csize3,1.0e0)
            else if (icase.eq.5) then
*              .. cswap ..
               call cswap(n,cx,incx,cy,incy)
               call ctest(lenx,cx,ct10x(1,kn,ki),csize3,1.0e0)
               call ctest(leny,cy,ct10y(1,kn,ki),csize3,1.0e0)
            else
               write (nout,*) ' shouldn''t be here in check2'
               stop
            end if
*
   40    continue
   60 continue
      return
      end
      subroutine stest(len,scomp,strue,ssize,sfac)
*     ********************************* stest **************************
*
*     this subr compares arrays  scomp() and strue() of length len to
*     see if the term by term differences, multiplied by sfac, are
*     negligible.
*
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalar arguments ..
      real             sfac
      integer          len
*     .. array arguments ..
      real             scomp(len), ssize(len), strue(len)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      real             sd
      integer          i
*     .. external functions ..
      real             sdiff
      external         sdiff
*     .. intrinsic functions ..
      intrinsic        abs
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
*
      do 40 i = 1, len
         sd = scomp(i) - strue(i)
         if (sdiff(abs(ssize(i))+abs(sfac*sd),abs(ssize(i))).eq.0.0e0)
     +       go to 40
*
*                             here    scomp(i) is not close to strue(i).
*
         if ( .not. pass) go to 20
*                             print fail message and header.
         pass = .false.
         write (nout,99999)
         write (nout,99998)
   20    write (nout,99997) icase, n, incx, incy, mode, i, scomp(i),
     +     strue(i), sd, ssize(i)
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode  i                            ',
     +       ' comp(i)                             true(i)  difference',
     +       '     size(i)',/1x)
99997 format (1x,i4,i3,3i5,i3,2e36.8,2e12.4)
      end
      subroutine stest1(scomp1,strue1,ssize,sfac)
*     ************************* stest1 *****************************
*
*     this is an interface subroutine to accomodate the fortran
*     requirement that when a dummy argument is an array, the
*     actual argument must also be an array or an array element.
*
*     c.l. lawson, jpl, 1978 dec 6
*
*     .. scalar arguments ..
      real              scomp1, sfac, strue1
*     .. array arguments ..
      real              ssize(*)
*     .. local arrays ..
      real              scomp(1), strue(1)
*     .. external subroutines ..
      external          stest
*     .. executable statements ..
*
      scomp(1) = scomp1
      strue(1) = strue1
      call stest(1,scomp,strue,ssize,sfac)
*
      return
      end
      real             function sdiff(sa,sb)
*     ********************************* sdiff **************************
*     computes difference of two numbers.  c. l. lawson, jpl 1974 feb 15
*
*     .. scalar arguments ..
      real                            sa, sb
*     .. executable statements ..
      sdiff = sa - sb
      return
      end
      subroutine ctest(len,ccomp,ctrue,csize,sfac)
*     **************************** ctest *****************************
*
*     c.l. lawson, jpl, 1978 dec 6
*
*     .. scalar arguments ..
      real             sfac
      integer          len
*     .. array arguments ..
      complex          ccomp(len), csize(len), ctrue(len)
*     .. local scalars ..
      integer          i
*     .. local arrays ..
      real             scomp(20), ssize(20), strue(20)
*     .. external subroutines ..
      external         stest
*     .. intrinsic functions ..
      intrinsic        aimag, real
*     .. executable statements ..
      do 20 i = 1, len
         scomp(2*i-1) = real(ccomp(i))
         scomp(2*i) = aimag(ccomp(i))
         strue(2*i-1) = real(ctrue(i))
         strue(2*i) = aimag(ctrue(i))
         ssize(2*i-1) = real(csize(i))
         ssize(2*i) = aimag(csize(i))
   20 continue
*
      call stest(2*len,scomp,strue,ssize,sfac)
      return
      end
      subroutine itest1(icomp,itrue)
*     ********************************* itest1 *************************
*
*     this subroutine compares the variables icomp and itrue for
*     equality.
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      integer           icomp, itrue
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      integer           id
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
      if (icomp.eq.itrue) go to 40
*
*                            here icomp is not equal to itrue.
*
      if ( .not. pass) go to 20
*                             print fail message and header.
      pass = .false.
      write (nout,99999)
      write (nout,99998)
   20 id = icomp - itrue
      write (nout,99997) icase, n, incx, incy, mode, icomp, itrue, id
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode                               ',
     +       ' comp                                true     difference',
     +       /1x)
99997 format (1x,i4,i3,3i5,2i36,i12)
      end
