#pragma -xO
* source: lapack-3.1.1
      program dblat1
*     test program for the double precision level 1 blas.
*     based upon the original blas test routine together with:
*     f06eaf example program text
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      double precision sfac
      integer          ic
*     .. external subroutines ..
      external         check0, check1, check2, check3, header
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             sfac/9.765625d-4/
*     .. executable statements ..
      write (nout,99999)
      do 20 ic = 1, 10
         icase = ic
         call header
*
*        .. initialize  pass,  incx,  incy, and mode for a new case. ..
*        .. the value 9999 for incx, incy or mode will appear in the ..
*        .. detailed  output, if any, for cases  that do not involve ..
*        .. these parameters ..
*
         pass = .true.
         incx = 9999
         incy = 9999
         mode = 9999
         if (icase.eq.3) then
            call check0(sfac)
         else if (icase.eq.7 .or. icase.eq.8 .or. icase.eq.9 .or.
     +            icase.eq.10) then
            call check1(sfac)
         else if (icase.eq.1 .or. icase.eq.2 .or. icase.eq.5 .or.
     +            icase.eq.6) then
            call check2(sfac)
         else if (icase.eq.4) then
            call check3(sfac)
         end if
*        -- print
         if (pass) write (nout,99998)
   20 continue
      stop
*
99999 format (' real blas test program results',/1x)
99998 format ('                                    ----- pass -----')
      end
      subroutine header
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local arrays ..
      character*6      l(10)
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             l(1)/' ddot '/
      data             l(2)/'daxpy '/
      data             l(3)/'drotg '/
      data             l(4)/' drot '/
      data             l(5)/'dcopy '/
      data             l(6)/'dswap '/
      data             l(7)/'dnrm2 '/
      data             l(8)/'dasum '/
      data             l(9)/'dscal '/
      data             l(10)/'idamax'/
*     .. executable statements ..
      write (nout,99999) icase, l(icase)
      return
*
99999 format (/' test of subprogram number',i3,12x,a6)
      end
      subroutine check0(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      double precision  sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      double precision  d12, sa, sb, sc, ss
      integer           k
*     .. local arrays ..
      double precision  da1(8), datrue(8), db1(8), dbtrue(8), dc1(8),
     +                  ds1(8)
*     .. external subroutines ..
      external          drotg, stest1
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              da1/0.3d0, 0.4d0, -0.3d0, -0.4d0, -0.3d0, 0.0d0,
     +                  0.0d0, 1.0d0/
      data              db1/0.4d0, 0.3d0, 0.4d0, 0.3d0, -0.4d0, 0.0d0,
     +                  1.0d0, 0.0d0/
      data              dc1/0.6d0, 0.8d0, -0.6d0, 0.8d0, 0.6d0, 1.0d0,
     +                  0.0d0, 1.0d0/
      data              ds1/0.8d0, 0.6d0, 0.8d0, -0.6d0, 0.8d0, 0.0d0,
     +                  1.0d0, 0.0d0/
      data              datrue/0.5d0, 0.5d0, 0.5d0, -0.5d0, -0.5d0,
     +                  0.0d0, 1.0d0, 1.0d0/
      data              dbtrue/0.0d0, 0.6d0, 0.0d0, -0.6d0, 0.0d0,
     +                  0.0d0, 1.0d0, 0.0d0/
      data              d12/4096.0d0/
*     .. executable statements ..
*
*     compute true values which cannot be prestored
*     in decimal notation
*
      dbtrue(1) = 1.0d0/0.6d0
      dbtrue(3) = -1.0d0/0.6d0
      dbtrue(5) = 1.0d0/0.6d0
*
      do 20 k = 1, 8
*        .. set n=k for identification in output if any ..
         n = k
         if (icase.eq.3) then
*           .. drotg ..
            if (k.gt.8) go to 40
            sa = da1(k)
            sb = db1(k)
            call drotg(sa,sb,sc,ss)
            call stest1(sa,datrue(k),datrue(k),sfac)
            call stest1(sb,dbtrue(k),dbtrue(k),sfac)
            call stest1(sc,dc1(k),dc1(k),sfac)
            call stest1(ss,ds1(k),ds1(k),sfac)
         else
            write (nout,*) ' shouldn''t be here in check0'
            stop
         end if
   20 continue
   40 return
      end
      subroutine check1(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      double precision  sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      integer           i, len, np1
*     .. local arrays ..
      double precision  dtrue1(5), dtrue3(5), dtrue5(8,5,2), dv(8,5,2),
     +                  sa(10), stemp(1), strue(8), sx(8)
      integer           itrue2(5)
*     .. external functions ..
      double precision  dasum, dnrm2
      integer           idamax
      external          dasum, dnrm2, idamax
*     .. external subroutines ..
      external          itest1, dscal, stest, stest1
*     .. intrinsic functions ..
      intrinsic         max
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa/0.3d0, -1.0d0, 0.0d0, 1.0d0, 0.3d0, 0.3d0,
     +                  0.3d0, 0.3d0, 0.3d0, 0.3d0/
      data              dv/0.1d0, 2.0d0, 2.0d0, 2.0d0, 2.0d0, 2.0d0,
     +                  2.0d0, 2.0d0, 0.3d0, 3.0d0, 3.0d0, 3.0d0, 3.0d0,
     +                  3.0d0, 3.0d0, 3.0d0, 0.3d0, -0.4d0, 4.0d0,
     +                  4.0d0, 4.0d0, 4.0d0, 4.0d0, 4.0d0, 0.2d0,
     +                  -0.6d0, 0.3d0, 5.0d0, 5.0d0, 5.0d0, 5.0d0,
     +                  5.0d0, 0.1d0, -0.3d0, 0.5d0, -0.1d0, 6.0d0,
     +                  6.0d0, 6.0d0, 6.0d0, 0.1d0, 8.0d0, 8.0d0, 8.0d0,
     +                  8.0d0, 8.0d0, 8.0d0, 8.0d0, 0.3d0, 9.0d0, 9.0d0,
     +                  9.0d0, 9.0d0, 9.0d0, 9.0d0, 9.0d0, 0.3d0, 2.0d0,
     +                  -0.4d0, 2.0d0, 2.0d0, 2.0d0, 2.0d0, 2.0d0,
     +                  0.2d0, 3.0d0, -0.6d0, 5.0d0, 0.3d0, 2.0d0,
     +                  2.0d0, 2.0d0, 0.1d0, 4.0d0, -0.3d0, 6.0d0,
     +                  -0.5d0, 7.0d0, -0.1d0, 3.0d0/
      data              dtrue1/0.0d0, 0.3d0, 0.5d0, 0.7d0, 0.6d0/
      data              dtrue3/0.0d0, 0.3d0, 0.7d0, 1.1d0, 1.0d0/
      data              dtrue5/0.10d0, 2.0d0, 2.0d0, 2.0d0, 2.0d0,
     +                  2.0d0, 2.0d0, 2.0d0, -0.3d0, 3.0d0, 3.0d0,
     +                  3.0d0, 3.0d0, 3.0d0, 3.0d0, 3.0d0, 0.0d0, 0.0d0,
     +                  4.0d0, 4.0d0, 4.0d0, 4.0d0, 4.0d0, 4.0d0,
     +                  0.20d0, -0.60d0, 0.30d0, 5.0d0, 5.0d0, 5.0d0,
     +                  5.0d0, 5.0d0, 0.03d0, -0.09d0, 0.15d0, -0.03d0,
     +                  6.0d0, 6.0d0, 6.0d0, 6.0d0, 0.10d0, 8.0d0,
     +                  8.0d0, 8.0d0, 8.0d0, 8.0d0, 8.0d0, 8.0d0,
     +                  0.09d0, 9.0d0, 9.0d0, 9.0d0, 9.0d0, 9.0d0,
     +                  9.0d0, 9.0d0, 0.09d0, 2.0d0, -0.12d0, 2.0d0,
     +                  2.0d0, 2.0d0, 2.0d0, 2.0d0, 0.06d0, 3.0d0,
     +                  -0.18d0, 5.0d0, 0.09d0, 2.0d0, 2.0d0, 2.0d0,
     +                  0.03d0, 4.0d0, -0.09d0, 6.0d0, -0.15d0, 7.0d0,
     +                  -0.03d0, 3.0d0/
      data              itrue2/0, 1, 2, 2, 3/
*     .. executable statements ..
      do 80 incx = 1, 2
         do 60 np1 = 1, 5
            n = np1 - 1
            len = 2*max(n,1)
*           .. set vector arguments ..
            do 20 i = 1, len
               sx(i) = dv(i,np1,incx)
   20       continue
*
            if (icase.eq.7) then
*              .. dnrm2 ..
               stemp(1) = dtrue1(np1)
               call stest1(dnrm2(n,sx,incx),stemp(1),stemp,sfac)
            else if (icase.eq.8) then
*              .. dasum ..
               stemp(1) = dtrue3(np1)
               call stest1(dasum(n,sx,incx),stemp(1),stemp,sfac)
            else if (icase.eq.9) then
*              .. dscal ..
               call dscal(n,sa((incx-1)*5+np1),sx,incx)
               do 40 i = 1, len
                  strue(i) = dtrue5(i,np1,incx)
   40          continue
               call stest(len,sx,strue,strue,sfac)
            else if (icase.eq.10) then
*              .. idamax ..
               call itest1(idamax(n,sx,incx),itrue2(np1))
            else
               write (nout,*) ' shouldn''t be here in check1'
               stop
            end if
   60    continue
   80 continue
      return
      end
      subroutine check2(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      double precision  sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      double precision  sa, sc, ss
      integer           i, j, ki, kn, ksize, lenx, leny, mx, my
*     .. local arrays ..
      double precision  dt10x(7,4,4), dt10y(7,4,4), dt7(4,4),
     +                  dt8(7,4,4), dt9x(7,4,4), dt9y(7,4,4), dx1(7),
     +                  dy1(7), ssize1(4), ssize2(14,2), stx(7), sty(7),
     +                  sx(7), sy(7)
      integer           incxs(4), incys(4), lens(4,2), ns(4)
*     .. external functions ..
      double precision  ddot
      external          ddot
*     .. external subroutines ..
      external          daxpy, dcopy, dswap, stest, stest1
*     .. intrinsic functions ..
      intrinsic         abs, min
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa/0.3d0/
      data              incxs/1, 2, -2, -1/
      data              incys/1, -2, 1, -2/
      data              lens/1, 1, 2, 4, 1, 1, 3, 7/
      data              ns/0, 1, 2, 4/
      data              dx1/0.6d0, 0.1d0, -0.5d0, 0.8d0, 0.9d0, -0.3d0,
     +                  -0.4d0/
      data              dy1/0.5d0, -0.9d0, 0.3d0, 0.7d0, -0.6d0, 0.2d0,
     +                  0.8d0/
      data              sc, ss/0.8d0, 0.6d0/
      data              dt7/0.0d0, 0.30d0, 0.21d0, 0.62d0, 0.0d0,
     +                  0.30d0, -0.07d0, 0.85d0, 0.0d0, 0.30d0, -0.79d0,
     +                  -0.74d0, 0.0d0, 0.30d0, 0.33d0, 1.27d0/
      data              dt8/0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.68d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.68d0, -0.87d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.68d0, -0.87d0, 0.15d0,
     +                  0.94d0, 0.0d0, 0.0d0, 0.0d0, 0.5d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.68d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.35d0, -0.9d0, 0.48d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.38d0, -0.9d0, 0.57d0, 0.7d0, -0.75d0,
     +                  0.2d0, 0.98d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.68d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.35d0, -0.72d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.38d0,
     +                  -0.63d0, 0.15d0, 0.88d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.68d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.68d0, -0.9d0, 0.33d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.68d0, -0.9d0, 0.33d0, 0.7d0,
     +                  -0.75d0, 0.2d0, 1.04d0/
      data              dt9x/0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.78d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.78d0, -0.46d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.78d0, -0.46d0, -0.22d0,
     +                  1.06d0, 0.0d0, 0.0d0, 0.0d0, 0.6d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.78d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.66d0, 0.1d0, -0.1d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.96d0, 0.1d0, -0.76d0, 0.8d0, 0.90d0,
     +                  -0.3d0, -0.02d0, 0.6d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.78d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, -0.06d0, 0.1d0,
     +                  -0.1d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.90d0,
     +                  0.1d0, -0.22d0, 0.8d0, 0.18d0, -0.3d0, -0.02d0,
     +                  0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.78d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.78d0, 0.26d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.78d0, 0.26d0, -0.76d0, 1.12d0,
     +                  0.0d0, 0.0d0, 0.0d0/
      data              dt9y/0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.04d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.04d0, -0.78d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.04d0, -0.78d0, 0.54d0,
     +                  0.08d0, 0.0d0, 0.0d0, 0.0d0, 0.5d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.04d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.7d0,
     +                  -0.9d0, -0.12d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.64d0, -0.9d0, -0.30d0, 0.7d0, -0.18d0, 0.2d0,
     +                  0.28d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.04d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.7d0, -1.08d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.64d0, -1.26d0,
     +                  0.54d0, 0.20d0, 0.0d0, 0.0d0, 0.0d0, 0.5d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.04d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.04d0, -0.9d0, 0.18d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.04d0, -0.9d0, 0.18d0, 0.7d0,
     +                  -0.18d0, 0.2d0, 0.16d0/
      data              dt10x/0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.5d0, -0.9d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.5d0, -0.9d0, 0.3d0, 0.7d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.6d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.3d0, 0.1d0, 0.5d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.8d0, 0.1d0, -0.6d0,
     +                  0.8d0, 0.3d0, -0.3d0, 0.5d0, 0.6d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.5d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, -0.9d0,
     +                  0.1d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.7d0,
     +                  0.1d0, 0.3d0, 0.8d0, -0.9d0, -0.3d0, 0.5d0,
     +                  0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.5d0, 0.3d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.5d0, 0.3d0, -0.6d0, 0.8d0, 0.0d0, 0.0d0,
     +                  0.0d0/
      data              dt10y/0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.6d0, 0.1d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.6d0, 0.1d0, -0.5d0, 0.8d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, -0.5d0, -0.9d0, 0.6d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, -0.4d0, -0.9d0, 0.9d0,
     +                  0.7d0, -0.5d0, 0.2d0, 0.6d0, 0.5d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.6d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, -0.5d0,
     +                  0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  -0.4d0, 0.9d0, -0.5d0, 0.6d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.6d0, -0.9d0, 0.1d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.6d0, -0.9d0, 0.1d0, 0.7d0,
     +                  -0.5d0, 0.2d0, 0.8d0/
      data              ssize1/0.0d0, 0.3d0, 1.6d0, 3.2d0/
      data              ssize2/0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0,
     +                  1.17d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0,
     +                  1.17d0, 1.17d0, 1.17d0/
*     .. executable statements ..
*
      do 120 ki = 1, 4
         incx = incxs(ki)
         incy = incys(ki)
         mx = abs(incx)
         my = abs(incy)
*
         do 100 kn = 1, 4
            n = ns(kn)
            ksize = min(2,kn)
            lenx = lens(kn,mx)
            leny = lens(kn,my)
*           .. initialize all argument arrays ..
            do 20 i = 1, 7
               sx(i) = dx1(i)
               sy(i) = dy1(i)
   20       continue
*
            if (icase.eq.1) then
*              .. ddot ..
               call stest1(ddot(n,sx,incx,sy,incy),dt7(kn,ki),ssize1(kn)
     +                     ,sfac)
            else if (icase.eq.2) then
*              .. daxpy ..
               call daxpy(n,sa,sx,incx,sy,incy)
               do 40 j = 1, leny
                  sty(j) = dt8(j,kn,ki)
   40          continue
               call stest(leny,sy,sty,ssize2(1,ksize),sfac)
            else if (icase.eq.5) then
*              .. dcopy ..
               do 60 i = 1, 7
                  sty(i) = dt10y(i,kn,ki)
   60          continue
               call dcopy(n,sx,incx,sy,incy)
               call stest(leny,sy,sty,ssize2(1,1),1.0d0)
            else if (icase.eq.6) then
*              .. dswap ..
               call dswap(n,sx,incx,sy,incy)
               do 80 i = 1, 7
                  stx(i) = dt10x(i,kn,ki)
                  sty(i) = dt10y(i,kn,ki)
   80          continue
               call stest(lenx,sx,stx,ssize2(1,1),1.0d0)
               call stest(leny,sy,sty,ssize2(1,1),1.0d0)
            else
               write (nout,*) ' shouldn''t be here in check2'
               stop
            end if
  100    continue
  120 continue
      return
      end
      subroutine check3(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      double precision  sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      double precision  sa, sc, ss
      integer           i, k, ki, kn, ksize, lenx, leny, mx, my
*     .. local arrays ..
      double precision  copyx(5), copyy(5), dt9x(7,4,4), dt9y(7,4,4),
     +                  dx1(7), dy1(7), mwpc(11), mwps(11), mwpstx(5),
     +                  mwpsty(5), mwptx(11,5), mwpty(11,5), mwpx(5),
     +                  mwpy(5), ssize2(14,2), stx(7), sty(7), sx(7),
     +                  sy(7)
      integer           incxs(4), incys(4), lens(4,2), mwpinx(11),
     +                  mwpiny(11), mwpn(11), ns(4)
*     .. external subroutines ..
      external          drot, stest
*     .. intrinsic functions ..
      intrinsic         abs, min
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa/0.3d0/
      data              incxs/1, 2, -2, -1/
      data              incys/1, -2, 1, -2/
      data              lens/1, 1, 2, 4, 1, 1, 3, 7/
      data              ns/0, 1, 2, 4/
      data              dx1/0.6d0, 0.1d0, -0.5d0, 0.8d0, 0.9d0, -0.3d0,
     +                  -0.4d0/
      data              dy1/0.5d0, -0.9d0, 0.3d0, 0.7d0, -0.6d0, 0.2d0,
     +                  0.8d0/
      data              sc, ss/0.8d0, 0.6d0/
      data              dt9x/0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.78d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.78d0, -0.46d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.78d0, -0.46d0, -0.22d0,
     +                  1.06d0, 0.0d0, 0.0d0, 0.0d0, 0.6d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.78d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.66d0, 0.1d0, -0.1d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.96d0, 0.1d0, -0.76d0, 0.8d0, 0.90d0,
     +                  -0.3d0, -0.02d0, 0.6d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.78d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, -0.06d0, 0.1d0,
     +                  -0.1d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.90d0,
     +                  0.1d0, -0.22d0, 0.8d0, 0.18d0, -0.3d0, -0.02d0,
     +                  0.6d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.78d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.78d0, 0.26d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.78d0, 0.26d0, -0.76d0, 1.12d0,
     +                  0.0d0, 0.0d0, 0.0d0/
      data              dt9y/0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.04d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.04d0, -0.78d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.04d0, -0.78d0, 0.54d0,
     +                  0.08d0, 0.0d0, 0.0d0, 0.0d0, 0.5d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.04d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.7d0,
     +                  -0.9d0, -0.12d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.64d0, -0.9d0, -0.30d0, 0.7d0, -0.18d0, 0.2d0,
     +                  0.28d0, 0.5d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.04d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.7d0, -1.08d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.64d0, -1.26d0,
     +                  0.54d0, 0.20d0, 0.0d0, 0.0d0, 0.0d0, 0.5d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.04d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.04d0, -0.9d0, 0.18d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.04d0, -0.9d0, 0.18d0, 0.7d0,
     +                  -0.18d0, 0.2d0, 0.16d0/
      data              ssize2/0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0, 0.0d0,
     +                  0.0d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0,
     +                  1.17d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0, 1.17d0,
     +                  1.17d0, 1.17d0, 1.17d0/
*     .. executable statements ..
*
      do 60 ki = 1, 4
         incx = incxs(ki)
         incy = incys(ki)
         mx = abs(incx)
         my = abs(incy)
*
         do 40 kn = 1, 4
            n = ns(kn)
            ksize = min(2,kn)
            lenx = lens(kn,mx)
            leny = lens(kn,my)
*
            if (icase.eq.4) then
*              .. drot ..
               do 20 i = 1, 7
                  sx(i) = dx1(i)
                  sy(i) = dy1(i)
                  stx(i) = dt9x(i,kn,ki)
                  sty(i) = dt9y(i,kn,ki)
   20          continue
               call drot(n,sx,incx,sy,incy,sc,ss)
               call stest(lenx,sx,stx,ssize2(1,ksize),sfac)
               call stest(leny,sy,sty,ssize2(1,ksize),sfac)
            else
               write (nout,*) ' shouldn''t be here in check3'
               stop
            end if
   40    continue
   60 continue
*
      mwpc(1) = 1
      do 80 i = 2, 11
         mwpc(i) = 0
   80 continue
      mwps(1) = 0
      do 100 i = 2, 6
         mwps(i) = 1
  100 continue
      do 120 i = 7, 11
         mwps(i) = -1
  120 continue
      mwpinx(1) = 1
      mwpinx(2) = 1
      mwpinx(3) = 1
      mwpinx(4) = -1
      mwpinx(5) = 1
      mwpinx(6) = -1
      mwpinx(7) = 1
      mwpinx(8) = 1
      mwpinx(9) = -1
      mwpinx(10) = 1
      mwpinx(11) = -1
      mwpiny(1) = 1
      mwpiny(2) = 1
      mwpiny(3) = -1
      mwpiny(4) = -1
      mwpiny(5) = 2
      mwpiny(6) = 1
      mwpiny(7) = 1
      mwpiny(8) = -1
      mwpiny(9) = -1
      mwpiny(10) = 2
      mwpiny(11) = 1
      do 140 i = 1, 11
         mwpn(i) = 5
  140 continue
      mwpn(5) = 3
      mwpn(10) = 3
      do 160 i = 1, 5
         mwpx(i) = i
         mwpy(i) = i
         mwptx(1,i) = i
         mwpty(1,i) = i
         mwptx(2,i) = i
         mwpty(2,i) = -i
         mwptx(3,i) = 6 - i
         mwpty(3,i) = i - 6
         mwptx(4,i) = i
         mwpty(4,i) = -i
         mwptx(6,i) = 6 - i
         mwpty(6,i) = i - 6
         mwptx(7,i) = -i
         mwpty(7,i) = i
         mwptx(8,i) = i - 6
         mwpty(8,i) = 6 - i
         mwptx(9,i) = -i
         mwpty(9,i) = i
         mwptx(11,i) = i - 6
         mwpty(11,i) = 6 - i
  160 continue
      mwptx(5,1) = 1
      mwptx(5,2) = 3
      mwptx(5,3) = 5
      mwptx(5,4) = 4
      mwptx(5,5) = 5
      mwpty(5,1) = -1
      mwpty(5,2) = 2
      mwpty(5,3) = -2
      mwpty(5,4) = 4
      mwpty(5,5) = -3
      mwptx(10,1) = -1
      mwptx(10,2) = -3
      mwptx(10,3) = -5
      mwptx(10,4) = 4
      mwptx(10,5) = 5
      mwpty(10,1) = 1
      mwpty(10,2) = 2
      mwpty(10,3) = 2
      mwpty(10,4) = 4
      mwpty(10,5) = 3
      do 200 i = 1, 11
         incx = mwpinx(i)
         incy = mwpiny(i)
         do 180 k = 1, 5
            copyx(k) = mwpx(k)
            copyy(k) = mwpy(k)
            mwpstx(k) = mwptx(i,k)
            mwpsty(k) = mwpty(i,k)
  180    continue
         call drot(mwpn(i),copyx,incx,copyy,incy,mwpc(i),mwps(i))
         call stest(5,copyx,mwpstx,mwpstx,sfac)
         call stest(5,copyy,mwpsty,mwpsty,sfac)
  200 continue
      return
      end
      subroutine stest(len,scomp,strue,ssize,sfac)
*     ********************************* stest **************************
*
*     this subr compares arrays  scomp() and strue() of length len to
*     see if the term by term differences, multiplied by sfac, are
*     negligible.
*
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalar arguments ..
      double precision sfac
      integer          len
*     .. array arguments ..
      double precision scomp(len), ssize(len), strue(len)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      double precision sd
      integer          i
*     .. external functions ..
      double precision sdiff
      external         sdiff
*     .. intrinsic functions ..
      intrinsic        abs
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
*
      do 40 i = 1, len
         sd = scomp(i) - strue(i)
         if (sdiff(abs(ssize(i))+abs(sfac*sd),abs(ssize(i))).eq.0.0d0)
     +       go to 40
*
*                             here    scomp(i) is not close to strue(i).
*
         if ( .not. pass) go to 20
*                             print fail message and header.
         pass = .false.
         write (nout,99999)
         write (nout,99998)
   20    write (nout,99997) icase, n, incx, incy, mode, i, scomp(i),
     +     strue(i), sd, ssize(i)
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode  i                            ',
     +       ' comp(i)                             true(i)  difference',
     +       '     size(i)',/1x)
99997 format (1x,i4,i3,3i5,i3,2d36.8,2d12.4)
      end
      subroutine stest1(scomp1,strue1,ssize,sfac)
*     ************************* stest1 *****************************
*
*     this is an interface subroutine to accomodate the fortran
*     requirement that when a dummy argument is an array, the
*     actual argument must also be an array or an array element.
*
*     c.l. lawson, jpl, 1978 dec 6
*
*     .. scalar arguments ..
      double precision  scomp1, sfac, strue1
*     .. array arguments ..
      double precision  ssize(*)
*     .. local arrays ..
      double precision  scomp(1), strue(1)
*     .. external subroutines ..
      external          stest
*     .. executable statements ..
*
      scomp(1) = scomp1
      strue(1) = strue1
      call stest(1,scomp,strue,ssize,sfac)
*
      return
      end
      double precision function sdiff(sa,sb)
*     ********************************* sdiff **************************
*     computes difference of two numbers.  c. l. lawson, jpl 1974 feb 15
*
*     .. scalar arguments ..
      double precision                sa, sb
*     .. executable statements ..
      sdiff = sa - sb
      return
      end
      subroutine itest1(icomp,itrue)
*     ********************************* itest1 *************************
*
*     this subroutine compares the variables icomp and itrue for
*     equality.
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      integer           icomp, itrue
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      integer           id
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
*
      if (icomp.eq.itrue) go to 40
*
*                            here icomp is not equal to itrue.
*
      if ( .not. pass) go to 20
*                             print fail message and header.
      pass = .false.
      write (nout,99999)
      write (nout,99998)
   20 id = icomp - itrue
      write (nout,99997) icase, n, incx, incy, mode, icomp, itrue, id
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode                               ',
     +       ' comp                                true     difference',
     +       /1x)
99997 format (1x,i4,i3,3i5,2i36,i12)
      end
