#pragma -xO
* source: lapack-3.1.1
      program sblat1
*     test program for the real             level 1 blas.
*     based upon the original blas test routine together with:
*     f06eaf example program text
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      real             sfac
      integer          ic
*     .. external subroutines ..
      external         check0, check1, check2, check3, header
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             sfac/9.765625e-4/
*     .. executable statements ..
      write (nout,99999)
      do 20 ic = 1, 10
         icase = ic
         call header
*
*        .. initialize  pass,  incx,  incy, and mode for a new case. ..
*        .. the value 9999 for incx, incy or mode will appear in the ..
*        .. detailed  output, if any, for cases  that do not involve ..
*        .. these parameters ..
*
         pass = .true.
         incx = 9999
         incy = 9999
         mode = 9999
         if (icase.eq.3) then
            call check0(sfac)
         else if (icase.eq.7 .or. icase.eq.8 .or. icase.eq.9 .or.
     +            icase.eq.10) then
            call check1(sfac)
         else if (icase.eq.1 .or. icase.eq.2 .or. icase.eq.5 .or.
     +            icase.eq.6) then
            call check2(sfac)
         else if (icase.eq.4) then
            call check3(sfac)
         end if
*        -- print
         if (pass) write (nout,99998)
   20 continue
      stop
*
99999 format (' real blas test program results',/1x)
99998 format ('                                    ----- pass -----')
      end
      subroutine header
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local arrays ..
      character*6      l(10)
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             l(1)/' sdot '/
      data             l(2)/'saxpy '/
      data             l(3)/'srotg '/
      data             l(4)/' srot '/
      data             l(5)/'scopy '/
      data             l(6)/'sswap '/
      data             l(7)/'snrm2 '/
      data             l(8)/'sasum '/
      data             l(9)/'sscal '/
      data             l(10)/'isamax'/
*     .. executable statements ..
      write (nout,99999) icase, l(icase)
      return
*
99999 format (/' test of subprogram number',i3,12x,a6)
      end
      subroutine check0(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      real              sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      real              d12, sa, sb, sc, ss
      integer           k
*     .. local arrays ..
      real              da1(8), datrue(8), db1(8), dbtrue(8), dc1(8),
     +                  ds1(8)
*     .. external subroutines ..
      external          srotg, stest1
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              da1/0.3e0, 0.4e0, -0.3e0, -0.4e0, -0.3e0, 0.0e0,
     +                  0.0e0, 1.0e0/
      data              db1/0.4e0, 0.3e0, 0.4e0, 0.3e0, -0.4e0, 0.0e0,
     +                  1.0e0, 0.0e0/
      data              dc1/0.6e0, 0.8e0, -0.6e0, 0.8e0, 0.6e0, 1.0e0,
     +                  0.0e0, 1.0e0/
      data              ds1/0.8e0, 0.6e0, 0.8e0, -0.6e0, 0.8e0, 0.0e0,
     +                  1.0e0, 0.0e0/
      data              datrue/0.5e0, 0.5e0, 0.5e0, -0.5e0, -0.5e0,
     +                  0.0e0, 1.0e0, 1.0e0/
      data              dbtrue/0.0e0, 0.6e0, 0.0e0, -0.6e0, 0.0e0,
     +                  0.0e0, 1.0e0, 0.0e0/
      data              d12/4096.0e0/
*     .. executable statements ..
*
*     compute true values which cannot be prestored
*     in decimal notation
*
      dbtrue(1) = 1.0e0/0.6e0
      dbtrue(3) = -1.0e0/0.6e0
      dbtrue(5) = 1.0e0/0.6e0
*
      do 20 k = 1, 8
*        .. set n=k for identification in output if any ..
         n = k
         if (icase.eq.3) then
*           .. srotg ..
            if (k.gt.8) go to 40
            sa = da1(k)
            sb = db1(k)
            call srotg(sa,sb,sc,ss)
            call stest1(sa,datrue(k),datrue(k),sfac)
            call stest1(sb,dbtrue(k),dbtrue(k),sfac)
            call stest1(sc,dc1(k),dc1(k),sfac)
            call stest1(ss,ds1(k),ds1(k),sfac)
         else
            write (nout,*) ' shouldn''t be here in check0'
            stop
         end if
   20 continue
   40 return
      end
      subroutine check1(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      real              sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      integer           i, len, np1
*     .. local arrays ..
      real              dtrue1(5), dtrue3(5), dtrue5(8,5,2), dv(8,5,2),
     +                  sa(10), stemp(1), strue(8), sx(8)
      integer           itrue2(5)
*     .. external functions ..
      real              sasum, snrm2
      integer           isamax
      external          sasum, snrm2, isamax
*     .. external subroutines ..
      external          itest1, sscal, stest, stest1
*     .. intrinsic functions ..
      intrinsic         max
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa/0.3e0, -1.0e0, 0.0e0, 1.0e0, 0.3e0, 0.3e0,
     +                  0.3e0, 0.3e0, 0.3e0, 0.3e0/
      data              dv/0.1e0, 2.0e0, 2.0e0, 2.0e0, 2.0e0, 2.0e0,
     +                  2.0e0, 2.0e0, 0.3e0, 3.0e0, 3.0e0, 3.0e0, 3.0e0,
     +                  3.0e0, 3.0e0, 3.0e0, 0.3e0, -0.4e0, 4.0e0,
     +                  4.0e0, 4.0e0, 4.0e0, 4.0e0, 4.0e0, 0.2e0,
     +                  -0.6e0, 0.3e0, 5.0e0, 5.0e0, 5.0e0, 5.0e0,
     +                  5.0e0, 0.1e0, -0.3e0, 0.5e0, -0.1e0, 6.0e0,
     +                  6.0e0, 6.0e0, 6.0e0, 0.1e0, 8.0e0, 8.0e0, 8.0e0,
     +                  8.0e0, 8.0e0, 8.0e0, 8.0e0, 0.3e0, 9.0e0, 9.0e0,
     +                  9.0e0, 9.0e0, 9.0e0, 9.0e0, 9.0e0, 0.3e0, 2.0e0,
     +                  -0.4e0, 2.0e0, 2.0e0, 2.0e0, 2.0e0, 2.0e0,
     +                  0.2e0, 3.0e0, -0.6e0, 5.0e0, 0.3e0, 2.0e0,
     +                  2.0e0, 2.0e0, 0.1e0, 4.0e0, -0.3e0, 6.0e0,
     +                  -0.5e0, 7.0e0, -0.1e0, 3.0e0/
      data              dtrue1/0.0e0, 0.3e0, 0.5e0, 0.7e0, 0.6e0/
      data              dtrue3/0.0e0, 0.3e0, 0.7e0, 1.1e0, 1.0e0/
      data              dtrue5/0.10e0, 2.0e0, 2.0e0, 2.0e0, 2.0e0,
     +                  2.0e0, 2.0e0, 2.0e0, -0.3e0, 3.0e0, 3.0e0,
     +                  3.0e0, 3.0e0, 3.0e0, 3.0e0, 3.0e0, 0.0e0, 0.0e0,
     +                  4.0e0, 4.0e0, 4.0e0, 4.0e0, 4.0e0, 4.0e0,
     +                  0.20e0, -0.60e0, 0.30e0, 5.0e0, 5.0e0, 5.0e0,
     +                  5.0e0, 5.0e0, 0.03e0, -0.09e0, 0.15e0, -0.03e0,
     +                  6.0e0, 6.0e0, 6.0e0, 6.0e0, 0.10e0, 8.0e0,
     +                  8.0e0, 8.0e0, 8.0e0, 8.0e0, 8.0e0, 8.0e0,
     +                  0.09e0, 9.0e0, 9.0e0, 9.0e0, 9.0e0, 9.0e0,
     +                  9.0e0, 9.0e0, 0.09e0, 2.0e0, -0.12e0, 2.0e0,
     +                  2.0e0, 2.0e0, 2.0e0, 2.0e0, 0.06e0, 3.0e0,
     +                  -0.18e0, 5.0e0, 0.09e0, 2.0e0, 2.0e0, 2.0e0,
     +                  0.03e0, 4.0e0, -0.09e0, 6.0e0, -0.15e0, 7.0e0,
     +                  -0.03e0, 3.0e0/
      data              itrue2/0, 1, 2, 2, 3/
*     .. executable statements ..
      do 80 incx = 1, 2
         do 60 np1 = 1, 5
            n = np1 - 1
            len = 2*max(n,1)
*           .. set vector arguments ..
            do 20 i = 1, len
               sx(i) = dv(i,np1,incx)
   20       continue
*
            if (icase.eq.7) then
*              .. snrm2 ..
               stemp(1) = dtrue1(np1)
               call stest1(snrm2(n,sx,incx),stemp(1),stemp,sfac)
            else if (icase.eq.8) then
*              .. sasum ..
               stemp(1) = dtrue3(np1)
               call stest1(sasum(n,sx,incx),stemp(1),stemp,sfac)
            else if (icase.eq.9) then
*              .. sscal ..
               call sscal(n,sa((incx-1)*5+np1),sx,incx)
               do 40 i = 1, len
                  strue(i) = dtrue5(i,np1,incx)
   40          continue
               call stest(len,sx,strue,strue,sfac)
            else if (icase.eq.10) then
*              .. isamax ..
               call itest1(isamax(n,sx,incx),itrue2(np1))
            else
               write (nout,*) ' shouldn''t be here in check1'
               stop
            end if
   60    continue
   80 continue
      return
      end
      subroutine check2(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      real              sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      real              sa, sc, ss
      integer           i, j, ki, kn, ksize, lenx, leny, mx, my
*     .. local arrays ..
      real              dt10x(7,4,4), dt10y(7,4,4), dt7(4,4),
     +                  dt8(7,4,4), dt9x(7,4,4), dt9y(7,4,4), dx1(7),
     +                  dy1(7), ssize1(4), ssize2(14,2), stx(7), sty(7),
     +                  sx(7), sy(7)
      integer           incxs(4), incys(4), lens(4,2), ns(4)
*     .. external functions ..
      real              sdot
      external          sdot
*     .. external subroutines ..
      external          saxpy, scopy, sswap, stest, stest1
*     .. intrinsic functions ..
      intrinsic         abs, min
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa/0.3e0/
      data              incxs/1, 2, -2, -1/
      data              incys/1, -2, 1, -2/
      data              lens/1, 1, 2, 4, 1, 1, 3, 7/
      data              ns/0, 1, 2, 4/
      data              dx1/0.6e0, 0.1e0, -0.5e0, 0.8e0, 0.9e0, -0.3e0,
     +                  -0.4e0/
      data              dy1/0.5e0, -0.9e0, 0.3e0, 0.7e0, -0.6e0, 0.2e0,
     +                  0.8e0/
      data              sc, ss/0.8e0, 0.6e0/
      data              dt7/0.0e0, 0.30e0, 0.21e0, 0.62e0, 0.0e0,
     +                  0.30e0, -0.07e0, 0.85e0, 0.0e0, 0.30e0, -0.79e0,
     +                  -0.74e0, 0.0e0, 0.30e0, 0.33e0, 1.27e0/
      data              dt8/0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.68e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.68e0, -0.87e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.68e0, -0.87e0, 0.15e0,
     +                  0.94e0, 0.0e0, 0.0e0, 0.0e0, 0.5e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.68e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.35e0, -0.9e0, 0.48e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.38e0, -0.9e0, 0.57e0, 0.7e0, -0.75e0,
     +                  0.2e0, 0.98e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.68e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.35e0, -0.72e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.38e0,
     +                  -0.63e0, 0.15e0, 0.88e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.68e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.68e0, -0.9e0, 0.33e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.68e0, -0.9e0, 0.33e0, 0.7e0,
     +                  -0.75e0, 0.2e0, 1.04e0/
      data              dt9x/0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.78e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.78e0, -0.46e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.78e0, -0.46e0, -0.22e0,
     +                  1.06e0, 0.0e0, 0.0e0, 0.0e0, 0.6e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.78e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.66e0, 0.1e0, -0.1e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.96e0, 0.1e0, -0.76e0, 0.8e0, 0.90e0,
     +                  -0.3e0, -0.02e0, 0.6e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.78e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, -0.06e0, 0.1e0,
     +                  -0.1e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.90e0,
     +                  0.1e0, -0.22e0, 0.8e0, 0.18e0, -0.3e0, -0.02e0,
     +                  0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.78e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.78e0, 0.26e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.78e0, 0.26e0, -0.76e0, 1.12e0,
     +                  0.0e0, 0.0e0, 0.0e0/
      data              dt9y/0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.04e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.04e0, -0.78e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.04e0, -0.78e0, 0.54e0,
     +                  0.08e0, 0.0e0, 0.0e0, 0.0e0, 0.5e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.04e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.7e0,
     +                  -0.9e0, -0.12e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.64e0, -0.9e0, -0.30e0, 0.7e0, -0.18e0, 0.2e0,
     +                  0.28e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.04e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.7e0, -1.08e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.64e0, -1.26e0,
     +                  0.54e0, 0.20e0, 0.0e0, 0.0e0, 0.0e0, 0.5e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.04e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.04e0, -0.9e0, 0.18e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.04e0, -0.9e0, 0.18e0, 0.7e0,
     +                  -0.18e0, 0.2e0, 0.16e0/
      data              dt10x/0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.5e0, -0.9e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.5e0, -0.9e0, 0.3e0, 0.7e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.6e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.3e0, 0.1e0, 0.5e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.8e0, 0.1e0, -0.6e0,
     +                  0.8e0, 0.3e0, -0.3e0, 0.5e0, 0.6e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.5e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, -0.9e0,
     +                  0.1e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.7e0,
     +                  0.1e0, 0.3e0, 0.8e0, -0.9e0, -0.3e0, 0.5e0,
     +                  0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.5e0, 0.3e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.5e0, 0.3e0, -0.6e0, 0.8e0, 0.0e0, 0.0e0,
     +                  0.0e0/
      data              dt10y/0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.6e0, 0.1e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.6e0, 0.1e0, -0.5e0, 0.8e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, -0.5e0, -0.9e0, 0.6e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, -0.4e0, -0.9e0, 0.9e0,
     +                  0.7e0, -0.5e0, 0.2e0, 0.6e0, 0.5e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.6e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, -0.5e0,
     +                  0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  -0.4e0, 0.9e0, -0.5e0, 0.6e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.6e0, -0.9e0, 0.1e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.6e0, -0.9e0, 0.1e0, 0.7e0,
     +                  -0.5e0, 0.2e0, 0.8e0/
      data              ssize1/0.0e0, 0.3e0, 1.6e0, 3.2e0/
      data              ssize2/0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0,
     +                  1.17e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0,
     +                  1.17e0, 1.17e0, 1.17e0/
*     .. executable statements ..
*
      do 120 ki = 1, 4
         incx = incxs(ki)
         incy = incys(ki)
         mx = abs(incx)
         my = abs(incy)
*
         do 100 kn = 1, 4
            n = ns(kn)
            ksize = min(2,kn)
            lenx = lens(kn,mx)
            leny = lens(kn,my)
*           .. initialize all argument arrays ..
            do 20 i = 1, 7
               sx(i) = dx1(i)
               sy(i) = dy1(i)
   20       continue
*
            if (icase.eq.1) then
*              .. sdot ..
               call stest1(sdot(n,sx,incx,sy,incy),dt7(kn,ki),ssize1(kn)
     +                     ,sfac)
            else if (icase.eq.2) then
*              .. saxpy ..
               call saxpy(n,sa,sx,incx,sy,incy)
               do 40 j = 1, leny
                  sty(j) = dt8(j,kn,ki)
   40          continue
               call stest(leny,sy,sty,ssize2(1,ksize),sfac)
            else if (icase.eq.5) then
*              .. scopy ..
               do 60 i = 1, 7
                  sty(i) = dt10y(i,kn,ki)
   60          continue
               call scopy(n,sx,incx,sy,incy)
               call stest(leny,sy,sty,ssize2(1,1),1.0e0)
            else if (icase.eq.6) then
*              .. sswap ..
               call sswap(n,sx,incx,sy,incy)
               do 80 i = 1, 7
                  stx(i) = dt10x(i,kn,ki)
                  sty(i) = dt10y(i,kn,ki)
   80          continue
               call stest(lenx,sx,stx,ssize2(1,1),1.0e0)
               call stest(leny,sy,sty,ssize2(1,1),1.0e0)
            else
               write (nout,*) ' shouldn''t be here in check2'
               stop
            end if
  100    continue
  120 continue
      return
      end
      subroutine check3(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      real              sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      real              sa, sc, ss
      integer           i, k, ki, kn, ksize, lenx, leny, mx, my
*     .. local arrays ..
      real              copyx(5), copyy(5), dt9x(7,4,4), dt9y(7,4,4),
     +                  dx1(7), dy1(7), mwpc(11), mwps(11), mwpstx(5),
     +                  mwpsty(5), mwptx(11,5), mwpty(11,5), mwpx(5),
     +                  mwpy(5), ssize2(14,2), stx(7), sty(7), sx(7),
     +                  sy(7)
      integer           incxs(4), incys(4), lens(4,2), mwpinx(11),
     +                  mwpiny(11), mwpn(11), ns(4)
*     .. external subroutines ..
      external          srot, stest
*     .. intrinsic functions ..
      intrinsic         abs, min
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa/0.3e0/
      data              incxs/1, 2, -2, -1/
      data              incys/1, -2, 1, -2/
      data              lens/1, 1, 2, 4, 1, 1, 3, 7/
      data              ns/0, 1, 2, 4/
      data              dx1/0.6e0, 0.1e0, -0.5e0, 0.8e0, 0.9e0, -0.3e0,
     +                  -0.4e0/
      data              dy1/0.5e0, -0.9e0, 0.3e0, 0.7e0, -0.6e0, 0.2e0,
     +                  0.8e0/
      data              sc, ss/0.8e0, 0.6e0/
      data              dt9x/0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.78e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.78e0, -0.46e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.78e0, -0.46e0, -0.22e0,
     +                  1.06e0, 0.0e0, 0.0e0, 0.0e0, 0.6e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.78e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.66e0, 0.1e0, -0.1e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.96e0, 0.1e0, -0.76e0, 0.8e0, 0.90e0,
     +                  -0.3e0, -0.02e0, 0.6e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.78e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, -0.06e0, 0.1e0,
     +                  -0.1e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.90e0,
     +                  0.1e0, -0.22e0, 0.8e0, 0.18e0, -0.3e0, -0.02e0,
     +                  0.6e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.78e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.78e0, 0.26e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.78e0, 0.26e0, -0.76e0, 1.12e0,
     +                  0.0e0, 0.0e0, 0.0e0/
      data              dt9y/0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.04e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.04e0, -0.78e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.04e0, -0.78e0, 0.54e0,
     +                  0.08e0, 0.0e0, 0.0e0, 0.0e0, 0.5e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.04e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.7e0,
     +                  -0.9e0, -0.12e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.64e0, -0.9e0, -0.30e0, 0.7e0, -0.18e0, 0.2e0,
     +                  0.28e0, 0.5e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.04e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.7e0, -1.08e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.64e0, -1.26e0,
     +                  0.54e0, 0.20e0, 0.0e0, 0.0e0, 0.0e0, 0.5e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.04e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.04e0, -0.9e0, 0.18e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.04e0, -0.9e0, 0.18e0, 0.7e0,
     +                  -0.18e0, 0.2e0, 0.16e0/
      data              ssize2/0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0, 0.0e0,
     +                  0.0e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0,
     +                  1.17e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0, 1.17e0,
     +                  1.17e0, 1.17e0, 1.17e0/
*     .. executable statements ..
*
      do 60 ki = 1, 4
         incx = incxs(ki)
         incy = incys(ki)
         mx = abs(incx)
         my = abs(incy)
*
         do 40 kn = 1, 4
            n = ns(kn)
            ksize = min(2,kn)
            lenx = lens(kn,mx)
            leny = lens(kn,my)
*
            if (icase.eq.4) then
*              .. srot ..
               do 20 i = 1, 7
                  sx(i) = dx1(i)
                  sy(i) = dy1(i)
                  stx(i) = dt9x(i,kn,ki)
                  sty(i) = dt9y(i,kn,ki)
   20          continue
               call srot(n,sx,incx,sy,incy,sc,ss)
               call stest(lenx,sx,stx,ssize2(1,ksize),sfac)
               call stest(leny,sy,sty,ssize2(1,ksize),sfac)
            else
               write (nout,*) ' shouldn''t be here in check3'
               stop
            end if
   40    continue
   60 continue
*
      mwpc(1) = 1
      do 80 i = 2, 11
         mwpc(i) = 0
   80 continue
      mwps(1) = 0
      do 100 i = 2, 6
         mwps(i) = 1
  100 continue
      do 120 i = 7, 11
         mwps(i) = -1
  120 continue
      mwpinx(1) = 1
      mwpinx(2) = 1
      mwpinx(3) = 1
      mwpinx(4) = -1
      mwpinx(5) = 1
      mwpinx(6) = -1
      mwpinx(7) = 1
      mwpinx(8) = 1
      mwpinx(9) = -1
      mwpinx(10) = 1
      mwpinx(11) = -1
      mwpiny(1) = 1
      mwpiny(2) = 1
      mwpiny(3) = -1
      mwpiny(4) = -1
      mwpiny(5) = 2
      mwpiny(6) = 1
      mwpiny(7) = 1
      mwpiny(8) = -1
      mwpiny(9) = -1
      mwpiny(10) = 2
      mwpiny(11) = 1
      do 140 i = 1, 11
         mwpn(i) = 5
  140 continue
      mwpn(5) = 3
      mwpn(10) = 3
      do 160 i = 1, 5
         mwpx(i) = i
         mwpy(i) = i
         mwptx(1,i) = i
         mwpty(1,i) = i
         mwptx(2,i) = i
         mwpty(2,i) = -i
         mwptx(3,i) = 6 - i
         mwpty(3,i) = i - 6
         mwptx(4,i) = i
         mwpty(4,i) = -i
         mwptx(6,i) = 6 - i
         mwpty(6,i) = i - 6
         mwptx(7,i) = -i
         mwpty(7,i) = i
         mwptx(8,i) = i - 6
         mwpty(8,i) = 6 - i
         mwptx(9,i) = -i
         mwpty(9,i) = i
         mwptx(11,i) = i - 6
         mwpty(11,i) = 6 - i
  160 continue
      mwptx(5,1) = 1
      mwptx(5,2) = 3
      mwptx(5,3) = 5
      mwptx(5,4) = 4
      mwptx(5,5) = 5
      mwpty(5,1) = -1
      mwpty(5,2) = 2
      mwpty(5,3) = -2
      mwpty(5,4) = 4
      mwpty(5,5) = -3
      mwptx(10,1) = -1
      mwptx(10,2) = -3
      mwptx(10,3) = -5
      mwptx(10,4) = 4
      mwptx(10,5) = 5
      mwpty(10,1) = 1
      mwpty(10,2) = 2
      mwpty(10,3) = 2
      mwpty(10,4) = 4
      mwpty(10,5) = 3
      do 200 i = 1, 11
         incx = mwpinx(i)
         incy = mwpiny(i)
         do 180 k = 1, 5
            copyx(k) = mwpx(k)
            copyy(k) = mwpy(k)
            mwpstx(k) = mwptx(i,k)
            mwpsty(k) = mwpty(i,k)
  180    continue
         call srot(mwpn(i),copyx,incx,copyy,incy,mwpc(i),mwps(i))
         call stest(5,copyx,mwpstx,mwpstx,sfac)
         call stest(5,copyy,mwpsty,mwpsty,sfac)
  200 continue
      return
      end
      subroutine stest(len,scomp,strue,ssize,sfac)
*     ********************************* stest **************************
*
*     this subr compares arrays  scomp() and strue() of length len to
*     see if the term by term differences, multiplied by sfac, are
*     negligible.
*
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalar arguments ..
      real             sfac
      integer          len
*     .. array arguments ..
      real             scomp(len), ssize(len), strue(len)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      real             sd
      integer          i
*     .. external functions ..
      real             sdiff
      external         sdiff
*     .. intrinsic functions ..
      intrinsic        abs
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
*
      do 40 i = 1, len
         sd = scomp(i) - strue(i)
         if (sdiff(abs(ssize(i))+abs(sfac*sd),abs(ssize(i))).eq.0.0e0)
     +       go to 40
*
*                             here    scomp(i) is not close to strue(i).
*
         if ( .not. pass) go to 20
*                             print fail message and header.
         pass = .false.
         write (nout,99999)
         write (nout,99998)
   20    write (nout,99997) icase, n, incx, incy, mode, i, scomp(i),
     +     strue(i), sd, ssize(i)
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode  i                            ',
     +       ' comp(i)                             true(i)  difference',
     +       '     size(i)',/1x)
99997 format (1x,i4,i3,3i5,i3,2e36.8,2e12.4)
      end
      subroutine stest1(scomp1,strue1,ssize,sfac)
*     ************************* stest1 *****************************
*
*     this is an interface subroutine to accomodate the fortran
*     requirement that when a dummy argument is an array, the
*     actual argument must also be an array or an array element.
*
*     c.l. lawson, jpl, 1978 dec 6
*
*     .. scalar arguments ..
      real              scomp1, sfac, strue1
*     .. array arguments ..
      real              ssize(*)
*     .. local arrays ..
      real              scomp(1), strue(1)
*     .. external subroutines ..
      external          stest
*     .. executable statements ..
*
      scomp(1) = scomp1
      strue(1) = strue1
      call stest(1,scomp,strue,ssize,sfac)
*
      return
      end
      real             function sdiff(sa,sb)
*     ********************************* sdiff **************************
*     computes difference of two numbers.  c. l. lawson, jpl 1974 feb 15
*
*     .. scalar arguments ..
      real                            sa, sb
*     .. executable statements ..
      sdiff = sa - sb
      return
      end
      subroutine itest1(icomp,itrue)
*     ********************************* itest1 *************************
*
*     this subroutine compares the variables icomp and itrue for
*     equality.
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      integer           icomp, itrue
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      integer           id
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
*
      if (icomp.eq.itrue) go to 40
*
*                            here icomp is not equal to itrue.
*
      if ( .not. pass) go to 20
*                             print fail message and header.
      pass = .false.
      write (nout,99999)
      write (nout,99998)
   20 id = icomp - itrue
      write (nout,99997) icase, n, incx, incy, mode, icomp, itrue, id
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode                               ',
     +       ' comp                                true     difference',
     +       /1x)
99997 format (1x,i4,i3,3i5,2i36,i12)
      end
