#pragma -xO
* source: lapack-3.1.1
      program zblat1
*     test program for the complex*16 level 1 blas.
*     based upon the original blas test routine together with:
*     f06gaf example program text
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      double precision sfac
      integer          ic
*     .. external subroutines ..
      external         check1, check2, header
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             sfac/9.765625d-4/
*     .. executable statements ..
      write (nout,99999)
      do 20 ic = 1, 10
         icase = ic
         call header
*
*        initialize pass, incx, incy, and mode for a new case.
*        the value 9999 for incx, incy or mode will appear in the
*        detailed  output, if any, for cases that do not involve
*        these parameters.
*
         pass = .true.
         incx = 9999
         incy = 9999
         mode = 9999
         if (icase.le.5) then
            call check2(sfac)
         else if (icase.ge.6) then
            call check1(sfac)
         end if
*        -- print
         if (pass) write (nout,99998)
   20 continue
      stop
*
99999 format (' complex blas test program results',/1x)
99998 format ('                                    ----- pass -----')
      end
      subroutine header
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local arrays ..
      character*6      l(10)
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data             l(1)/'zdotc '/
      data             l(2)/'zdotu '/
      data             l(3)/'zaxpy '/
      data             l(4)/'zcopy '/
      data             l(5)/'zswap '/
      data             l(6)/'dznrm2'/
      data             l(7)/'dzasum'/
      data             l(8)/'zscal '/
      data             l(9)/'zdscal'/
      data             l(10)/'izamax'/
*     .. executable statements ..
      write (nout,99999) icase, l(icase)
      return
*
99999 format (/' test of subprogram number',i3,12x,a6)
      end
      subroutine check1(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      double precision  sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      complex*16        ca
      double precision  sa
      integer           i, j, len, np1
*     .. local arrays ..
      complex*16        ctrue5(8,5,2), ctrue6(8,5,2), cv(8,5,2), cx(8),
     +                  mwpcs(5), mwpct(5)
      double precision  strue2(5), strue4(5)
      integer           itrue3(5)
*     .. external functions ..
      double precision  dzasum, dznrm2
      integer           izamax
      external          dzasum, dznrm2, izamax
*     .. external subroutines ..
      external          zscal, zdscal, ctest, itest1, stest1
*     .. intrinsic functions ..
      intrinsic         max
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              sa, ca/0.3d0, (0.4d0,-0.7d0)/
      data              ((cv(i,j,1),i=1,8),j=1,5)/(0.1d0,0.1d0),
     +                  (1.0d0,2.0d0), (1.0d0,2.0d0), (1.0d0,2.0d0),
     +                  (1.0d0,2.0d0), (1.0d0,2.0d0), (1.0d0,2.0d0),
     +                  (1.0d0,2.0d0), (0.3d0,-0.4d0), (3.0d0,4.0d0),
     +                  (3.0d0,4.0d0), (3.0d0,4.0d0), (3.0d0,4.0d0),
     +                  (3.0d0,4.0d0), (3.0d0,4.0d0), (3.0d0,4.0d0),
     +                  (0.1d0,-0.3d0), (0.5d0,-0.1d0), (5.0d0,6.0d0),
     +                  (5.0d0,6.0d0), (5.0d0,6.0d0), (5.0d0,6.0d0),
     +                  (5.0d0,6.0d0), (5.0d0,6.0d0), (0.1d0,0.1d0),
     +                  (-0.6d0,0.1d0), (0.1d0,-0.3d0), (7.0d0,8.0d0),
     +                  (7.0d0,8.0d0), (7.0d0,8.0d0), (7.0d0,8.0d0),
     +                  (7.0d0,8.0d0), (0.3d0,0.1d0), (0.5d0,0.0d0),
     +                  (0.0d0,0.5d0), (0.0d0,0.2d0), (2.0d0,3.0d0),
     +                  (2.0d0,3.0d0), (2.0d0,3.0d0), (2.0d0,3.0d0)/
      data              ((cv(i,j,2),i=1,8),j=1,5)/(0.1d0,0.1d0),
     +                  (4.0d0,5.0d0), (4.0d0,5.0d0), (4.0d0,5.0d0),
     +                  (4.0d0,5.0d0), (4.0d0,5.0d0), (4.0d0,5.0d0),
     +                  (4.0d0,5.0d0), (0.3d0,-0.4d0), (6.0d0,7.0d0),
     +                  (6.0d0,7.0d0), (6.0d0,7.0d0), (6.0d0,7.0d0),
     +                  (6.0d0,7.0d0), (6.0d0,7.0d0), (6.0d0,7.0d0),
     +                  (0.1d0,-0.3d0), (8.0d0,9.0d0), (0.5d0,-0.1d0),
     +                  (2.0d0,5.0d0), (2.0d0,5.0d0), (2.0d0,5.0d0),
     +                  (2.0d0,5.0d0), (2.0d0,5.0d0), (0.1d0,0.1d0),
     +                  (3.0d0,6.0d0), (-0.6d0,0.1d0), (4.0d0,7.0d0),
     +                  (0.1d0,-0.3d0), (7.0d0,2.0d0), (7.0d0,2.0d0),
     +                  (7.0d0,2.0d0), (0.3d0,0.1d0), (5.0d0,8.0d0),
     +                  (0.5d0,0.0d0), (6.0d0,9.0d0), (0.0d0,0.5d0),
     +                  (8.0d0,3.0d0), (0.0d0,0.2d0), (9.0d0,4.0d0)/
      data              strue2/0.0d0, 0.5d0, 0.6d0, 0.7d0, 0.8d0/
      data              strue4/0.0d0, 0.7d0, 1.0d0, 1.3d0, 1.6d0/
      data              ((ctrue5(i,j,1),i=1,8),j=1,5)/(0.1d0,0.1d0),
     +                  (1.0d0,2.0d0), (1.0d0,2.0d0), (1.0d0,2.0d0),
     +                  (1.0d0,2.0d0), (1.0d0,2.0d0), (1.0d0,2.0d0),
     +                  (1.0d0,2.0d0), (-0.16d0,-0.37d0), (3.0d0,4.0d0),
     +                  (3.0d0,4.0d0), (3.0d0,4.0d0), (3.0d0,4.0d0),
     +                  (3.0d0,4.0d0), (3.0d0,4.0d0), (3.0d0,4.0d0),
     +                  (-0.17d0,-0.19d0), (0.13d0,-0.39d0),
     +                  (5.0d0,6.0d0), (5.0d0,6.0d0), (5.0d0,6.0d0),
     +                  (5.0d0,6.0d0), (5.0d0,6.0d0), (5.0d0,6.0d0),
     +                  (0.11d0,-0.03d0), (-0.17d0,0.46d0),
     +                  (-0.17d0,-0.19d0), (7.0d0,8.0d0), (7.0d0,8.0d0),
     +                  (7.0d0,8.0d0), (7.0d0,8.0d0), (7.0d0,8.0d0),
     +                  (0.19d0,-0.17d0), (0.20d0,-0.35d0),
     +                  (0.35d0,0.20d0), (0.14d0,0.08d0),
     +                  (2.0d0,3.0d0), (2.0d0,3.0d0), (2.0d0,3.0d0),
     +                  (2.0d0,3.0d0)/
      data              ((ctrue5(i,j,2),i=1,8),j=1,5)/(0.1d0,0.1d0),
     +                  (4.0d0,5.0d0), (4.0d0,5.0d0), (4.0d0,5.0d0),
     +                  (4.0d0,5.0d0), (4.0d0,5.0d0), (4.0d0,5.0d0),
     +                  (4.0d0,5.0d0), (-0.16d0,-0.37d0), (6.0d0,7.0d0),
     +                  (6.0d0,7.0d0), (6.0d0,7.0d0), (6.0d0,7.0d0),
     +                  (6.0d0,7.0d0), (6.0d0,7.0d0), (6.0d0,7.0d0),
     +                  (-0.17d0,-0.19d0), (8.0d0,9.0d0),
     +                  (0.13d0,-0.39d0), (2.0d0,5.0d0), (2.0d0,5.0d0),
     +                  (2.0d0,5.0d0), (2.0d0,5.0d0), (2.0d0,5.0d0),
     +                  (0.11d0,-0.03d0), (3.0d0,6.0d0),
     +                  (-0.17d0,0.46d0), (4.0d0,7.0d0),
     +                  (-0.17d0,-0.19d0), (7.0d0,2.0d0), (7.0d0,2.0d0),
     +                  (7.0d0,2.0d0), (0.19d0,-0.17d0), (5.0d0,8.0d0),
     +                  (0.20d0,-0.35d0), (6.0d0,9.0d0),
     +                  (0.35d0,0.20d0), (8.0d0,3.0d0),
     +                  (0.14d0,0.08d0), (9.0d0,4.0d0)/
      data              ((ctrue6(i,j,1),i=1,8),j=1,5)/(0.1d0,0.1d0),
     +                  (1.0d0,2.0d0), (1.0d0,2.0d0), (1.0d0,2.0d0),
     +                  (1.0d0,2.0d0), (1.0d0,2.0d0), (1.0d0,2.0d0),
     +                  (1.0d0,2.0d0), (0.09d0,-0.12d0), (3.0d0,4.0d0),
     +                  (3.0d0,4.0d0), (3.0d0,4.0d0), (3.0d0,4.0d0),
     +                  (3.0d0,4.0d0), (3.0d0,4.0d0), (3.0d0,4.0d0),
     +                  (0.03d0,-0.09d0), (0.15d0,-0.03d0),
     +                  (5.0d0,6.0d0), (5.0d0,6.0d0), (5.0d0,6.0d0),
     +                  (5.0d0,6.0d0), (5.0d0,6.0d0), (5.0d0,6.0d0),
     +                  (0.03d0,0.03d0), (-0.18d0,0.03d0),
     +                  (0.03d0,-0.09d0), (7.0d0,8.0d0), (7.0d0,8.0d0),
     +                  (7.0d0,8.0d0), (7.0d0,8.0d0), (7.0d0,8.0d0),
     +                  (0.09d0,0.03d0), (0.15d0,0.00d0),
     +                  (0.00d0,0.15d0), (0.00d0,0.06d0), (2.0d0,3.0d0),
     +                  (2.0d0,3.0d0), (2.0d0,3.0d0), (2.0d0,3.0d0)/
      data              ((ctrue6(i,j,2),i=1,8),j=1,5)/(0.1d0,0.1d0),
     +                  (4.0d0,5.0d0), (4.0d0,5.0d0), (4.0d0,5.0d0),
     +                  (4.0d0,5.0d0), (4.0d0,5.0d0), (4.0d0,5.0d0),
     +                  (4.0d0,5.0d0), (0.09d0,-0.12d0), (6.0d0,7.0d0),
     +                  (6.0d0,7.0d0), (6.0d0,7.0d0), (6.0d0,7.0d0),
     +                  (6.0d0,7.0d0), (6.0d0,7.0d0), (6.0d0,7.0d0),
     +                  (0.03d0,-0.09d0), (8.0d0,9.0d0),
     +                  (0.15d0,-0.03d0), (2.0d0,5.0d0), (2.0d0,5.0d0),
     +                  (2.0d0,5.0d0), (2.0d0,5.0d0), (2.0d0,5.0d0),
     +                  (0.03d0,0.03d0), (3.0d0,6.0d0),
     +                  (-0.18d0,0.03d0), (4.0d0,7.0d0),
     +                  (0.03d0,-0.09d0), (7.0d0,2.0d0), (7.0d0,2.0d0),
     +                  (7.0d0,2.0d0), (0.09d0,0.03d0), (5.0d0,8.0d0),
     +                  (0.15d0,0.00d0), (6.0d0,9.0d0), (0.00d0,0.15d0),
     +                  (8.0d0,3.0d0), (0.00d0,0.06d0), (9.0d0,4.0d0)/
      data              itrue3/0, 1, 2, 2, 2/
*     .. executable statements ..
      do 60 incx = 1, 2
         do 40 np1 = 1, 5
            n = np1 - 1
            len = 2*max(n,1)
*           .. set vector arguments ..
            do 20 i = 1, len
               cx(i) = cv(i,np1,incx)
   20       continue
            if (icase.eq.6) then
*              .. dznrm2 ..
               call stest1(dznrm2(n,cx,incx),strue2(np1),strue2(np1),
     +                     sfac)
            else if (icase.eq.7) then
*              .. dzasum ..
               call stest1(dzasum(n,cx,incx),strue4(np1),strue4(np1),
     +                     sfac)
            else if (icase.eq.8) then
*              .. zscal ..
               call zscal(n,ca,cx,incx)
               call ctest(len,cx,ctrue5(1,np1,incx),ctrue5(1,np1,incx),
     +                    sfac)
            else if (icase.eq.9) then
*              .. zdscal ..
               call zdscal(n,sa,cx,incx)
               call ctest(len,cx,ctrue6(1,np1,incx),ctrue6(1,np1,incx),
     +                    sfac)
            else if (icase.eq.10) then
*              .. izamax ..
               call itest1(izamax(n,cx,incx),itrue3(np1))
            else
               write (nout,*) ' shouldn''t be here in check1'
               stop
            end if
*
   40    continue
   60 continue
*
      incx = 1
      if (icase.eq.8) then
*        zscal
*        add a test for alpha equal to zero.
         ca = (0.0d0,0.0d0)
         do 80 i = 1, 5
            mwpct(i) = (0.0d0,0.0d0)
            mwpcs(i) = (1.0d0,1.0d0)
   80    continue
         call zscal(5,ca,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
      else if (icase.eq.9) then
*        zdscal
*        add a test for alpha equal to zero.
         sa = 0.0d0
         do 100 i = 1, 5
            mwpct(i) = (0.0d0,0.0d0)
            mwpcs(i) = (1.0d0,1.0d0)
  100    continue
         call zdscal(5,sa,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
*        add a test for alpha equal to one.
         sa = 1.0d0
         do 120 i = 1, 5
            mwpct(i) = cx(i)
            mwpcs(i) = cx(i)
  120    continue
         call zdscal(5,sa,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
*        add a test for alpha equal to minus one.
         sa = -1.0d0
         do 140 i = 1, 5
            mwpct(i) = -cx(i)
            mwpcs(i) = -cx(i)
  140    continue
         call zdscal(5,sa,cx,incx)
         call ctest(5,cx,mwpct,mwpcs,sfac)
      end if
      return
      end
      subroutine check2(sfac)
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      double precision  sfac
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      complex*16        ca
      integer           i, j, ki, kn, ksize, lenx, leny, mx, my
*     .. local arrays ..
      complex*16        cdot(1), csize1(4), csize2(7,2), csize3(14),
     +                  ct10x(7,4,4), ct10y(7,4,4), ct6(4,4), ct7(4,4),
     +                  ct8(7,4,4), cx(7), cx1(7), cy(7), cy1(7)
      integer           incxs(4), incys(4), lens(4,2), ns(4)
*     .. external functions ..
      complex*16        zdotc, zdotu
      external          zdotc, zdotu
*     .. external subroutines ..
      external          zaxpy, zcopy, zswap, ctest
*     .. intrinsic functions ..
      intrinsic         abs, min
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. data statements ..
      data              ca/(0.4d0,-0.7d0)/
      data              incxs/1, 2, -2, -1/
      data              incys/1, -2, 1, -2/
      data              lens/1, 1, 2, 4, 1, 1, 3, 7/
      data              ns/0, 1, 2, 4/
      data              cx1/(0.7d0,-0.8d0), (-0.4d0,-0.7d0),
     +                  (-0.1d0,-0.9d0), (0.2d0,-0.8d0),
     +                  (-0.9d0,-0.4d0), (0.1d0,0.4d0), (-0.6d0,0.6d0)/
      data              cy1/(0.6d0,-0.6d0), (-0.9d0,0.5d0),
     +                  (0.7d0,-0.6d0), (0.1d0,-0.5d0), (-0.1d0,-0.2d0),
     +                  (-0.5d0,-0.3d0), (0.8d0,-0.7d0)/
      data              ((ct8(i,j,1),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.32d0,-1.41d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.32d0,-1.41d0),
     +                  (-1.55d0,0.5d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.32d0,-1.41d0), (-1.55d0,0.5d0),
     +                  (0.03d0,-0.89d0), (-0.38d0,-0.96d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0)/
      data              ((ct8(i,j,2),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.32d0,-1.41d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (-0.07d0,-0.89d0),
     +                  (-0.9d0,0.5d0), (0.42d0,-1.41d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.78d0,0.06d0), (-0.9d0,0.5d0),
     +                  (0.06d0,-0.13d0), (0.1d0,-0.5d0),
     +                  (-0.77d0,-0.49d0), (-0.5d0,-0.3d0),
     +                  (0.52d0,-1.51d0)/
      data              ((ct8(i,j,3),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.32d0,-1.41d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (-0.07d0,-0.89d0),
     +                  (-1.18d0,-0.31d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.78d0,0.06d0), (-1.54d0,0.97d0),
     +                  (0.03d0,-0.89d0), (-0.18d0,-1.31d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0)/
      data              ((ct8(i,j,4),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.32d0,-1.41d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.32d0,-1.41d0), (-0.9d0,0.5d0),
     +                  (0.05d0,-0.6d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.32d0,-1.41d0),
     +                  (-0.9d0,0.5d0), (0.05d0,-0.6d0), (0.1d0,-0.5d0),
     +                  (-0.77d0,-0.49d0), (-0.5d0,-0.3d0),
     +                  (0.32d0,-1.16d0)/
      data              ct7/(0.0d0,0.0d0), (-0.06d0,-0.90d0),
     +                  (0.65d0,-0.47d0), (-0.34d0,-1.22d0),
     +                  (0.0d0,0.0d0), (-0.06d0,-0.90d0),
     +                  (-0.59d0,-1.46d0), (-1.04d0,-0.04d0),
     +                  (0.0d0,0.0d0), (-0.06d0,-0.90d0),
     +                  (-0.83d0,0.59d0), (0.07d0,-0.37d0),
     +                  (0.0d0,0.0d0), (-0.06d0,-0.90d0),
     +                  (-0.76d0,-1.15d0), (-1.33d0,-1.82d0)/
      data              ct6/(0.0d0,0.0d0), (0.90d0,0.06d0),
     +                  (0.91d0,-0.77d0), (1.80d0,-0.10d0),
     +                  (0.0d0,0.0d0), (0.90d0,0.06d0), (1.45d0,0.74d0),
     +                  (0.20d0,0.90d0), (0.0d0,0.0d0), (0.90d0,0.06d0),
     +                  (-0.55d0,0.23d0), (0.83d0,-0.39d0),
     +                  (0.0d0,0.0d0), (0.90d0,0.06d0), (1.04d0,0.79d0),
     +                  (1.95d0,1.22d0)/
      data              ((ct10x(i,j,1),i=1,7),j=1,4)/(0.7d0,-0.8d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.6d0,-0.6d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.6d0,-0.6d0), (-0.9d0,0.5d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.6d0,-0.6d0),
     +                  (-0.9d0,0.5d0), (0.7d0,-0.6d0), (0.1d0,-0.5d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0)/
      data              ((ct10x(i,j,2),i=1,7),j=1,4)/(0.7d0,-0.8d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.6d0,-0.6d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.7d0,-0.6d0), (-0.4d0,-0.7d0),
     +                  (0.6d0,-0.6d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.8d0,-0.7d0),
     +                  (-0.4d0,-0.7d0), (-0.1d0,-0.2d0),
     +                  (0.2d0,-0.8d0), (0.7d0,-0.6d0), (0.1d0,0.4d0),
     +                  (0.6d0,-0.6d0)/
      data              ((ct10x(i,j,3),i=1,7),j=1,4)/(0.7d0,-0.8d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.6d0,-0.6d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (-0.9d0,0.5d0), (-0.4d0,-0.7d0),
     +                  (0.6d0,-0.6d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.1d0,-0.5d0),
     +                  (-0.4d0,-0.7d0), (0.7d0,-0.6d0), (0.2d0,-0.8d0),
     +                  (-0.9d0,0.5d0), (0.1d0,0.4d0), (0.6d0,-0.6d0)/
      data              ((ct10x(i,j,4),i=1,7),j=1,4)/(0.7d0,-0.8d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.6d0,-0.6d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.6d0,-0.6d0), (0.7d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.6d0,-0.6d0),
     +                  (0.7d0,-0.6d0), (-0.1d0,-0.2d0), (0.8d0,-0.7d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0)/
      data              ((ct10y(i,j,1),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.7d0,-0.8d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.7d0,-0.8d0), (-0.4d0,-0.7d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.7d0,-0.8d0),
     +                  (-0.4d0,-0.7d0), (-0.1d0,-0.9d0),
     +                  (0.2d0,-0.8d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0)/
      data              ((ct10y(i,j,2),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.7d0,-0.8d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (-0.1d0,-0.9d0), (-0.9d0,0.5d0),
     +                  (0.7d0,-0.8d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (-0.6d0,0.6d0),
     +                  (-0.9d0,0.5d0), (-0.9d0,-0.4d0), (0.1d0,-0.5d0),
     +                  (-0.1d0,-0.9d0), (-0.5d0,-0.3d0),
     +                  (0.7d0,-0.8d0)/
      data              ((ct10y(i,j,3),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.7d0,-0.8d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (-0.1d0,-0.9d0), (0.7d0,-0.8d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (-0.6d0,0.6d0),
     +                  (-0.9d0,-0.4d0), (-0.1d0,-0.9d0),
     +                  (0.7d0,-0.8d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0)/
      data              ((ct10y(i,j,4),i=1,7),j=1,4)/(0.6d0,-0.6d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.7d0,-0.8d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.7d0,-0.8d0), (-0.9d0,0.5d0),
     +                  (-0.4d0,-0.7d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.7d0,-0.8d0),
     +                  (-0.9d0,0.5d0), (-0.4d0,-0.7d0), (0.1d0,-0.5d0),
     +                  (-0.1d0,-0.9d0), (-0.5d0,-0.3d0),
     +                  (0.2d0,-0.8d0)/
      data              csize1/(0.0d0,0.0d0), (0.9d0,0.9d0),
     +                  (1.63d0,1.73d0), (2.90d0,2.78d0)/
      data              csize3/(0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (1.17d0,1.17d0),
     +                  (1.17d0,1.17d0), (1.17d0,1.17d0),
     +                  (1.17d0,1.17d0), (1.17d0,1.17d0),
     +                  (1.17d0,1.17d0), (1.17d0,1.17d0)/
      data              csize2/(0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (0.0d0,0.0d0),
     +                  (0.0d0,0.0d0), (0.0d0,0.0d0), (1.54d0,1.54d0),
     +                  (1.54d0,1.54d0), (1.54d0,1.54d0),
     +                  (1.54d0,1.54d0), (1.54d0,1.54d0),
     +                  (1.54d0,1.54d0), (1.54d0,1.54d0)/
*     .. executable statements ..
      do 60 ki = 1, 4
         incx = incxs(ki)
         incy = incys(ki)
         mx = abs(incx)
         my = abs(incy)
*
         do 40 kn = 1, 4
            n = ns(kn)
            ksize = min(2,kn)
            lenx = lens(kn,mx)
            leny = lens(kn,my)
*           .. initialize all argument arrays ..
            do 20 i = 1, 7
               cx(i) = cx1(i)
               cy(i) = cy1(i)
   20       continue
            if (icase.eq.1) then
*              .. zdotc ..
               cdot(1) = zdotc(n,cx,incx,cy,incy)
               call ctest(1,cdot,ct6(kn,ki),csize1(kn),sfac)
            else if (icase.eq.2) then
*              .. zdotu ..
               cdot(1) = zdotu(n,cx,incx,cy,incy)
               call ctest(1,cdot,ct7(kn,ki),csize1(kn),sfac)
            else if (icase.eq.3) then
*              .. zaxpy ..
               call zaxpy(n,ca,cx,incx,cy,incy)
               call ctest(leny,cy,ct8(1,kn,ki),csize2(1,ksize),sfac)
            else if (icase.eq.4) then
*              .. zcopy ..
               call zcopy(n,cx,incx,cy,incy)
               call ctest(leny,cy,ct10y(1,kn,ki),csize3,1.0d0)
            else if (icase.eq.5) then
*              .. zswap ..
               call zswap(n,cx,incx,cy,incy)
               call ctest(lenx,cx,ct10x(1,kn,ki),csize3,1.0d0)
               call ctest(leny,cy,ct10y(1,kn,ki),csize3,1.0d0)
            else
               write (nout,*) ' shouldn''t be here in check2'
               stop
            end if
*
   40    continue
   60 continue
      return
      end
      subroutine stest(len,scomp,strue,ssize,sfac)
*     ********************************* stest **************************
*
*     this subr compares arrays  scomp() and strue() of length len to
*     see if the term by term differences, multiplied by sfac, are
*     negligible.
*
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer          nout
      parameter        (nout=6)
*     .. scalar arguments ..
      double precision sfac
      integer          len
*     .. array arguments ..
      double precision scomp(len), ssize(len), strue(len)
*     .. scalars in common ..
      integer          icase, incx, incy, mode, n
      logical          pass
*     .. local scalars ..
      double precision sd
      integer          i
*     .. external functions ..
      double precision sdiff
      external         sdiff
*     .. intrinsic functions ..
      intrinsic        abs
*     .. common blocks ..
      common           /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
*
      do 40 i = 1, len
         sd = scomp(i) - strue(i)
         if (sdiff(abs(ssize(i))+abs(sfac*sd),abs(ssize(i))).eq.0.0d0)
     +       go to 40
*
*                             here    scomp(i) is not close to strue(i).
*
         if ( .not. pass) go to 20
*                             print fail message and header.
         pass = .false.
         write (nout,99999)
         write (nout,99998)
   20    write (nout,99997) icase, n, incx, incy, mode, i, scomp(i),
     +     strue(i), sd, ssize(i)
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode  i                            ',
     +       ' comp(i)                             true(i)  difference',
     +       '     size(i)',/1x)
99997 format (1x,i4,i3,3i5,i3,2d36.8,2d12.4)
      end
      subroutine stest1(scomp1,strue1,ssize,sfac)
*     ************************* stest1 *****************************
*
*     this is an interface subroutine to accomodate the fortran
*     requirement that when a dummy argument is an array, the
*     actual argument must also be an array or an array element.
*
*     c.l. lawson, jpl, 1978 dec 6
*
*     .. scalar arguments ..
      double precision  scomp1, sfac, strue1
*     .. array arguments ..
      double precision  ssize(*)
*     .. local arrays ..
      double precision  scomp(1), strue(1)
*     .. external subroutines ..
      external          stest
*     .. executable statements ..
*
      scomp(1) = scomp1
      strue(1) = strue1
      call stest(1,scomp,strue,ssize,sfac)
*
      return
      end
      double precision function sdiff(sa,sb)
*     ********************************* sdiff **************************
*     computes difference of two numbers.  c. l. lawson, jpl 1974 feb 15
*
*     .. scalar arguments ..
      double precision                sa, sb
*     .. executable statements ..
      sdiff = sa - sb
      return
      end
      subroutine ctest(len,ccomp,ctrue,csize,sfac)
*     **************************** ctest *****************************
*
*     c.l. lawson, jpl, 1978 dec 6
*
*     .. scalar arguments ..
      double precision sfac
      integer          len
*     .. array arguments ..
      complex*16       ccomp(len), csize(len), ctrue(len)
*     .. local scalars ..
      integer          i
*     .. local arrays ..
      double precision scomp(20), ssize(20), strue(20)
*     .. external subroutines ..
      external         stest
*     .. intrinsic functions ..
      intrinsic        dimag, dble
*     .. executable statements ..
      do 20 i = 1, len
         scomp(2*i-1) = dble(ccomp(i))
         scomp(2*i) = dimag(ccomp(i))
         strue(2*i-1) = dble(ctrue(i))
         strue(2*i) = dimag(ctrue(i))
         ssize(2*i-1) = dble(csize(i))
         ssize(2*i) = dimag(csize(i))
   20 continue
*
      call stest(2*len,scomp,strue,ssize,sfac)
      return
      end
      subroutine itest1(icomp,itrue)
*     ********************************* itest1 *************************
*
*     this subroutine compares the variables icomp and itrue for
*     equality.
*     c. l. lawson, jpl, 1974 dec 10
*
*     .. parameters ..
      integer           nout
      parameter         (nout=6)
*     .. scalar arguments ..
      integer           icomp, itrue
*     .. scalars in common ..
      integer           icase, incx, incy, mode, n
      logical           pass
*     .. local scalars ..
      integer           id
*     .. common blocks ..
      common            /combla/icase, n, incx, incy, mode, pass
*     .. executable statements ..
      if (icomp.eq.itrue) go to 40
*
*                            here icomp is not equal to itrue.
*
      if ( .not. pass) go to 20
*                             print fail message and header.
      pass = .false.
      write (nout,99999)
      write (nout,99998)
   20 id = icomp - itrue
      write (nout,99997) icase, n, incx, incy, mode, icomp, itrue, id
   40 continue
      return
*
99999 format ('                                       fail')
99998 format (/' case  n incx incy mode                               ',
     +       ' comp                                true     difference',
     +       /1x)
99997 format (1x,i4,i3,3i5,2i36,i12)
      end
