//! @file banner.c
//! @author J. Marcel van der Veer
//
//! @section Copyright
//
// This file is part of VIF - vintage FORTRAN compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section License
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the 
// Free Software Foundation; either version 3 of the License, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details. You should have received a copy of the GNU General Public 
// License along with this program. If not, see <http://www.gnu.org/licenses/>.

//! @section Synopsis
//!
//! Banner for listing files.

// Loosely based on the public domain SYSV banner source code by Brian Wallis.

#include <vif.h>

char *glyphs[] = {
  "         ***  *** ***  * *   ***** ***   *  **     ***  ",
  "         ***  *** ***  * *  *  *  ** *  *  *  *    ***   ",
  "         ***   *   * ********  *   *** *    **      *   ",
  "          *            * *   *****    *    ***     *    ",
  "                     *******   *  *  * ****   * *       ",
  "         ***           * *  *  *  * *  * **    *        ",
  "         ***           * *   ***** *   *** **** *       ",

  "   **    **                                            *",
  "  *        *   *   *    *                             * ",
  " *          *   * *     *                            *  ",
  " *          * ******* *****   ***   *****           *   ",
  " *          *   * *     *     ***           ***    *    ",
  "  *        *   *   *    *      *            ***   *     ",
  "   **    **                   *             ***  *      ",

  "  000     1    22222  33333 4      5555555 66666 7777777",
  " 0   0   11   2     23     34    4 5      6     67    7 ",
  "0     0 1 1         2      34    4 5      6          7  ",
  "0     0   1    22222  33333 4444444 55555 666666    7   ",
  "0     0   1   2            3     4       56     6  7    ",
  " 0   0    1   2      3     3     4 5     56     6  7    ",
  "  000   11111 2222222 33333      4  55555  66666   7    ",

  " 88888  99999    *     ***      *           *     ***** ",
  "8     89     9  * *    ***     *             *   *     *",
  "8     89     9   *            *     *****     *        *",
  " 88888  999999         ***   *                 *     ** ",
  "8     8      9   *     ***    *     *****     *     *   ",
  "8     89     9  * *     *      *             *          ",
  " 88888  99999    *     *        *           *       *   ",

  " *****    A   BBBBBB  CCCCC DDDDDD EEEEEEEFFFFFFF GGGGG ",
  "*     *  A A  B     BC     CD     DE      F      G     G",
  "* *** * A   A B     BC      D     DE      F      G      ",
  "* * * *A     ABBBBBB C      D     DEEEEE  FFFFF  G  GGGG",
  "* **** AAAAAAAB     BC      D     DE      F      G     G",
  "*     *A     AB     BC     CD     DE      F      G     G",
  " ***** A     ABBBBBB  CCCCC DDDDDD EEEEEEEF       GGGGG ",

  "H     H  III        JK    K L      M     MN     N OOOOO ",
  "H     H   I         JK   K  L      MM   MMNN    NO     O",
  "H     H   I         JK  K   L      M M M MN N   NO     O",
  "HHHHHHH   I         JKKK    L      M  M  MN  N  NO     O",
  "H     H   I   J     JK  K   L      M     MN   N NO     O",
  "H     H   I   J     JK   K  L      M     MN    NNO     O",
  "H     H  III   JJJJJ K    K LLLLLLLM     MN     N OOOOO ",

  "PPPPPP  QQQQQ RRRRRR  SSSSS TTTTTTTU     UV     VW     W",
  "P     PQ     QR     RS     S   T   U     UV     VW     W",
  "P     PQ     QR     RS         T   U     UV     VW     W",
  "PPPPPP Q     QRRRRRR  SSSSS    T   U     UV     VW  W  W",
  "P      Q   Q QR   R        S   T   U     U V   V W  W  W",
  "P      Q    Q R    R S     S   T   U     U  V V  W  W  W",
  "P       QQQQ QR     R SSSSS    T    UUUUU    V    WW WW ",

  "X     XY     YZZZZZZZ ***** *       *****    *          ",
  " X   X  Y   Y      Z  *      *          *   * *         ",
  "  X X    Y Y      Z   *       *         *  *   *        ",
  "   X      Y      Z    *        *        *               ",
  "  X X     Y     Z     *         *       *               ",
  " X   X    Y    *      *          *      *               ",
  "X     X   Y   ZZZZZZZ *****       * *****        *******",

  "  ***                                                   ",
  "  ***     AA   BBBBB   CCCC  DDDDD  EEEEEE FFFFFF  GGGG ",
  "   *     A  A  B    B C    C D    D E      F      G    G",
  "    *   A    A BBBBB  C      D    D EEEEE  FFFFF  G     ",
  "        AAAAAA B    B C      D    D E      F      G  GGG",
  "        A    A B    B C    C D    D E      F      G    G",
  "        A    A BBBBB   CCCC  DDDDD  EEEEEE F       GGGG ",

  "                                                        ",
  " H    H    I        J K    K L      M    M N    N  OOOO ",
  " H    H    I        J K   K  L      MM  MM NN   N O    O",
  " HHHHHH    I        J KKKK   L      M MM M N N  N O    O",
  " H    H    I        J K  K   L      M    M N  N N O    O",
  " H    H    I   J    J K   K  L      M    M N   NN O    O",
  " H    H    I    JJJJ  K    K LLLLLL M    M N    N  OOOO ",

  "                                                        ",
  " PPPPP   QQQQ  RRRRR   SSSS   TTTTT U    U V    V W    W",
  " P    P Q    Q R    R S         T   U    U V    V W    W",
  " P    P Q    Q R    R  SSSS     T   U    U V    V W    W",
  " PPPPP  Q  Q Q RRRRR       S    T   U    U V    V W WW W",
  " P      Q   Q  R   R  S    S    T   U    U  V  V  WW  WW",
  " P       QQQ Q R    R  SSSS     T    UUUU    VV   W    W",

  "                       ***     *     ***   **    * * * *",
  " X    X  Y   Y ZZZZZZ *        *        * *  *  * * * * ",
  "  X  X    Y Y      Z  *        *        *     ** * * * *",
  "   XX      Y      Z  **                 **        * * * ",
  "   XX      Y     Z    *        *        *        * * * *",
  "  X  X     Y    Z     *        *        *         * * * ",
  " X    X    Y   ZZZZZZ  ***     *     ***         * * * *"
};

void banner (int_4 proc, int_4 phase, char *arg)
{
  int_4 len = strlen (arg);
  if (len > 12) {
    len = 12;
  }
  int_4 max = 0;
  for (int_4 cyc = 0; cyc < 2; cyc++) {
    char str[RECLN], lin[RECLN];
    for (int_4 a = 0; a < 7; a++) {
      for (int_4 b = 0; b < len; b++) {
        int_4 ind;
        if ((ind = (arg)[b] - ' ') < 0) {
          ind = 0;
        }
        for (int_4 c = 0; c < 7; c++) {
          lin[b * 8 + c] = glyphs[(ind / 8 * 7) + a][(ind % 8 * 7) + c];
        }
        lin[b * 8 + 7] = ' ';
      }
      for (int_4 b = len * 8 - 1; b >= 0; b--) {
        if (lin[b] != ' ') {
          break;
        }
        lin[b] = '\0';
      }
      if (cyc == 0) {
        if ((int_4) strlen (lin) > max) {
          max = strlen (lin);
        }
      } else {
        strcpy (str, "// ");
        for (int_4 k = 0; k < (LINE_WIDTH - max) / 2 - 3; k++) {
         bufcat (str, " ", LINE_WIDTH);
        }
       bufcat (str, lin, LINE_WIDTH);
       bufcat (str, "\n", LINE_WIDTH);
        code (proc, phase, str);
      }
    }
  }
}
