//! @file external.c
//! @author J. Marcel van der Veer
//
//! @section Copyright
//
// This file is part of VIF - vintage FORTRAN compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section License
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the 
// Free Software Foundation; either version 3 of the License, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details. You should have received a copy of the GNU General Public 
// License along with this program. If not, see <http://www.gnu.org/licenses/>.

//! @section Synopsis
//!
//! Compile declarations.

#include <vif.h>

void externals (void)
{
  int_4 rc, set = 0;
  while ((rc = scan (EXPECT_NONE)) != END_OF_LINE) {
    if (TOKEN (",")) {
      ;
    } else if (rc == WORD || rc == DECLAR) {
      set++;
      if (/* rc == WORD && reserved (curlex) */ FALSE) {
        ERROR (1601, "reserved symbol", curlex);
      }
      MODE mode;
      extf_decl (curlex, &mode);
    } else {
      EXPECT (1602, "subprogram name");
    }
  }
  if (set == 0) {
    SYNTAX (1603, "external statement");
  }
}

void intrinsics (void)
{
  int_4 rc, set = 0;
  while ((rc = scan (EXPECT_NONE)) != END_OF_LINE) {
    INTRINS *fun;
    if (TOKEN (",")) {
      ;
    } else if (!is_intrins (curlex, &fun)){
      EXPECT (1604, "intrinsic funcion name");
    } else {
      set++;
      if (/* rc == WORD && reserved (curlex) */ FALSE) {
        ERROR (1605, "reserved symbol", curlex);
      }
      NEW_RECORD (name);
      bufcpy (name, curlex, RECLN);
      compile_nested_intrinsic (name);
    }
  }
  if (set == 0) {
    SYNTAX (1606, "intrinsic statement");
  }
}
