//! @file intrinsic.c
//! @author J. Marcel van der Veer
//
//! @section Copyright
//
// This file is part of VIF - vintage FORTRAN compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section License
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the 
// Free Software Foundation; either version 3 of the License, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details. You should have received a copy of the GNU General Public 
// License along with this program. If not, see <http://www.gnu.org/licenses/>.

//! @section Synopsis
//!
//! Compile inline intrinsic functions.

#include <vif.h>

// VIF intrinsic function definitions.

#define INTR(_ffun, _bfun, _cfun, _rtyp, _rlen, _anum, _atyp, _alen, _f1, _f2, _f3) \
  {.ffun = (_ffun), .bfun = _bfun, .cfun = (_cfun), .rtyp = (_rtyp), .rlen = (_rlen), \
   .anum = (_anum), .atyp = (_atyp), .alen = (_alen), .f1 = (_f1), .f2 = (_f2), .f3 = (_f3)}

static INTRINS fun[] = {
// CHARACTER
  INTR ("achar", NO_TEXT, "_char", CHARACTER, 1, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("iachar", NO_TEXT, "_ichar", INTEGER, 4, 1, CHARACTER, 0, NO_FUN, NO_FUN, NO_FUN),
  INTR ("char", NO_TEXT, "_char", CHARACTER, 1, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ichar", NO_TEXT, "_ichar", INTEGER, 4, 1, CHARACTER, 0, NO_FUN, NO_FUN, NO_FUN),
  INTR ("trim", NO_TEXT, "", CHARACTER, 0, 1, CHARACTER, 0, NO_FUN, NO_FUN, NO_FUN),
  INTR ("len", NO_TEXT, "(int_4) strlen", INTEGER, 4, 1, CHARACTER, 0, NO_FUN, NO_FUN, NO_FUN),
// INTEGER generic
  INTR ("abs", NO_TEXT, "_abs", INTEGER, 2, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "_abs", INTEGER, 4, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "_abs", INTEGER, 8, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("amax0", "(real_4)", "_max", REAL, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("amin0", "(real_4)", "_min", REAL, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dble", NO_TEXT, "(real_8)", REAL, 8, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dble", NO_TEXT, "(real_8)", REAL, 8, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dble", NO_TEXT, "(real_8)", REAL, 8, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dfloat", NO_TEXT, "(real_8)", REAL, 8, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dfloat", NO_TEXT, "(real_8)", REAL, 8, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dfloat", NO_TEXT, "(real_8)", REAL, 8, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dim", NO_TEXT, "_dim_", INTEGER, 2, 2, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dim", NO_TEXT, "_dim_", INTEGER, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dim", NO_TEXT, "_dim_", INTEGER, 8, 2, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("float", NO_TEXT, "(real_4)", REAL, 4, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("float", NO_TEXT, "(real_4)", REAL, 4, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("float", NO_TEXT, "(real_4)", REAL, 4, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN), 
  INTR ("idnint", NO_TEXT, "_nintd", INTEGER, 4, 1, REAL, 8, _anintx, NO_FUN, NO_FUN),
  INTR ("int", "(int_4)", "_aintd", INTEGER, 4, 1, REAL, 8, _aintx, NO_FUN, NO_FUN),
  INTR ("int", "(int_4)", "_aintf", INTEGER, 4, 1, REAL, 4, _aintx, NO_FUN, NO_FUN),
  INTR ("int", "(int_4)", "_aintq", INTEGER, 4, 1, REAL, 16, _aintx, NO_FUN, NO_FUN),
  INTR ("int", NO_TEXT, "", INTEGER, 2, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("int", NO_TEXT, "", INTEGER, 4, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("int", NO_TEXT, "", INTEGER, 8, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("int", NO_TEXT, "_xint4", INTEGER, 4, 1, REAL, 32, _aintx, NO_FUN, NO_FUN),
  INTR ("max0", NO_TEXT, "_max", INTEGER, 4, 0, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("max", NO_TEXT, "_max", INTEGER, 2, 0, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("max", NO_TEXT, "_max", INTEGER, 4, 0, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("max", NO_TEXT, "_max", INTEGER, 8, 0, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min0", NO_TEXT, "_min", INTEGER, 4, 0, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min", NO_TEXT, "_min", INTEGER, 2, 0, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min", NO_TEXT, "_min", INTEGER, 4, 0, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min", NO_TEXT, "_min", INTEGER, 8, 0, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("mod", NO_TEXT, "_imod", INTEGER, 2, 2, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("mod", NO_TEXT, "_imod", INTEGER, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("mod", NO_TEXT, "_imod", INTEGER, 8, 2, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qext", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 2, _xI, NO_FUN, NO_FUN),
  INTR ("qext", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 4, _xI, NO_FUN, NO_FUN),
  INTR ("qext", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qfloat", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qfloat", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qfloat", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 2, _xI, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 4, _xI, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "(real_16)", REAL, 16, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", NO_TEXT, "(real_4)", REAL, 4, 1, INTEGER, 2, _xI, NO_FUN, NO_FUN),
  INTR ("real", NO_TEXT, "(real_4)", REAL, 4, 1, INTEGER, 4, _xI, NO_FUN, NO_FUN),
  INTR ("real", NO_TEXT, "(real_4)", REAL, 4, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sign", NO_TEXT, "_sign", INTEGER, 2, 2, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sign", NO_TEXT, "_sign", INTEGER, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sign", NO_TEXT, "_sign", INTEGER, 8, 2, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xext", "inttox", "(int_4)", REAL, 32, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xext", NO_TEXT, "inttox", REAL, 32, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xext", "quadtox", "(real_16)", REAL, 32, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xfloat", "inttox", "(int_4)", REAL, 32, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xfloat", NO_TEXT, "inttox", REAL, 32, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xfloat", "quadtox", "(real_16)", REAL, 32, 1, INTEGER, 8, NO_FUN, NO_FUN, NO_FUN),
// INTEGER specific
  INTR ("dfloat", NO_TEXT, "(real_8)", REAL, 8, 1, INTEGER, 4, _xI, NO_FUN, NO_FUN),
  INTR ("habs", "(int_2)", "_abs", INTEGER, 2, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("hdim", "(int_2)", "_dim_", INTEGER, 2, 2, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("hdint", "(int_2)", "_aintf", INTEGER, 2, 1, REAL, 8, _aintx, NO_FUN, NO_FUN),
  INTR ("hfix", "(int_2)", "_aintf", INTEGER, 2, 1, REAL, 4, _aintx, NO_FUN, NO_FUN),
  INTR ("hint", NO_TEXT, "(int_2)", INTEGER, 2, 1, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("hmax", "(int_2)", "_max", INTEGER, 2, 0, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("hmin", "(int_2)", "_min", INTEGER, 2, 0, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("hmod", "(int_2)", "_mod", INTEGER, 2, 2, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("hsign", "(int_2)", "_sign", INTEGER, 2, 2, INTEGER, 2, NO_FUN, NO_FUN, NO_FUN),
  INTR ("iabs", "(int_4)", "_abs", INTEGER, 4, 1, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("idim", "(int_4)", "_dim_", INTEGER, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("idint", "(int_4)", "_aintf", INTEGER, 4, 1, REAL, 8, _aintx, NO_FUN, NO_FUN),
  INTR ("ifix", "(int_4)", "_aintf", INTEGER, 4, 1, REAL, 4, _aintx, NO_FUN, NO_FUN),
  INTR ("imax", "(int_4)", "_max", INTEGER, 4, 0, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("imin", "(int_4)", "_min", INTEGER, 4, 0, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("imod", "(int_4)", "_mod", INTEGER, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("iqint", "(int_4)", "_aintq", INTEGER, 4, 1, REAL, 16, _aintx, NO_FUN, NO_FUN),
  INTR ("isign", "(int_4)", "_sign", INTEGER, 4, 2, INTEGER, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ixint", NO_TEXT, "_xint4", INTEGER, 4, 1, REAL, 32, _aintx, NO_FUN, NO_FUN),
  INTR ("max1", "(int_4)", "_max", INTEGER, 4, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min1", "(int_4)", "_min", INTEGER, 4, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
// REAL generic
  INTR ("abs", NO_TEXT, "_abs", REAL, 4, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "_abs", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "_abs", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "xabs", REAL, 32, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("acos", NO_TEXT, "acosf", REAL, 4, 1, REAL, 4, xacos, NO_FUN, NO_FUN),
  INTR ("acos", NO_TEXT, "acos", REAL, 8, 1, REAL, 8, xacos, NO_FUN, NO_FUN),
  INTR ("acos", NO_TEXT, "acosq", REAL, 16, 1, REAL, 16, xacos, NO_FUN, NO_FUN),
  INTR ("acos", NO_TEXT, "xacos", REAL, 32, 1, REAL, 32, xacos, NO_FUN, NO_FUN),
  INTR ("acosh", NO_TEXT, "acoshf", REAL, 4, 1, REAL, 4, xacosh, NO_FUN, NO_FUN),
  INTR ("acosh", NO_TEXT, "acosh", REAL, 8, 1, REAL, 8, xacosh, NO_FUN, NO_FUN),
  INTR ("acosh", NO_TEXT, "acoshq", REAL, 16, 1, REAL, 16, xacosh, NO_FUN, NO_FUN),
  INTR ("acosh", NO_TEXT, "xacosh", REAL, 32, 1, REAL, 32, xacosh, NO_FUN, NO_FUN),
  INTR ("acotan", NO_TEXT, "acotanf", REAL, 4, 1, REAL, 4, xacotan, NO_FUN, NO_FUN),
  INTR ("acotan", NO_TEXT, "acotan", REAL, 8, 1, REAL, 8, xacotan, NO_FUN, NO_FUN),
  INTR ("acotan", NO_TEXT, "acotanq", REAL, 16, 1, REAL, 16, xacotan, NO_FUN, NO_FUN),
  INTR ("acotan", NO_TEXT, "xacotan", REAL, 32, 1, REAL, 32, xacotan, NO_FUN, NO_FUN),
  INTR ("aint", NO_TEXT, "_aintd", REAL, 8, 1, REAL, 8, _aintx, NO_FUN, NO_FUN),
  INTR ("aint", NO_TEXT, "_aintf", REAL, 4, 1, REAL, 4, _aintx, NO_FUN, NO_FUN),
  INTR ("aint", NO_TEXT, "_aintd", REAL, 16, 1, REAL, 16, _aintx, NO_FUN, NO_FUN),
  INTR ("aint", NO_TEXT, "_aintx", REAL, 32, 1, REAL, 32, _aintx, NO_FUN, NO_FUN),
  INTR ("anint", NO_TEXT, "_anintd", REAL, 8, 1, REAL, 8, _anintx, NO_FUN, NO_FUN),
  INTR ("anint", NO_TEXT, "_anintf", REAL, 4, 1, REAL, 4, _anintx, NO_FUN, NO_FUN),
  INTR ("anint", NO_TEXT, "_anintq", REAL, 16, 1, REAL, 16, _anintx, NO_FUN, NO_FUN),
  INTR ("anint", NO_TEXT, "_anintx", REAL, 32, 1, REAL, 32, _anintx, NO_FUN, NO_FUN),
  INTR ("asin", NO_TEXT, "asinf", REAL, 4, 1, REAL, 4, xasin, NO_FUN, NO_FUN),
  INTR ("asin", NO_TEXT, "asin", REAL, 8, 1, REAL, 8, xasin, NO_FUN, NO_FUN),
  INTR ("asin", NO_TEXT, "asinq", REAL, 16, 1, REAL, 16, xasin, NO_FUN, NO_FUN),
  INTR ("asin", NO_TEXT, "xasin", REAL, 32, 1, REAL, 32, xasin, NO_FUN, NO_FUN),
  INTR ("asinh", NO_TEXT, "asinhf", REAL, 4, 1, REAL, 4, xasinh, NO_FUN, NO_FUN),
  INTR ("asinh", NO_TEXT, "asinh", REAL, 8, 1, REAL, 8, xasinh, NO_FUN, NO_FUN),
  INTR ("asinh", NO_TEXT, "asinhq", REAL, 16, 1, REAL, 16, xasinh, NO_FUN, NO_FUN),
  INTR ("asinh", NO_TEXT, "xasinh", REAL, 32, 1, REAL, 32, xasinh, NO_FUN, NO_FUN),
  INTR ("atan2", NO_TEXT, "atan2f", REAL, 4, 2, REAL, 4, NO_FUN, xatan2, NO_FUN),
  INTR ("atan2", NO_TEXT, "atan2", REAL, 8, 2, REAL, 8, NO_FUN, xatan2, NO_FUN),
  INTR ("atan2", NO_TEXT, "atan2q", REAL, 16, 2, REAL, 16, NO_FUN, xatan2, NO_FUN),
  INTR ("atan2", NO_TEXT, "xatan2", REAL, 32, 2, REAL, 32, NO_FUN, xatan2, NO_FUN),
  INTR ("atan", NO_TEXT, "atanf", REAL, 4, 1, REAL, 4, xatan, NO_FUN, NO_FUN),
  INTR ("atan", NO_TEXT, "atan", REAL, 8, 1, REAL, 8, xatan, NO_FUN, NO_FUN),
  INTR ("atan", NO_TEXT, "atanq", REAL, 16, 1, REAL, 16, xatan, NO_FUN, NO_FUN),
  INTR ("atan", NO_TEXT, "xatan", REAL, 32, 1, REAL, 32, xatan, NO_FUN, NO_FUN),
  INTR ("atanh", NO_TEXT, "atanhf", REAL, 4, 1, REAL, 4, xatanh, NO_FUN, NO_FUN),
  INTR ("atanh", NO_TEXT, "atanh", REAL, 8, 1, REAL, 8, xatanh, NO_FUN, NO_FUN),
  INTR ("atanh", NO_TEXT, "atanhq", REAL, 16, 1, REAL, 16, xatanh, NO_FUN, NO_FUN),
  INTR ("atanh", NO_TEXT, "xatanh", REAL, 32, 1, REAL, 32, xatanh, NO_FUN, NO_FUN),
  INTR ("cos", NO_TEXT, "cosf", REAL, 4, 1, REAL, 4, xcos, NO_FUN, NO_FUN),
  INTR ("cos", NO_TEXT, "cos", REAL, 8, 1, REAL, 8, xcos, NO_FUN, NO_FUN),
  INTR ("cos", NO_TEXT, "cosq", REAL, 16, 1, REAL, 16, xcos, NO_FUN, NO_FUN),
  INTR ("cos", NO_TEXT, "xcos", REAL, 32, 1, REAL, 32, xcos, NO_FUN, NO_FUN),
  INTR ("cosh", NO_TEXT, "coshf", REAL, 4, 1, REAL, 4, xcosh, NO_FUN, NO_FUN),
  INTR ("cosh", NO_TEXT, "cosh", REAL, 8, 1, REAL, 8, xcosh, NO_FUN, NO_FUN),
  INTR ("cosh", NO_TEXT, "coshq", REAL, 16, 1, REAL, 16, xcosh, NO_FUN, NO_FUN),
  INTR ("cosh", NO_TEXT, "xcosh", REAL, 32, 1, REAL, 32, xcosh, NO_FUN, NO_FUN),
  INTR ("cotan", NO_TEXT, "cotanf", REAL, 4, 1, REAL, 4, xcotan, NO_FUN, NO_FUN),
  INTR ("cotan", NO_TEXT, "cotan", REAL, 8, 1, REAL, 8, xcotan, NO_FUN, NO_FUN),
  INTR ("cotan", NO_TEXT, "cotanq", REAL, 16, 1, REAL, 16, xcotan, NO_FUN, NO_FUN),
  INTR ("cotan", NO_TEXT, "xcotan", REAL, 32, 1, REAL, 32, xcotan, NO_FUN, NO_FUN),
  INTR ("dble", NO_TEXT, "(real_8)", REAL, 8, 1, REAL, 4, _xI, NO_FUN, NO_FUN),
  INTR ("dble", NO_TEXT, "(real_8)", REAL, 8, 1, REAL, 8, _xI, NO_FUN, NO_FUN),
  INTR ("dble", NO_TEXT, "(real_8)", REAL, 8, 1, REAL, 16, _xI, NO_FUN, NO_FUN),
  INTR ("dble", NO_TEXT, "xtodbl", REAL, 8, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dim", NO_TEXT, "_dim_", REAL, 4, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dim", NO_TEXT, "_dim_", REAL, 8, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dim", NO_TEXT, "_dim_", REAL, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dim", NO_TEXT, "_xdimx", REAL, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("exp", NO_TEXT, "expf", REAL, 4, 1, REAL, 4, xexp, NO_FUN, NO_FUN),
  INTR ("exp", NO_TEXT, "exp", REAL, 8, 1, REAL, 8, xexp, NO_FUN, NO_FUN),
  INTR ("exp", NO_TEXT, "expq", REAL, 16, 1, REAL, 16, xexp, NO_FUN, NO_FUN),
  INTR ("exp", NO_TEXT, "xexp", REAL, 32, 1, REAL, 32, xexp, NO_FUN, NO_FUN),
  INTR ("hypot", NO_TEXT, "hypotf", REAL, 4, 2, REAL, 4, NO_FUN, _xhypot, NO_FUN),
  INTR ("hypot", NO_TEXT, "hypot", REAL, 8, 2, REAL, 8, NO_FUN, _xhypot, NO_FUN),
  INTR ("hypot", NO_TEXT, "hypotq", REAL, 16, 2, REAL, 16, NO_FUN, _xhypot, NO_FUN),
  INTR ("hypot", NO_TEXT, "hypotq", REAL, 32, 2, REAL, 32, NO_FUN, _xhypot, NO_FUN),
  INTR ("log10", NO_TEXT, "log10f", REAL, 4, 1, REAL, 4, xlog10, NO_FUN, NO_FUN),
  INTR ("log10", NO_TEXT, "log10", REAL, 8, 1, REAL, 8, xlog10, NO_FUN, NO_FUN),
  INTR ("log10", NO_TEXT, "log10q", REAL, 16, 1, REAL, 16, xlog10, NO_FUN, NO_FUN),
  INTR ("log10", NO_TEXT, "xlog10", REAL, 32, 1, REAL, 32, xlog10, NO_FUN, NO_FUN),
  INTR ("log", NO_TEXT, "logf", REAL, 4, 1, REAL, 4, xlog, NO_FUN, NO_FUN),
  INTR ("log", NO_TEXT, "log", REAL, 8, 1, REAL, 8, xlog, NO_FUN, NO_FUN),
  INTR ("log", NO_TEXT, "logq", REAL, 16, 1, REAL, 16, xlog, NO_FUN, NO_FUN),
  INTR ("log", NO_TEXT, "xlog", REAL, 32, 1, REAL, 32, xlog, NO_FUN, NO_FUN),
  INTR ("max", NO_TEXT, "_max", REAL, 4, 0, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("max", NO_TEXT, "_max", REAL, 8, 0, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("max", NO_TEXT, "_max", REAL, 16, 0, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("max", NO_TEXT, "_xmax", REAL, 32, 0, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min", NO_TEXT, "_min", REAL, 4, 0, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min", NO_TEXT, "_min", REAL, 8, 0, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min", NO_TEXT, "_min", REAL, 16, 0, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("min", NO_TEXT, "_xmin", REAL, 32, 0, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("mod", NO_TEXT, "fmodf", REAL, 4, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("mod", NO_TEXT, "fmod", REAL, 8, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("mod", NO_TEXT, "fmodq", REAL, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("mod", NO_TEXT, "_xmod", REAL, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("nint", NO_TEXT, "_nintf", INTEGER, 4, 1, REAL, 4, _anintx, NO_FUN, NO_FUN),
  INTR ("nint", NO_TEXT, "_nintd", INTEGER, 4, 1, REAL, 8, _anintx, NO_FUN, NO_FUN),
  INTR ("nint", NO_TEXT, "_nintq", INTEGER, 4, 1, REAL, 16, _anintx, NO_FUN, NO_FUN),
  INTR ("nint", NO_TEXT, "_xnint4", INTEGER, 4, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qext", NO_TEXT, "(real_16)", REAL, 16, 1, REAL, 4, _xI, NO_FUN, NO_FUN),
  INTR ("qext", NO_TEXT, "(real_16)", REAL, 16, 1, REAL, 8, _xI, NO_FUN, NO_FUN),
  INTR ("qext", NO_TEXT, "(real_16)", REAL, 16, 1, REAL, 16, _xI, NO_FUN, NO_FUN),
  INTR ("qext", NO_TEXT, "xtoquad", REAL, 16, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "(real_16)", REAL, 16, 1, REAL, 4, _xI, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "(real_16)", REAL, 16, 1, REAL, 8, _xI, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "(real_16)", REAL, 16, 1, REAL, 16, _xI, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "xtoquad", REAL, 16, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", NO_TEXT, "(real_4)", REAL, 4, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", NO_TEXT, "(real_4)", REAL, 4, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", NO_TEXT, "(real_4)", REAL, 4, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", NO_TEXT, "xtoflt", REAL, 4, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sngl", NO_TEXT, "(real_4)", REAL, 4, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("snglq", NO_TEXT, "(real_4)", REAL, 4, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("snglx", NO_TEXT, "xtoflt", REAL, 4, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sign", NO_TEXT, "_sign", REAL, 4, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sign", NO_TEXT, "_sign", REAL, 8, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sign", NO_TEXT, "_sign", REAL, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sign", NO_TEXT, "_xsgn", REAL, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sin", NO_TEXT, "sinf", REAL, 4, 1, REAL, 4, xsin, NO_FUN, NO_FUN),
  INTR ("sin", NO_TEXT, "sin", REAL, 8, 1, REAL, 8, xsin, NO_FUN, NO_FUN),
  INTR ("sin", NO_TEXT, "sinq", REAL, 16, 1, REAL, 16, xsin, NO_FUN, NO_FUN),
  INTR ("sin", NO_TEXT, "xsin", REAL, 32, 1, REAL, 32, xsin, NO_FUN, NO_FUN),
  INTR ("sinh", NO_TEXT, "sinhf", REAL, 4, 1, REAL, 4, xsinh, NO_FUN, NO_FUN),
  INTR ("sinh", NO_TEXT, "sinh", REAL, 8, 1, REAL, 8, xsinh, NO_FUN, NO_FUN),
  INTR ("sinh", NO_TEXT, "sinhq", REAL, 16, 1, REAL, 16, xsinh, NO_FUN, NO_FUN),
  INTR ("sinh", NO_TEXT, "xsinh", REAL, 32, 1, REAL, 32, xsinh, NO_FUN, NO_FUN),
  INTR ("sqrt", NO_TEXT, "sqrtf", REAL, 4, 1, REAL, 4, xsqrt, NO_FUN, NO_FUN),
  INTR ("sqrt", NO_TEXT, "sqrt", REAL, 8, 1, REAL, 8, xsqrt, NO_FUN, NO_FUN),
  INTR ("sqrt", NO_TEXT, "sqrtq", REAL, 16, 1, REAL, 16, xsqrt, NO_FUN, NO_FUN),
  INTR ("sqrt", NO_TEXT, "xsqrt", REAL, 32, 1, REAL, 32, xsqrt, NO_FUN, NO_FUN),
  INTR ("tan", NO_TEXT, "tanf", REAL, 4, 1, REAL, 4, xtan, NO_FUN, NO_FUN),
  INTR ("tan", NO_TEXT, "tan", REAL, 8, 1, REAL, 8, xtan, NO_FUN, NO_FUN),
  INTR ("tan", NO_TEXT, "tanq", REAL, 16, 1, REAL, 16, xtan, NO_FUN, NO_FUN),
  INTR ("tan", NO_TEXT, "xtan", REAL, 32, 1, REAL, 32, xtan, NO_FUN, NO_FUN),
  INTR ("tanh", NO_TEXT, "tanhf", REAL, 4, 1, REAL, 4, xtanh, NO_FUN, NO_FUN),
  INTR ("tanh", NO_TEXT, "tanh", REAL, 8, 1, REAL, 8, xtanh, NO_FUN, NO_FUN),
  INTR ("tanh", NO_TEXT, "tanhq", REAL, 16, 1, REAL, 16, xtanh, NO_FUN, NO_FUN),
  INTR ("tanh", NO_TEXT, "xtanh", REAL, 32, 1, REAL, 32, xtanh, NO_FUN, NO_FUN),
  INTR ("xext", NO_TEXT, "dbltox", REAL, 32, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xext", NO_TEXT, "dbltox", REAL, 32, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xext", NO_TEXT, "quadtox", REAL, 32, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xext", NO_TEXT, "", REAL, 32, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
// Special
  INTR ("lngam", NO_TEXT, "lgammaf", REAL, 4, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("gamma", NO_TEXT, "tgammaf", REAL, 4, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("erf", NO_TEXT, "erff", REAL, 4, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("erfc", NO_TEXT, "erfcf", REAL, 4, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("lngam", NO_TEXT, "lgamma", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("gamma", NO_TEXT, "tgamma", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("erf", NO_TEXT, "erf", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("erfc", NO_TEXT, "erfc", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("lngam", NO_TEXT, "lgammaq", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("gamma", NO_TEXT, "tgammaq", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("erf", NO_TEXT, "erfq", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("erfc", NO_TEXT, "erfcq", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
// REAL*4 specific
  INTR ("acosf", NO_TEXT, "acosf", REAL, 4, 1, REAL, 4, xacos, NO_FUN, NO_FUN),
  INTR ("acoshf", NO_TEXT, "acoshf", REAL, 4, 1, REAL, 4, xacosh, NO_FUN, NO_FUN),
  INTR ("acotanf", NO_TEXT, "acotanf", REAL, 4, 1, REAL, 4, xacotan, NO_FUN, NO_FUN),
  INTR ("alngam", NO_TEXT, "lgammaf", REAL, 4, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("atan2f", NO_TEXT, "atan2f", REAL, 4, 2, REAL, 4, NO_FUN, xatan2, NO_FUN),
  INTR ("atanf", NO_TEXT, "atanf", REAL, 4, 1, REAL, 4, xatan, NO_FUN, NO_FUN),
  INTR ("atanhf", NO_TEXT, "atanhf", REAL, 4, 1, REAL, 4, xatanh, NO_FUN, NO_FUN),
  INTR ("asinf", NO_TEXT, "asinf", REAL, 4, 1, REAL, 4, xasin, NO_FUN, NO_FUN),
  INTR ("asinhf", NO_TEXT, "asinhf", REAL, 4, 1, REAL, 4, xasinh, NO_FUN, NO_FUN),
  INTR ("cosf", NO_TEXT, "cosf", REAL, 4, 1, REAL, 4, xcos, NO_FUN, NO_FUN),
  INTR ("coshf", NO_TEXT, "coshf", REAL, 4, 1, REAL, 4, xcosh, NO_FUN, NO_FUN),
  INTR ("cotanf", NO_TEXT, "cotanf", REAL, 4, 1, REAL, 4, xcotan, NO_FUN, NO_FUN),
  INTR ("expf", NO_TEXT, "expf", REAL, 4, 1, REAL, 4, xexp, NO_FUN, NO_FUN),
  INTR ("log10f", NO_TEXT, "log10f", REAL, 4, 1, REAL, 4, xlog10, NO_FUN, NO_FUN),
  INTR ("logf", NO_TEXT, "logf", REAL, 4, 1, REAL, 4, xlog, NO_FUN, NO_FUN),
  INTR ("sinf", NO_TEXT, "sinf", REAL, 4, 1, REAL, 4, xsin, NO_FUN, NO_FUN),
  INTR ("sinhf", NO_TEXT, "sinhf", REAL, 4, 1, REAL, 4, xsinh, NO_FUN, NO_FUN),
  INTR ("sqrtf", NO_TEXT, "sqrtf", REAL, 4, 1, REAL, 4, xsqrt, NO_FUN, NO_FUN),
  INTR ("tanf", NO_TEXT, "tanf", REAL, 4, 1, REAL, 4, xtan, NO_FUN, NO_FUN),
  INTR ("tanhf", NO_TEXT, "tanhf", REAL, 4, 1, REAL, 4, xtanh, NO_FUN, NO_FUN),
// REAL specific
  INTR ("alog10", NO_TEXT, "log10f", REAL, 4, 1, REAL, 4, xlog10, NO_FUN, NO_FUN),
  INTR ("alog", NO_TEXT, "logf", REAL, 4, 1, REAL, 4, xlog, NO_FUN, NO_FUN),
  INTR ("amax1", NO_TEXT, "_max", REAL, 4, 0, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("amin1", NO_TEXT, "_min", REAL, 4, 0, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("amod", NO_TEXT, "fmodf", REAL, 4, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dabs", NO_TEXT, "_abs", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dacosh", NO_TEXT, "acosh", REAL, 8, 1, REAL, 8, xacosh, NO_FUN, NO_FUN),
  INTR ("dacos", NO_TEXT, "acos", REAL, 8, 1, REAL, 8, xacos, NO_FUN, NO_FUN),
  INTR ("dacotan", NO_TEXT, "dacotan", REAL, 8, 1, REAL, 8, xacotan, NO_FUN, NO_FUN),
  INTR ("dasinh", NO_TEXT, "asinh", REAL, 8, 1, REAL, 8, xasinh, NO_FUN, NO_FUN),
  INTR ("dasin", NO_TEXT, "asin", REAL, 8, 1, REAL, 8, xasin, NO_FUN, NO_FUN),
  INTR ("datan2", NO_TEXT, "atan2", REAL, 8, 2, REAL, 8, NO_FUN, xatan2, NO_FUN),
  INTR ("datanh", NO_TEXT, "atanh", REAL, 8, 1, REAL, 8, xatanh, NO_FUN, NO_FUN),
  INTR ("datan", NO_TEXT, "atan", REAL, 8, 1, REAL, 8, xatan, NO_FUN, NO_FUN),
  INTR ("dbleq", NO_TEXT, "(real_8)", REAL, 8, 1, REAL, 16, _xI, NO_FUN, NO_FUN),
  INTR ("dcosh", NO_TEXT, "cosh", REAL, 8, 1, REAL, 8, xcosh, NO_FUN, NO_FUN),
  INTR ("dcos", NO_TEXT, "cos", REAL, 8, 1, REAL, 8, xcos, NO_FUN, NO_FUN),
  INTR ("dcotan", NO_TEXT, "cotan", REAL, 8, 1, REAL, 8, xcotan, NO_FUN, NO_FUN),
  INTR ("ddim", NO_TEXT, "_dim_", REAL, 8, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dexp", NO_TEXT, "exp", REAL, 8, 1, REAL, 8, xexp, NO_FUN, NO_FUN),
  INTR ("dgamma", NO_TEXT, "tgamma", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dhypot", NO_TEXT, "hypot", REAL, 8, 2, REAL, 8, NO_FUN, _xhypot, NO_FUN),
  INTR ("dint", NO_TEXT, "_aintd", REAL, 8, 1, REAL, 8, _aintx, NO_FUN, NO_FUN),
  INTR ("dlngam", NO_TEXT, "lgamma", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dlog10", NO_TEXT, "log10", REAL, 8, 1, REAL, 8, xlog10, NO_FUN, NO_FUN),
  INTR ("dlog", NO_TEXT, "log", REAL, 8, 1, REAL, 8, xlog, NO_FUN, NO_FUN),
  INTR ("dmax1", NO_TEXT, "_max", REAL, 8, 0, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dmax", NO_TEXT, "_max", REAL, 8, 0, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dmin", NO_TEXT, "_min", REAL, 8, 0, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dmod", NO_TEXT, "fmod", REAL, 8, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dnint", NO_TEXT, "_anintd", REAL, 8, 1, REAL, 8, _anintx, NO_FUN, NO_FUN),
  INTR ("dreal", NO_TEXT, "(real_8)", REAL, 8, 1, REAL, 4, _xI, NO_FUN, NO_FUN),
  INTR ("dsign", NO_TEXT, "_sign", REAL, 8, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dsinh", NO_TEXT, "sinh", REAL, 8, 1, REAL, 8, xsinh, NO_FUN, NO_FUN),
  INTR ("dsin", NO_TEXT, "sin", REAL, 8, 1, REAL, 8, xsin, NO_FUN, NO_FUN),
  INTR ("dsqrt", NO_TEXT, "sqrt", REAL, 8, 1, REAL, 8, xsqrt, NO_FUN, NO_FUN),
  INTR ("dtanh", NO_TEXT, "tanh", REAL, 8, 1, REAL, 8, xtanh, NO_FUN, NO_FUN),
  INTR ("dtan", NO_TEXT, "tan", REAL, 8, 1, REAL, 8, xtan, NO_FUN, NO_FUN),
  INTR ("qabs", NO_TEXT, "_abs", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qacosh", NO_TEXT, "acoshq", REAL, 16, 1, REAL, 16, xacosh, NO_FUN, NO_FUN),
  INTR ("qacos", NO_TEXT, "acosq", REAL, 16, 1, REAL, 16, xacos, NO_FUN, NO_FUN),
  INTR ("qacotan", NO_TEXT, "cotanq", REAL, 16, 1, REAL, 16, xacotan, NO_FUN, NO_FUN),
  INTR ("qasinh", NO_TEXT, "asinhq", REAL, 16, 1, REAL, 16, xasinh, NO_FUN, NO_FUN),
  INTR ("qasin", NO_TEXT, "asinq", REAL, 16, 1, REAL, 16, xasin, NO_FUN, NO_FUN),
  INTR ("qatan2", NO_TEXT, "atan2q", REAL, 16, 2, REAL, 16, NO_FUN, xatan2, NO_FUN),
  INTR ("qatanh", NO_TEXT, "atanhq", REAL, 16, 1, REAL, 16, xatanh, NO_FUN, NO_FUN),
  INTR ("qatan", NO_TEXT, "atanq", REAL, 16, 1, REAL, 16, xatan, NO_FUN, NO_FUN),
  INTR ("qcosh", NO_TEXT, "coshq", REAL, 16, 1, REAL, 16, xcosh, NO_FUN, NO_FUN),
  INTR ("qcos", NO_TEXT, "cosq", REAL, 16, 1, REAL, 16, xcos, NO_FUN, NO_FUN),
  INTR ("qcotan", NO_TEXT, "cotanq", REAL, 16, 1, REAL, 16, xcotan, NO_FUN, NO_FUN),
  INTR ("qdim", NO_TEXT, "_dim_", REAL, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qexp", NO_TEXT, "expq", REAL, 16, 1, REAL, 16, xexp, NO_FUN, NO_FUN),
  INTR ("qextd", NO_TEXT, "_qext", REAL, 16, 1, REAL, 8, _xI, NO_FUN, NO_FUN),
  INTR ("qextx", NO_TEXT, "xtoquad", REAL, 16, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qgamma", NO_TEXT, "tgammaq", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qhypot", NO_TEXT, "hypotq", REAL, 16, 2, REAL, 16, NO_FUN, _xhypot, NO_FUN),
  INTR ("qint", NO_TEXT, "_aintq", REAL, 16, 1, REAL, 16, _aintx, NO_FUN, NO_FUN),
  INTR ("qlngam", NO_TEXT, "lgammaq", REAL, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qlog10", NO_TEXT, "log10q", REAL, 16, 1, REAL, 16, xlog10, NO_FUN, NO_FUN),
  INTR ("qlog", NO_TEXT, "logq", REAL, 16, 1, REAL, 16, xlog, NO_FUN, NO_FUN),
  INTR ("qmax1", NO_TEXT, "_max", REAL, 16, 0, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qmax", NO_TEXT, "_max", REAL, 16, 0, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qmin1", NO_TEXT, "_min", REAL, 16, 0, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qmin", NO_TEXT, "_min", REAL, 16, 0, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qmod", NO_TEXT, "fmodq", REAL, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qmod", NO_TEXT, "_qmod", REAL, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qnint", NO_TEXT, "_anintq", REAL, 16, 1, REAL, 16, _anintx, NO_FUN, NO_FUN),
  INTR ("qsign", NO_TEXT, "_sign", REAL, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qsinh", NO_TEXT, "sinhq", REAL, 16, 1, REAL, 16, xsinh, NO_FUN, NO_FUN),
  INTR ("qsin", NO_TEXT, "sinq", REAL, 16, 1, REAL, 16, xsin, NO_FUN, NO_FUN),
  INTR ("qsqrt", NO_TEXT, "sqrtq", REAL, 16, 1, REAL, 16, xsqrt, NO_FUN, NO_FUN),
  INTR ("qtanh", NO_TEXT, "tanhq", REAL, 16, 1, REAL, 16, xtanh, NO_FUN, NO_FUN),
  INTR ("qtan", NO_TEXT, "tanq", REAL, 16, 1, REAL, 16, xtan, NO_FUN, NO_FUN),
  INTR ("snglq", NO_TEXT, "(real_4)", REAL, 4, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sngl", NO_TEXT, "(real_4)", REAL, 4, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("snglx", NO_TEXT, "xtoflt", REAL, 4, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xabs", NO_TEXT, "xabs", REAL, 32, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xacosh", NO_TEXT, "xacosh", REAL, 32, 1, REAL, 32, xacosh, NO_FUN, NO_FUN),
  INTR ("xacos", NO_TEXT, "xacos", REAL, 32, 1, REAL, 32, xacos, NO_FUN, NO_FUN),
  INTR ("xacotan", NO_TEXT, "xacotan", REAL, 32, 1, REAL, 32, xacotan, NO_FUN, NO_FUN),
  INTR ("xasinh", NO_TEXT, "xasinh", REAL, 32, 1, REAL, 32, xasinh, NO_FUN, NO_FUN),
  INTR ("xasin", NO_TEXT, "xasin", REAL, 32, 1, REAL, 32, xasin, NO_FUN, NO_FUN),
  INTR ("xatan2", NO_TEXT, "xatan2", REAL, 32, 2, REAL, 32, NO_FUN, xatan2, NO_FUN),
  INTR ("xatanh", NO_TEXT, "xatanh", REAL, 32, 1, REAL, 32, xatanh, NO_FUN, NO_FUN),
  INTR ("xatan", NO_TEXT, "xatan", REAL, 32, 1, REAL, 32, xatan, NO_FUN, NO_FUN),
  INTR ("xcosh", NO_TEXT, "xcosh", REAL, 32, 1, REAL, 32, xcosh, NO_FUN, NO_FUN),
  INTR ("xcos", NO_TEXT, "xcos", REAL, 32, 1, REAL, 32, xcos, NO_FUN, NO_FUN),
  INTR ("xcotan", NO_TEXT, "xcotan", REAL, 32, 1, REAL, 32, xcotan, NO_FUN, NO_FUN),
  INTR ("xdble", NO_TEXT, "xtodbl", REAL, 8, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xdim", NO_TEXT, "_xdimx", REAL, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xexp", NO_TEXT, "xexp", REAL, 32, 1, REAL, 32, xexp, NO_FUN, NO_FUN),
  INTR ("xhypot", NO_TEXT, "_xhypot", REAL, 32, 2, REAL, 32, NO_FUN, _xhypot, NO_FUN),
  INTR ("xint", NO_TEXT, "_aintx", REAL, 32, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xlog10", NO_TEXT, "xlog10", REAL, 32, 1, REAL, 32, xlog10, NO_FUN, NO_FUN),
  INTR ("xlog", NO_TEXT, "xlog", REAL, 32, 1, REAL, 32, xlog, NO_FUN, NO_FUN),
  INTR ("xmax1", NO_TEXT, "_xmax", REAL, 32, 0, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xmax", NO_TEXT, "_xmax", REAL, 32, 0, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xmin1", NO_TEXT, "_xmin", REAL, 32, 0, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xmin", NO_TEXT, "_xmin", REAL, 32, 0, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xmod", NO_TEXT, "_xmod", REAL, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xmod", NO_TEXT, "_xmod", REAL, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xnint", NO_TEXT, "_anintx", REAL, 32, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xsign", NO_TEXT, "_xsgn", REAL, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xsinh", NO_TEXT, "xsinh", REAL, 32, 1, REAL, 32, xsinh, NO_FUN, NO_FUN),
  INTR ("xsin", NO_TEXT, "xsin", REAL, 32, 1, REAL, 32, xsin, NO_FUN, NO_FUN),
  INTR ("xsqrt", NO_TEXT, "xsqrt", REAL, 32, 1, REAL, 32, xsqrt, NO_FUN, NO_FUN),
  INTR ("xtanh", NO_TEXT, "xtanh", REAL, 32, 1, REAL, 32, xtanh, NO_FUN, NO_FUN),
  INTR ("xtan", NO_TEXT, "xtan", REAL, 32, 1, REAL, 32, xtan, NO_FUN, NO_FUN),
// COMPLEX generic
  INTR ("abs", NO_TEXT, "cabsf", REAL, 4, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "cabs", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "cabsq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("abs", NO_TEXT, "cxabs", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("aimag", NO_TEXT, "cimagf", REAL, 4, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("aimag", "(real_4)", "cimagq", REAL, 4, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("aimag", "(real_4)", "cimag", REAL, 4, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("aimag", "xtoflt", "cximag", REAL, 4, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cabs", NO_TEXT, "cabsf", REAL, 4, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cabs", NO_TEXT, "cabs", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cabs", NO_TEXT, "cabsq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cabs", NO_TEXT, "cxabs", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ccos", NO_TEXT, "ccosf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxcos),
  INTR ("ccos", NO_TEXT, "ccos", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxcos),
  INTR ("ccos", NO_TEXT, "ccosq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxcos),
  INTR ("ccos", NO_TEXT, "cxcos", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cexp", NO_TEXT, "cexpf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxexp),
  INTR ("cexp", NO_TEXT, "cexp", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxexp),
  INTR ("cexp", NO_TEXT, "cexpq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxexp),
  INTR ("cexp", NO_TEXT, "cxexp", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cint", "(int_4)", "crealf", INTEGER, 4, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cint", "(int_4)", "creal", INTEGER, 4, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cint", "(int_4)", "crealq", INTEGER, 4, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("clog", NO_TEXT, "clogf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxlog),
  INTR ("clog", NO_TEXT, "clog", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxlog),
  INTR ("clog", NO_TEXT, "clogq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxlog),
  INTR ("clog", NO_TEXT, "cxlog", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "CMPLXF", COMPLEX, 8, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "CMPLX", COMPLEX, 16, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "CMPLXQ", COMPLEX, 32, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "CMPLXX", COMPLEX, 64, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "(complex_8)", COMPLEX, 8, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "(complex_16)", COMPLEX, 16, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "(complex_32)", COMPLEX, 32, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cmplx", NO_TEXT, "cxconv", COMPLEX, 64, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("conjg", NO_TEXT, "conjf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("conjg", NO_TEXT, "conj", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("conjg", NO_TEXT, "conjq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("conjg", NO_TEXT, "cxconj", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cos", NO_TEXT, "ccosf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxcos),
  INTR ("cos", NO_TEXT, "ccos", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxcos),
  INTR ("cos", NO_TEXT, "ccosq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxcos),
  INTR ("cos", NO_TEXT, "cxcos", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("csin", NO_TEXT, "csinf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxsin),
  INTR ("csin", NO_TEXT, "csin", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxsin),
  INTR ("csin", NO_TEXT, "cxsin", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("csin", NO_TEXT, "csinq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxsin),
  INTR ("csqrt", NO_TEXT, "csqrtf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxsqrt),
  INTR ("csqrt", NO_TEXT, "csqrt", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxsqrt),
  INTR ("csqrt", NO_TEXT, "csqrtq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxsqrt),
  INTR ("csqrt", NO_TEXT, "cxsqrt", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ctan", NO_TEXT, "ctanf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxtan),
  INTR ("ctan", NO_TEXT, "ctan", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxtan),
  INTR ("ctan", NO_TEXT, "ctanq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxtan),
  INTR ("ctan", NO_TEXT, "cxtan", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dble", "(real_8)", "crealf", REAL, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dble", "(real_8)", "creal", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dble", "(real_8)", "crealq", REAL, 8, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dble", "(real_8)", "cxrealq", REAL, 8, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", "(complex_16)", "CMPLXF", COMPLEX, 16, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", NO_TEXT, "CMPLX", COMPLEX, 16, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", "(complex_16)", "CMPLXQ", COMPLEX, 16, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", "(complex_16)", "qxcmplx", COMPLEX, 16, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", "(complex_16)", "(real_8)", COMPLEX, 16, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", NO_TEXT, "(complex_16)", COMPLEX, 16, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", "(complex_16)", "(real_8)", COMPLEX, 16, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dcmplx", "(complex_16)", "qxcmplx", COMPLEX, 16, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dimag", "(real_8)", "cimagf", REAL, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dimag", NO_TEXT, "cimag", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dimag", "(real_8)", "cimagq", REAL, 8, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dimag", "xtodbl", "cximag", REAL, 8, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("exp", NO_TEXT, "cexpf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxexp),
  INTR ("exp", NO_TEXT, "cexp", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxexp),
  INTR ("exp", NO_TEXT, "cexpq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxexp),
  INTR ("exp", NO_TEXT, "cxexp", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("imag", NO_TEXT, "cimagf", REAL, 4, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("imag", NO_TEXT, "cimag", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("imag", NO_TEXT, "cimagq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("imag", NO_TEXT, "cximag", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("int", "(int_4)", "crealf", INTEGER, 4, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("int", "(int_4)", "creal", INTEGER, 4, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("int", "(int_4)", "crealq", INTEGER, 4, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("int", "(int_4)", "cxreal", INTEGER, 4, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("log", NO_TEXT, "clogf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxlog),
  INTR ("log", NO_TEXT, "clog", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxlog),
  INTR ("log", NO_TEXT, "clogq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxlog),
  INTR ("log", NO_TEXT, "cxlog", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", NO_TEXT, "CMPLXQ", COMPLEX, 32, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", NO_TEXT, "CMPLXQ", COMPLEX, 32, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", NO_TEXT, "CMPLXQ", COMPLEX, 32, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", NO_TEXT, "qxcmplx", COMPLEX, 32, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", NO_TEXT, "(complex_32)", COMPLEX, 32, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", NO_TEXT, "(complex_32)", COMPLEX, 32, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", NO_TEXT, "(complex_32)", COMPLEX, 32, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qcmplx", "(complex_32)", "xtoquad", COMPLEX, 32, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qimag", "(real_16)", "cimagf", REAL, 16, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qimag", "(real_16)", "cimag", REAL, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qimag", NO_TEXT, "cimagq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qimag", NO_TEXT, "cximagq", REAL, 16, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", "(real_4)", "crealf", REAL, 4, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", "(real_4)", "creal", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", "(real_4)", "crealq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("real", "(real_4)", "cxrealq", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sin", NO_TEXT, "csinf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxsin),
  INTR ("sin", NO_TEXT, "csin", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxsin),
  INTR ("sin", NO_TEXT, "csinq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxsin),
  INTR ("sin", NO_TEXT, "cxsin", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("sqrt", NO_TEXT, "csqrtf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxsqrt),
  INTR ("sqrt", NO_TEXT, "csqrt", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxsqrt),
  INTR ("sqrt", NO_TEXT, "csqrtq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxsqrt),
  INTR ("sqrt", NO_TEXT, "cxsqrt", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("tan", NO_TEXT, "ctanf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxtan),
  INTR ("tan", NO_TEXT, "ctan", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxtan),
  INTR ("tan", NO_TEXT, "ctanq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxtan),
  INTR ("tan", NO_TEXT, "cxtan", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", NO_TEXT, "cxflt", COMPLEX, 64, 2, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", NO_TEXT, "cxdbl", COMPLEX, 64, 2, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", NO_TEXT, "cxquad", COMPLEX, 64, 2, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", NO_TEXT, "CMPLXX", COMPLEX, 64, 2, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", "cxconv", "flttox", COMPLEX, 64, 1, REAL, 4, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", "cxconv", "dbltox", COMPLEX, 64, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", "cxconv", "quadtox", COMPLEX, 64, 1, REAL, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xcmplx", NO_TEXT, "cxconv", COMPLEX, 64, 1, REAL, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ximag", "flttox", "cimagf", REAL, 32, 1, COMPLEX, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ximag", "dbltox", "cimag", REAL, 32, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ximag", NO_TEXT, "cximag", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ximag", "quadtox", "cimagq", REAL, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
// COMPLEX*8 specific
  INTR ("cabs", NO_TEXT, "_zabs_16", REAL, 8, 1, REAL, 8, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ccosf", NO_TEXT, "ccosf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxcos),
  INTR ("cexpf", NO_TEXT, "cexpf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxexp),
  INTR ("clogf", NO_TEXT, "clogf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxlog),
  INTR ("csinf", NO_TEXT, "csinf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxsin),
  INTR ("csqrtf", NO_TEXT, "csqrtf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxsqrt),
  INTR ("ctanf", NO_TEXT, "ctanf", COMPLEX, 8, 1, COMPLEX, 8, NO_FUN, NO_FUN, cxtan),
// COMPLEX specific
  INTR ("cdabs", NO_TEXT, "cabs", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cdcos", NO_TEXT, "ccos", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxcos),
  INTR ("cdexp", NO_TEXT, "cexp", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxexp),
  INTR ("cdint", "(int_4)", "creal", INTEGER, 4, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cdlog", NO_TEXT, "clog", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxlog),
  INTR ("cdsin", NO_TEXT, "csin", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxsin),
  INTR ("cdsqrt", NO_TEXT, "csqrt", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxsqrt),
  INTR ("cdtan", NO_TEXT, "ctan", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, cxtan),
  INTR ("cqabs", NO_TEXT, "cabsq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cqcos", NO_TEXT, "ccosq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxcos),
  INTR ("cqexp", NO_TEXT, "cexpq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxexp),
  INTR ("cqint", "(int_4)", "crealq", INTEGER, 4, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cqlog", NO_TEXT, "clogq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxlog),
  INTR ("cqsin", NO_TEXT, "csinq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxsin),
  INTR ("cqsqrt", NO_TEXT, "csqrtq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxsqrt),
  INTR ("cqtan", NO_TEXT, "ctanq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, cxtan),
  INTR ("cxabs", NO_TEXT, "cxabs", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cxcos", NO_TEXT, "cxcos", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cxexp", NO_TEXT, "cxexp", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cxlog", NO_TEXT, "cxlog", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cxsin", NO_TEXT, "cxsin", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cxsqrt", NO_TEXT, "cxsqrt", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("cxtan", NO_TEXT, "cxtan", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dconjg", NO_TEXT, "conj", COMPLEX, 16, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dimag", NO_TEXT, "cimag", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("dreal", NO_TEXT, "creal", REAL, 8, 1, COMPLEX, 16, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qconjg", NO_TEXT, "conjq", COMPLEX, 32, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qimag", NO_TEXT, "cimagq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("qreal", NO_TEXT, "crealq", REAL, 16, 1, COMPLEX, 32, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xconjg", NO_TEXT, "cxconj", COMPLEX, 64, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("ximag", NO_TEXT, "cximag", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
  INTR ("xreal", NO_TEXT, "cxreal", REAL, 32, 1, COMPLEX, 64, NO_FUN, NO_FUN, NO_FUN),
// End of list
  INTR (NO_TEXT, NO_TEXT, NO_TEXT, NOTYPE, 0, 0, NOTYPE, 0, NO_FUN, NO_FUN, NO_FUN)
};

logical_4 is_intrins (char *name, INTRINS ** F)
{
  int_4 N = 0;
  (*F) = NO_INTRINS;
  for (int_4 k = 0; fun[k].ffun != NO_TEXT; k++) {
    if (EQUAL (name, fun[k].ffun)) {
      N++;
      if ((*F) == NO_INTRINS) {
        (*F) = &fun[k];
      }
    }
  }
  return N;
}

logical_4 is_specific (char *name)
{
// Match name for table to approve for INTRINSIC statement.
  INTRINS *F;
  return is_intrins (name, &F) == 1;
}

logical_4 intrinsic_call (char *name, EXPR * loc)
{
  EXPR lhs, rhs;
  INTRINS *F;
// If 'name' is not an intrinsic function, stop here.
  if (! is_intrins (name, &F)) {
    return FALSE;
  }
//
  memset (loc, 0, sizeof (EXPR));
  (void) scan (EXPECT_NONE);
  if (! TOKEN ("(")) {
    UNSCAN;
    return FALSE;
  }
  (void) scan (EXPECT_NONE);
  express (&lhs, NOTYPE, 0);
  if (!valid_expr (&lhs)) {
    return FALSE;
  }
  (void) scan (EXPECT_NONE);
  if (!TOKEN (",") && (lhs.mode.type == CHARACTER)) {
// 1 operand, CHARACTER, length independent.
    UNSCAN;
    for (int_4 k = 0; fun[k].ffun != NO_TEXT; k++) {
      F = &fun[k];
      if (EQUAL (name, F->ffun) && (lhs.mode.type == F->atyp)) {
        _srecordf (loc->str, "%s (%s)", F->cfun, lhs.str);
        if (F->rtyp == CHARACTER && F->rlen == 0) {
          loc->mode = (MODE) {.type = F->rtyp, .len = F->alen, .dim = 0};
        } else {
          loc->mode = (MODE) {.type = F->rtyp, .len = F->rlen, .dim = 0};
        }
        (void) scan (")");
        return TRUE;
      }
    }
    NEW_RECORD (str);
    _srecordf (str, "%s (%s)", name, qtype (&(lhs.mode)));
    ERROR (2301, "undefined", str);
    (void) scan (")");
    return FALSE;
  } else if (!TOKEN (",")) {
// 1 operand.
    UNSCAN;
    for (int_4 k = 0; fun[k].ffun != NO_TEXT; k++) {
      F = &fun[k];
      if (EQUAL (name, F->ffun) && F->anum == 1 && accept_mode (lhs.mode.type, lhs.mode.len, F->atyp, F->alen)) {
        if (fold_intrinsic (F, &lhs, NO_EXPR)) {
          _srecordf (loc->str, "%s", lhs.str);
          loc->variant = EXPR_CONST;
          loc->mode = (MODE) { .type = F->rtyp, .len = _max (F->rlen, lhs.mode.len), .dim = 0};
        } else if (F->bfun != NO_TEXT) {
          _srecordf (loc->str, "%s (%s (%s))", F->bfun, F->cfun, lhs.str);
          loc->mode = (MODE) { .type = F->rtyp, .len = F->rlen, .dim = 0};
        } else {
          _srecordf (loc->str, "%s (%s)", F->cfun, lhs.str);
          loc->mode = (MODE) { .type = F->rtyp, .len = F->rlen, .dim = 0};
        }
        (void) scan (")");
        return TRUE;
      }
    }
    NEW_RECORD (str);
    _srecordf (str, "%s (%s)", name, qtype (&(lhs.mode)));
    ERROR (2302, "undefined", str);
    (void) scan (")");
    return FALSE;
  } else {
// >= 2 operands
    (void) scan (EXPECT_NONE);
    express (&rhs, NOTYPE, 0);
    if (!valid_expr (&rhs)) {
      return FALSE;
    }
    int_4 llen = lhs.mode.len, rlen = rhs.mode.len;
    if ((lhs.variant == EXPR_CONST || rhs.variant == EXPR_CONST)) {
// Cross terms involving constants - adapt to non-constant.
      if (lhs.variant != EXPR_CONST) {
        rlen = llen;
      } else if (rhs.variant != EXPR_CONST) {
        llen = rlen;
      } else {
        llen = rlen = _max (llen, rlen);
      }
    } else {
      llen = rlen = _max (llen, rlen);
    }
    for (int_4 k = 0; fun[k].ffun != NO_TEXT; k++) {
      F = &fun[k];
      if (EQUAL (name, F->ffun) && F->anum != 1 && accept_mode (lhs.mode.type, lhs.mode.len, F->atyp, F->alen) && accept_mode (rhs.mode.type, rhs.mode.len, F->atyp, F->alen)) {
        loc->mode = (MODE) {.type = F->rtyp, .len = F->rlen, .dim = 0};
        (void) scan (EXPECT_NONE);
        if (TOKEN (")") && (F->anum == 2 || F->anum == 0)) {
// 2 operands
          if (fold_intrinsic (F, &lhs, &rhs)) {
            _srecordf (loc->str, "%s", lhs.str);
            loc->variant = EXPR_CONST;
            loc->mode = (MODE) { .type = F->rtyp, .len = _max (lhs.mode.len, rhs.mode.len) , .dim = 0};
          } else if (F->bfun != NO_TEXT) {
            _srecordf (loc->str, "%s (%s (%s, %s))", F->bfun, F->cfun, lhs.str, rhs.str);
          } else {
            _srecordf (loc->str, "%s (%s, %s)", F->cfun, lhs.str, rhs.str);
          }
          return TRUE;
        } else if (TOKEN (",") && F->anum == 0) {
// > 2 operands
          NEW_RECORD (idf); NEW_RECORD (str); NEW_RECORD (tmp);
          _srecordf (idf, "%s", edit_tmp (nloctmps++));
          add_local (idf, loc->mode.type, loc->mode.len, UNIQ, NOPATCH, NOARG, LOCAL, TEMP);
          str[0] = '\0';
          _srecordf (str, "%s = %s (%s, %s)", idf, F->cfun, lhs.str, rhs.str);
          while (TOKEN (",")) {
            (void) scan (EXPECT_NONE);
            express (&rhs, NOTYPE, 0);
            (void) scan (EXPECT_NONE);
            if (TOKEN (",")) {
              _srecordf (tmp, ", %s = %s (%s, %s)", idf, F->cfun, idf, rhs.str);
            } else if (TOKEN (")")) {
              _srecordf (tmp, ", %s (%s, %s)", F->cfun, idf, rhs.str);
            } else {
              EXPECT (2303, ", or )");
            }
            bufcat (str, tmp, RECLN);
          }
          _srecordf (loc->str, "(%s)", str);
          return TRUE;
        } else {
          SYNTAX (2304, "number of operands");
        }
      }
    }
    NEW_RECORD (str);
    _srecordf (str, "%s (%s, %s)", name, qtype (&(lhs.mode)), qtype (&(rhs.mode)));
    ERROR (2305, "undefined", str);
    (void) scan (")");
    return FALSE;
  }
}

void compile_nested_intrinsic (char *name)
{
// Compile a nested function for an INTRINSIC declared function.
  INTRINS *F = NO_INTRINS;
  int N = is_intrins (name, &F);
  if (N == 0 || F == NO_INTRINS) {
    ERROR (2306, "not an intrinsic fuction", name);
    return;
  }
  if (N > 1 || F->anum == 0 || F->atyp == CHARACTER || F->rtyp == CHARACTER) {
// Silently return.
    NEW_RECORD (msg);
    _srecordf (msg, "// refusing a nested function for %s\n", name);
    code (nprocs, NESTED, msg);
    return;
  }
  NEW_STATIC_RECORD (f);
  MODE res = (MODE) {.type = F->rtyp, .len = F->rlen};
  MODE arg = (MODE) {.type = F->atyp, .len = F->alen};
  IDENT *idf = add_local (name, NOTYPE, NOLEN, UNIQ, NOPATCH, NOARG, LOCAL, TEMP);
  if (idf->external) {
    ERROR (2307, "redefining external function", F_NAME (idf));
  } else if (idf->intrinsic) {
    ERROR (2308, "redefining intrinsic function", F_NAME (idf));
  }
  if (F->anum == 1) {
    if (F->bfun != NO_TEXT) {
      _srecordf (f, "%s %s (%s __x__) {return %s (%s (%s));}\n", 
        wtype (&res, NOARG, NOFUN), 
        edit_i (name), 
        wtype (&arg, ARG, NOFUN), 
        F->bfun,
        F->cfun,
        (F->atyp == CHARACTER ? "__x__" : "*__x__")
      );
    } else { 
      _srecordf (f, "%s %s (%s __x__) {return %s (%s);}\n", 
        wtype (&res, NOARG, NOFUN), 
        edit_i (name), 
        wtype (&arg, ARG, NOFUN), 
        F->cfun,
        (F->atyp == CHARACTER ? "__x__" : "*__x__")
      );
    } 
  } else {
    if (F->bfun != NO_TEXT) {
      _srecordf (f, "%s %s (%s __x__, %s __y__) {return %s (%s (%s, %s));}\n", 
        wtype (&res, NOARG, NOFUN), 
        edit_i (name), 
        wtype (&arg, ARG, NOFUN), 
        wtype (&arg, ARG, NOFUN), 
        F->bfun,
        F->cfun,
        (F->atyp == CHARACTER ? "__x__" : "*__x__"),
        (F->atyp == CHARACTER ? "__y__" : "*__y__")
      ); 
    } else { 
      _srecordf (f, "%s %s (%s __x__, %s __y__) {return %s (%s, %s);}\n", 
        wtype (&res, NOARG, NOFUN), 
        edit_i (name), 
        wtype (&arg, ARG, NOFUN), 
        wtype (&arg, ARG, NOFUN), 
        F->cfun,
        (F->atyp == CHARACTER ? "__x__" : "*__x__"),
        (F->atyp == CHARACTER ? "__y__" : "*__y__")
      ); 
    }
  }
  code (nprocs, NESTED, f);
  idf->mode = res;
  idf->intrinsic = TRUE;
  return;
}
