//! @file parameter.c
//! @author J. Marcel van der Veer
//
//! @section Copyright
//
// This file is part of VIF - vintage FORTRAN compiler.
// Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
//
//! @section License
//
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the 
// Free Software Foundation; either version 3 of the License, or 
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details. You should have received a copy of the GNU General Public 
// License along with this program. If not, see <http://www.gnu.org/licenses/>.

//! @section Synopsis
//!
//! Compile PARAMETER.

#include <vif.h>

void parameter (void)
{
  int_4 rc, go_on = TRUE;
  rc = scan (EXPECT_NONE);
  if (!TOKEN ("(")) {
    EXPECT (2701, "(");
    return;
  }
  while (go_on) {
    rc = scan (EXPECT_NONE);
    if (TOKEN (")")) {
      break;
    }
    if (rc != WORD) {
      EXPECT (2702, "variable");
    }
    // IBM VS Fortran - idf must have been specified, explicitly or implicitly.
    MODE mode;
    IDENT *idf = impl_decl (curlex, &mode);
    rc = scan ("=");
    rc = scan (EXPECT_NONE);
    EXPR reg;
    macro_depth = 0;
    express (&reg, mode.type, mode.len);
    if (reg.variant == EXPR_CONST) {
      idf->parm = f_stralloc (reg.str);
      if (idf->mode.type == NOTYPE) {
        idf->mode = reg.mode;
      }
      // Write constant in the listing file.
      NEW_RECORD (fold);
      snprintf (fold, RECLN, "// %s = %s", C_NAME(idf), idf->parm);
      code (nprocs, PARAMETERS, fold); 
    } else {
      EXPECT (2703, "constant");
    }
    rc = scan (EXPECT_NONE);
    if (TOKEN (",")) {
      continue;
    } else if (TOKEN (")")) {
      go_on = FALSE;
    } else {
      EXPECT (2704, ", or )");
      go_on = FALSE;
    }
  }
  (void) rc;
}
