! @section Synopsis
!
! FORTRAN IV library functions for VIF.
!
! @author J. Marcel van der Veer
!
! @section copyright
!
! This file is part of VIF - vintage fortran compiler.
! Copyright 2020-2025 J. Marcel van der Veer <algol68g@xs4all.nl>.
!
! @section license
!
! This program is free software; you can redistribute it and/or modify it 
! under the terms of the gnu general public license as published by the 
! free software foundation; either version 3 of the license, or 
! (at your option) any later version.
!
! This program is distributed in the hope that it will be useful, but 
! without any warranty; without even the implied warranty of merchantability 
! or fitness for a particular purpose. See the GNU general public license for 
! more details. You should have received a copy of the GNU general public 
! license along with this program. If not, see <http://www.gnu.org/licenses/>.
!
      SUBROUTINE slite (i)
! SLITE (Sense LIghTEs) sets indicators.
      COMMON /slites/ ilites(36)
      IF (i .eq. 0) THEN
        DO j = 1, 36
          ilites(j) = 2
        END DO
      ELSE IF (i .le. 36) then
        ilites(i) = 1
      END IF 
      END

      SUBROUTINE slitet (i, j)
! SLITET tests indicators set by SLITE.
      COMMON /slites/ ilites(36)
      IF (i .ge. 1 .and. i .le. 36) THEN
        j = ilites(i)
        ilites(i) = 2
      END IF
      END
