10 PRINT "PROGRAM FILE 206: ERROR - ORDERING RELATIONS BETWEEN STRINGS."
20 PRINT "    ANSI STANDARD 3.2, 3.4, 3.6, 10.2"
30 PRINT
40 PRINT "THIS PROGRAM TESTS WHETHER, AS AN ENHANCEMENT, THE COMPARISON"
50 PRINT "OF STRINGS WITH THE '<' AND '>' RELATIONS IS ALLOWED."
60 PRINT
70 PRINT "THIS IS A TEST FOR A NON-STANDARD FEATURE OF MINIMAL BASIC."
80 PRINT "TO PASS THIS TEST, THE PROCESSOR MUST EITHER:"
90 PRINT
100 PRINT "   1) ACCEPT THE PROGRAM AND BE ACCOMPANIED BY DOCUMENTATION"
110 PRINT "      ACCURATELY DESCRIBING THE FEATURE'S INTERPRETATION"
120 PRINT "      BY THE PROCESSOR, OR"
130 PRINT
140 PRINT "   2) REJECT THE PROGRAM WITH AN APPROPRIATE ERROR MESSAGE"
150 PRINT
160 PRINT "SEE THE NBS MINIMAL BASIC TEST PROGRAMS USER'S MANUAL"
170 PRINT "FOR DETAILED CRITERIA."
180 PRINT
190 PRINT "SECTION 206.1: COLLATING SEQUENCE."
200 PRINT
210 PRINT "IF THIS IMPLEMENTATION ALLOWS THE ORDERING RELATIONS,"
220 PRINT "AN INFORMATIVE SORT IS DONE TO DISPLAY THE IMPLICIT"
230 PRINT "COLLATING SEQUENCE OF THE CHARACTERS (ASSUMING THE NATURAL"
240 PRINT "INTERPRETATION IS GIVEN TO THESE RELATIONS)."
250 PRINT
260 PRINT "                    BEGIN TEST."
270 PRINT
280 PRINT "COLLATING SEQUENCE OF SELECTED CHARACTERS IS:"
290 PRINT "(CHARACTERS SURROUNDED BY PERIODS)"
300 PRINT
310 REM SORT 30 CHARACTERS, 15 AT A TIME BECAUSE OF NAME SPACE LIMITS
320 LET L=15
330 READ W$
340 REM THROUGHOUT, VARIABLES A$ - O$ ARE TREATED AS A STRING ARRAY,
350 REM INDEXED BY N, 1 <= N <= 15.
360 LET A$=W$
370 REM Z$ IS HIGHEST SO FAR, H1 ITS INDEX
380 LET Z$=W$
390 LET H1=1
400 REM LOAD IN 1ST L, AND NOTE HIGHEST
410 FOR N=2 TO L
420 READ W$
430 GOSUB 4000
440 IF W$ < Z$ THEN 470
450 LET Z$=W$
460 LET H1=N
470 NEXT N
480 REM READ NEXT L CHARACTERS, FOR EACH, COMPARE TO HIGHEST IN TABLE.
490 REM IF THIS ONE < HIGHEST, REPLACE HIGHEST WITH IT, AND THEN
500 REM FIND NEW HIGHEST.
510 FOR I=1 TO L
520 READ W$
530 REM IF THIS > HIGHEST, SKIP
540 IF W$ > Z$ THEN 660
550 LET N=H1
560 GOSUB 4000
570 LET H1=1
580 LET Z$ =A$
590 REM SCAN FOR NEW HIGHEST
600 FOR N=2 TO L
610 GOSUB 3000
620 IF W$<Z$ THEN 650
630 LET Z$=W$
640 LET H1=N
650 NEXT N
660 NEXT I
670 REM TABLE NOW HAS LOWEST L CHARACTERS; DO SORT ON THOSE
680 GOSUB 2000
690 RESTORE
700 LET N=1
710 REM READ ALL L+L. PUT INTO TABLE ONLY THOSE > HIGHEST OF THE
720 REM LOWEST L CHARACTERS ALREADY SORTED.
730 FOR I=1 TO L+L
740 READ W$
750 IF W$ > Z$ THEN 770
760 GOTO 790
770 GOSUB 4000
780 LET N=N+1
790 NEXT I
800 REM SORT THE HIGH L CHARACTERS.
810 GOSUB 2000
812 PRINT
815 PRINT "IF DOCUMENTATION AGREES WITH THE ABOVE RESULTS, THEN"
818 PRINT "*** TEST PASSED ***"
820 PRINT
830 PRINT "                     END TEST."
840 PRINT
850 PRINT "SECTION 206.2: COLLATING MULTI-CHARACTER STRINGS."
860 PRINT
870 PRINT "THIS SECTION DISPLAYS SOME SUGGESTIVE TEST CASES TO"
880 PRINT "SHOW HOW THIS IMPLEMENTATION HANDLES COMPARISONS OF"
890 PRINT "MULTI-CHARACTER STRINGS. ALL STRINGS SHOWN ARE DELIMITED"
895 PRINT "BY APOSTROPHES TO ENABLE THE USER TO DISTINGUISH BLANKS"
897 PRINT "FROM NULL."
900 PRINT
903 PRINT "                    BEGIN TEST."
906 PRINT
910 READ A$,B$
920 IF A$ = "999" THEN 1110
930 LET C$ = "="
940 IF A$=B$ THEN 1000
950 LET C$="<"
960 IF A$<B$ THEN 1000
970 LET C$=">"
980 IF A$>B$ THEN 1000
990 LET C$="INCOMPARABLE TO"
1000 PRINT "'";A$;"' ";C$;" '";B$;"'"
1010 GOTO 910
1110 PRINT
1120 PRINT "IF DOCUMENTATION AGREES WITH ABOVE RESULTS, THEN"
1130 PRINT "*** TEST PASSED ***"
1140 PRINT
1150 PRINT "                     END TEST."
1160 PRINT
1900 PRINT "END PROGRAM 206"
1990 STOP
2000 REM THIS SUBROUTINE SORTS AND PRINTS THE CHARACTERS IN A$ - O$
2010 REM ALGORITHM IS SIMPLE EXCHANGE SORT
2020 FOR I=1 TO L-1
2030 FOR J=I+1 TO L
2040 LET N=I
2050 GOSUB 3000
2060 LET X$=W$
2070 LET N=J
2080 GOSUB 3000
2090 LET Y$=W$
2100 IF X$ < Y$ THEN 2180
2110 REM SWAP ITH AND JTH CHARACTERS
2120 LET N=I
2130 LET W$=Y$
2140 GOSUB 4000
2150 LET N=J
2160 LET W$=X$
2170 GOSUB 4000
2180 NEXT J
2190 NEXT I
2200 PRINT ".";
2210 FOR N=1 TO L
2220 GOSUB 3000
2230 PRINT W$;".";
2240 NEXT N
2250 PRINT
2260 RETURN
3000 REM SUBROUTINE TO GET NTH CHARACTER INTO W$
3010 IF N > 7 THEN 3030
3020 ON N GOTO 3040,3060,3080,3100,3120,3140,3160
3030 ON N-7 GOTO 3180,3200,3220,3240,3260,3280,3300,3320
3040 LET W$=A$
3050 GOTO 3340
3060 LET W$=B$
3070 GOTO 3340
3080 LET W$=C$
3090 GOTO 3340
3100 LET W$=D$
3110 GOTO 3340
3120 LET W$=E$
3130 GOTO 3340
3140 LET W$=F$
3150 GOTO 3340
3160 LET W$=G$
3170 GOTO 3340
3180 LET W$=H$
3190 GOTO 3340
3200 LET W$=I$
3210 GOTO 3340
3220 LET W$=J$
3230 GOTO 3340
3240 LET W$=K$
3250 GOTO 3340
3260 LET W$=L$
3270 GOTO 3340
3280 LET W$=M$
3290 GOTO 3340
3300 LET W$=N$
3310 GOTO 3340
3320 LET W$=O$
3340 RETURN
4000 REM SUBROUTINE TO GET W$ INTO NTH CHARACTER
4010 IF N > 7 THEN 4030
4020 ON N GOTO 4040,4060,4080,4100,4120,4140,4160
4030 ON N-7 GOTO 4180,4200,4220,4240,4260,4280,4300,4320
4040 LET A$=W$
4050 GOTO 4340
4060 LET B$=W$
4070 GOTO 4340
4080 LET C$=W$
4090 GOTO 4340
4100 LET D$=W$
4110 GOTO 4340
4120 LET E$=W$
4130 GOTO 4340
4140 LET F$=W$
4150 GOTO 4340
4160 LET G$=W$
4170 GOTO 4340
4180 LET H$=W$
4190 GOTO 4340
4200 LET I$=W$
4210 GOTO 4340
4220 LET J$=W$
4230 GOTO 4340
4240 LET K$=W$
4250 GOTO 4340
4260 LET L$=W$
4270 GOTO 4340
4280 LET M$=W$
4290 GOTO 4340
4300 LET N$=W$
4310 GOTO 4340
4320 LET O$=W$
4340 RETURN
5000 DATA "A","M","Z","O","1","8"
5010 DATA "9"," ","!","#","$","%"
5020 DATA "&","'","(",")","*","+"
5030 DATA ",","-",".","/",":",";"
5040 DATA "<","=",">","?","^","_"
6000 DATA "ABC","ABC"
6005 DATA "ABC","ABD"
6010 DATA "ABC","XYZ"
6020 DATA "ABC","ABC  "
6030 DATA "ABC","  ABC"
6040 DATA "ABC  ","  ABC"
6050 DATA "ABC","ABCD"
6060 DATA "ABC","  "
6070 DATA "ABC",""
6080 DATA "","  "
6090 DATA "  ","    "
6100 DATA "  ABC"," "
6110 DATA "  ABC","  "
6120 DATA "  ABC","   "
7000 DATA "999","999"
8000 END
