/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.delegate;

import games.strategy.common.delegate.BasePersistentDelegate;
import games.strategy.common.delegate.GameDelegateBridge;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.gamePlayer.IRemotePlayer;
import games.strategy.engine.history.Event;
import games.strategy.engine.history.EventChild;
import games.strategy.engine.history.HistoryNode;
import games.strategy.engine.history.Step;

public abstract class BaseEditDelegate
extends BasePersistentDelegate {
    public static String EDITMODE_ON = "Turning on Edit Mode";
    public static String EDITMODE_OFF = "Turning off Edit Mode";

    @Override
    public void setDelegateBridgeAndPlayer(IDelegateBridge iDelegateBridge) {
        super.setDelegateBridgeAndPlayer(new GameDelegateBridge(iDelegateBridge));
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public void end() {
    }

    @Override
    public boolean delegateCurrentlyRequiresUserInput() {
        return true;
    }

    public static boolean getEditMode(GameData data) {
        Object editMode = data.getProperties().get("EditMode");
        if (editMode == null) {
            return false;
        }
        if (!(editMode instanceof Boolean)) {
            return false;
        }
        return (Boolean)editMode;
    }

    protected String checkPlayerID() {
        IRemotePlayer remotePlayer = this.getRemotePlayer();
        if (!this.m_bridge.getPlayerID().equals(remotePlayer.getPlayerID())) {
            return "Edit actions can only be performed during players turn";
        }
        return null;
    }

    protected String checkEditMode() {
        String result = this.checkPlayerID();
        if (null != result) {
            return result;
        }
        if (!BaseEditDelegate.getEditMode(this.getData())) {
            return "Edit mode is not enabled";
        }
        return null;
    }

    public String setEditMode(boolean editMode) {
        IRemotePlayer remotePlayer = this.getRemotePlayer();
        if (!this.m_bridge.getPlayerID().equals(remotePlayer.getPlayerID())) {
            return "Edit Mode can only be toggled during players turn";
        }
        this.logEvent(editMode ? EDITMODE_ON : EDITMODE_OFF, null);
        this.m_bridge.addChange(ChangeFactory.setProperty("EditMode", new Boolean(editMode), this.getData()));
        return null;
    }

    public boolean getEditMode() {
        return BaseEditDelegate.getEditMode(this.getData());
    }

    public String addComment(String message) {
        String result = null;
        result = this.checkPlayerID();
        if (null != result) {
            return result;
        }
        this.logEvent("COMMENT: " + message, null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logEvent(String message, Object renderingObject) {
        boolean foundChild = false;
        GameData game_data = this.getData();
        game_data.acquireReadLock();
        try {
            HistoryNode curNode = game_data.getHistory().getLastNode();
            while (!(curNode instanceof Step) && !(curNode instanceof Event)) {
                if (curNode instanceof EventChild) {
                    foundChild = true;
                    break;
                }
                curNode = (HistoryNode)curNode.getPreviousNode();
            }
        }
        finally {
            game_data.releaseReadLock();
        }
        if (foundChild) {
            this.m_bridge.getHistoryWriter().addChildToEvent(message, renderingObject);
        } else {
            this.m_bridge.getHistoryWriter().startEvent(message, renderingObject);
        }
    }
}

