/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.delegate;

import games.strategy.common.delegate.AbstractDelegate;
import games.strategy.common.delegate.BaseDelegateState;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegate;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.triplea.Properties;
import games.strategy.triplea.ai.weakAI.WeakAI;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.delegate.PoliticsDelegate;
import games.strategy.triplea.player.ITripleaPlayer;
import games.strategy.triplea.ui.display.ITripleaDisplay;
import games.strategy.util.CompositeMatchAnd;
import java.io.Serializable;
import java.util.HashSet;

public abstract class BaseTripleADelegate
extends AbstractDelegate
implements IDelegate {
    private boolean m_startBaseStepsFinished = false;
    private boolean m_endBaseStepsFinished = false;

    @Override
    public void start() {
        super.start();
        if (!this.m_startBaseStepsFinished) {
            this.m_startBaseStepsFinished = true;
            this.triggerWhenTriggerAttachments("before");
        }
    }

    @Override
    public void end() {
        super.end();
        if (!this.m_endBaseStepsFinished) {
            this.m_endBaseStepsFinished = true;
            this.triggerWhenTriggerAttachments("after");
        }
        this.m_startBaseStepsFinished = false;
        this.m_endBaseStepsFinished = false;
    }

    @Override
    public Serializable saveState() {
        BaseDelegateState state = new BaseDelegateState();
        state.m_startBaseStepsFinished = this.m_startBaseStepsFinished;
        state.m_endBaseStepsFinished = this.m_endBaseStepsFinished;
        return state;
    }

    @Override
    public void loadState(Serializable state) {
        BaseDelegateState s = (BaseDelegateState)state;
        this.m_startBaseStepsFinished = s.m_startBaseStepsFinished;
        this.m_endBaseStepsFinished = s.m_endBaseStepsFinished;
    }

    private void triggerWhenTriggerAttachments(String beforeOrAfter) {
        GameData data = this.getData();
        if (Properties.getTriggers(data)) {
            String stepName = data.getSequence().getStep().getName();
            CompositeMatchAnd<TriggerAttachment> baseDelegateWhenTriggerMatch = new CompositeMatchAnd<TriggerAttachment>(TriggerAttachment.availableUses, TriggerAttachment.whenOrDefaultMatch(beforeOrAfter, stepName));
            TriggerAttachment.collectAndFireTriggers(new HashSet<PlayerID>(data.getPlayerList().getPlayers()), baseDelegateWhenTriggerMatch, this.m_bridge, beforeOrAfter, stepName);
        }
        PoliticsDelegate.chainAlliancesTogether(this.m_bridge);
    }

    @Override
    protected ITripleaDisplay getDisplay() {
        return BaseTripleADelegate.getDisplay(this.m_bridge);
    }

    protected static ITripleaDisplay getDisplay(IDelegateBridge bridge) {
        return (ITripleaDisplay)bridge.getDisplayChannelBroadcaster();
    }

    @Override
    protected ITripleaPlayer getRemotePlayer() {
        return BaseTripleADelegate.getRemotePlayer(this.m_bridge);
    }

    protected static ITripleaPlayer getRemotePlayer(IDelegateBridge bridge) {
        return (ITripleaPlayer)bridge.getRemotePlayer();
    }

    @Override
    protected ITripleaPlayer getRemotePlayer(PlayerID player) {
        return BaseTripleADelegate.getRemotePlayer(player, this.m_bridge);
    }

    protected static ITripleaPlayer getRemotePlayer(PlayerID player, IDelegateBridge bridge) {
        if (player.isNull()) {
            return new WeakAI(player.getName(), "Easy (AI)");
        }
        return (ITripleaPlayer)bridge.getRemotePlayer(player);
    }
}

