/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.delegate;

import games.strategy.common.delegate.GameDelegateHistoryWriter;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.delegate.IDelegateBridge;
import games.strategy.engine.display.IDisplay;
import games.strategy.engine.gamePlayer.IRemotePlayer;
import games.strategy.engine.history.IDelegateHistoryWriter;
import games.strategy.engine.random.IRandomStats;
import games.strategy.sound.ISound;
import java.util.Properties;

public class GameDelegateBridge
implements IDelegateBridge {
    private final IDelegateBridge m_bridge;
    private final GameDelegateHistoryWriter m_historyWriter;

    public GameDelegateBridge(IDelegateBridge bridge) {
        this.m_bridge = bridge;
        this.m_historyWriter = new GameDelegateHistoryWriter(this.m_bridge.getHistoryWriter(), this.getData());
    }

    @Override
    public GameData getData() {
        return this.m_bridge.getData();
    }

    @Override
    public IDelegateHistoryWriter getHistoryWriter() {
        return this.m_historyWriter;
    }

    @Override
    public PlayerID getPlayerID() {
        return this.m_bridge.getPlayerID();
    }

    @Override
    public int getRandom(int max, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        return this.m_bridge.getRandom(max, player, diceType, annotation);
    }

    @Override
    public int[] getRandom(int max, int count, PlayerID player, IRandomStats.DiceType diceType, String annotation) {
        return this.m_bridge.getRandom(max, count, player, diceType, annotation);
    }

    @Override
    public void addChange(Change aChange) {
        this.m_bridge.addChange(aChange);
    }

    @Override
    public String getStepName() {
        return this.m_bridge.getStepName();
    }

    @Override
    public IRemotePlayer getRemotePlayer() {
        return this.m_bridge.getRemotePlayer();
    }

    @Override
    public IRemotePlayer getRemotePlayer(PlayerID id) {
        return this.m_bridge.getRemotePlayer(id);
    }

    @Override
    public IDisplay getDisplayChannelBroadcaster() {
        return this.m_bridge.getDisplayChannelBroadcaster();
    }

    @Override
    public ISound getSoundChannelBroadcaster() {
        return this.m_bridge.getSoundChannelBroadcaster();
    }

    @Override
    public Properties getStepProperties() {
        return this.m_bridge.getStepProperties();
    }

    @Override
    public void leaveDelegateExecution() {
        this.m_bridge.leaveDelegateExecution();
    }

    @Override
    public void enterDelegateExecution() {
        this.m_bridge.enterDelegateExecution();
    }

    @Override
    public void stopGameSequence() {
        this.m_bridge.stopGameSequence();
    }
}

