/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.ui;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import games.strategy.common.ui.InGameLobbyWatcherWrapper;
import games.strategy.common.ui.MacWrapper;
import games.strategy.common.ui.MainGameFrame;
import games.strategy.common.ui.PlayersPanel;
import games.strategy.debug.ClientLogger;
import games.strategy.debug.Console;
import games.strategy.debug.DebugUtils;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.export.GameDataExporter;
import games.strategy.engine.data.properties.PropertiesUI;
import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.ServerGame;
import games.strategy.engine.framework.networkMaintenance.BanPlayerAction;
import games.strategy.engine.framework.networkMaintenance.BootPlayerAction;
import games.strategy.engine.framework.networkMaintenance.MutePlayerAction;
import games.strategy.engine.framework.networkMaintenance.SetPasswordAction;
import games.strategy.engine.framework.startup.login.ClientLoginValidator;
import games.strategy.engine.framework.startup.ui.MainFrame;
import games.strategy.engine.framework.ui.SaveGameFileChooser;
import games.strategy.engine.lobby.client.ui.action.EditGameCommentAction;
import games.strategy.engine.lobby.client.ui.action.RemoveGameFromLobbyAction;
import games.strategy.engine.message.DummyMessenger;
import games.strategy.engine.pbem.PBEMMessagePoster;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import games.strategy.net.IServerMessenger;
import games.strategy.triplea.delegate.GameStepPropertiesHelper;
import games.strategy.triplea.ui.AbstractUIContext;
import games.strategy.triplea.ui.history.HistoryLog;
import games.strategy.ui.IntTextField;
import games.strategy.util.CountDownLatchHandler;
import games.strategy.util.EventThreadJOptionPane;
import games.strategy.util.IllegalCharacterRemover;
import games.strategy.util.LocalizeHTML;
import games.strategy.util.SoftJEditorPane;
import games.strategy.util.Triple;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class BasicGameMenuBar<CustomGameFrame extends MainGameFrame>
extends JMenuBar {
    private static final long serialVersionUID = -1447295944297939539L;
    protected final CustomGameFrame m_frame;
    protected SoftJEditorPane m_gameNotesPane;

    public BasicGameMenuBar(CustomGameFrame frame) {
        this.m_frame = frame;
        this.createFileMenu(this);
        this.createGameSpecificMenus(this);
        InGameLobbyWatcherWrapper watcher = this.createLobbyMenu(this);
        this.createNetworkMenu(this, watcher);
        this.createWebHelpMenu(this);
        this.createHelpMenu(this);
    }

    protected void createGameSpecificMenus(JMenuBar menuBar) {
    }

    public void dispose() {
        if (this.m_gameNotesPane != null) {
            this.m_gameNotesPane.dispose();
        }
    }

    public SoftJEditorPane getGameNotesJEditorPane() {
        return this.m_gameNotesPane;
    }

    protected void addGameNotesMenu(JMenu parentMenu) {
        String notesProperty = this.getData().getProperties().get("notes", "");
        if (notesProperty != null && notesProperty.trim().length() != 0) {
            String notes = LocalizeHTML.localizeImgLinksInHTML(notesProperty.trim());
            this.m_gameNotesPane = new SoftJEditorPane(notes);
            parentMenu.add(new AbstractAction("Game Notes..."){
                private static final long serialVersionUID = -1817640666359299617L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JEditorPane pane = BasicGameMenuBar.this.m_gameNotesPane.getComponent();
                            final JScrollPane scroll = new JScrollPane(pane);
                            scroll.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
                            final JDialog dialog = new JDialog((Frame)BasicGameMenuBar.this.m_frame);
                            dialog.setModal(false);
                            dialog.setAlwaysOnTop(true);
                            dialog.add((Component)scroll, "Center");
                            JPanel buttons = new JPanel();
                            final JButton button = new JButton(new AbstractAction("OK"){
                                private static final long serialVersionUID = -6628015175043647980L;

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    dialog.setVisible(false);
                                    dialog.removeAll();
                                    dialog.dispose();
                                }
                            });
                            buttons.add(button);
                            dialog.getRootPane().setDefaultButton(button);
                            dialog.add((Component)buttons, "South");
                            dialog.pack();
                            if (dialog.getWidth() < 400) {
                                dialog.setSize(400, dialog.getHeight());
                            }
                            if (dialog.getHeight() < 300) {
                                dialog.setSize(dialog.getWidth(), 300);
                            }
                            if (dialog.getWidth() > 800) {
                                dialog.setSize(800, dialog.getHeight());
                            }
                            if (dialog.getHeight() > 600) {
                                dialog.setSize(dialog.getWidth(), 600);
                            }
                            dialog.setLocationRelativeTo((Component)BasicGameMenuBar.this.m_frame);
                            dialog.addWindowListener(new WindowAdapter(){

                                @Override
                                public void windowOpened(WindowEvent e) {
                                    scroll.getVerticalScrollBar().getModel().setValue(0);
                                    scroll.getHorizontalScrollBar().getModel().setValue(0);
                                    button.requestFocus();
                                }
                            });
                            dialog.setVisible(true);
                        }
                    });
                }
            }).setMnemonic(78);
        }
    }

    protected InGameLobbyWatcherWrapper createLobbyMenu(JMenuBar menuBar) {
        if (!(((MainGameFrame)this.m_frame).getGame() instanceof ServerGame)) {
            return null;
        }
        ServerGame serverGame = (ServerGame)((MainGameFrame)this.m_frame).getGame();
        InGameLobbyWatcherWrapper watcher = serverGame.getInGameLobbyWatcher();
        if (watcher == null || !watcher.isActive()) {
            return watcher;
        }
        JMenu lobby = new JMenu("Lobby");
        lobby.setMnemonic(76);
        menuBar.add(lobby);
        lobby.add(new EditGameCommentAction(watcher, (Component)this.m_frame));
        lobby.add(new RemoveGameFromLobbyAction(watcher));
        return watcher;
    }

    protected void createNetworkMenu(JMenuBar menuBar, InGameLobbyWatcherWrapper watcher) {
        if (this.getGame().getMessenger() instanceof DummyMessenger) {
            return;
        }
        JMenu menuNetwork = new JMenu("Network");
        menuNetwork.setMnemonic(78);
        this.addBootPlayer(menuNetwork);
        this.addBanPlayer(menuNetwork);
        this.addMutePlayer(menuNetwork);
        this.addSetGamePassword(menuNetwork, watcher);
        this.addShowPlayers(menuNetwork);
        menuBar.add(menuNetwork);
    }

    protected void addBootPlayer(JMenu parentMenu) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        BootPlayerAction boot = new BootPlayerAction(this, messenger);
        parentMenu.add(boot);
    }

    protected void addBanPlayer(JMenu parentMenu) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        BanPlayerAction ban = new BanPlayerAction(this, messenger);
        parentMenu.add(ban);
    }

    protected void addMutePlayer(JMenu parentMenu) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        MutePlayerAction mute = new MutePlayerAction(this, messenger);
        parentMenu.add(mute);
    }

    protected void addSetGamePassword(JMenu parentMenu, InGameLobbyWatcherWrapper watcher) {
        if (!this.getGame().getMessenger().isServer()) {
            return;
        }
        IServerMessenger messenger = (IServerMessenger)this.getGame().getMessenger();
        parentMenu.add(new SetPasswordAction(this, watcher, (ClientLoginValidator)messenger.getLoginValidator()));
    }

    protected void addShowPlayers(JMenu menuGame) {
        if (!this.getGame().getData().getProperties().getEditableProperties().isEmpty()) {
            AbstractAction optionsAction = new AbstractAction("Show Who is Who..."){
                private static final long serialVersionUID = 5687214685515140202L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlayersPanel.showPlayers(BasicGameMenuBar.this.getGame(), BasicGameMenuBar.this.m_frame);
                }
            };
            menuGame.add(optionsAction);
        }
    }

    protected void createHelpMenu(JMenuBar menuBar) {
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic(72);
        menuBar.add(helpMenu);
        this.addGameSpecificHelpMenus(helpMenu);
        this.addGameNotesMenu(helpMenu);
        this.addConsoleMenu(helpMenu);
        this.addAboutMenu(helpMenu);
    }

    private void createWebHelpMenu(JMenuBar menuBar) {
        JMenu web = new JMenu("Web");
        web.setMnemonic(87);
        menuBar.add(web);
        BasicGameMenuBar.addWebMenu(web);
    }

    private static void addWebMenu(JMenu parentMenu) {
        JMenuItem hostingLink = new JMenuItem("How to Host...");
        hostingLink.setMnemonic(72);
        JMenuItem mapLink = new JMenuItem("Install Maps...");
        mapLink.setMnemonic(73);
        JMenuItem bugReport = new JMenuItem("Bug Report...");
        bugReport.setMnemonic(66);
        JMenuItem lobbyRules = new JMenuItem("Lobby Rules...");
        lobbyRules.setMnemonic(76);
        JMenuItem warClub = new JMenuItem("War Club & Ladder...");
        warClub.setMnemonic(87);
        JMenuItem devForum = new JMenuItem("Developer Forum...");
        devForum.setMnemonic(69);
        JMenuItem donateLink = new JMenuItem("Donate...");
        donateLink.setMnemonic(79);
        JMenuItem guidesLink = new JMenuItem("Guides...");
        guidesLink.setMnemonic(71);
        hostingLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312.html");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        mapLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://tripleadev.1671093.n2.nabble.com/Download-Maps-Links-Hosting-Games-General-Information-tp4074312p4085700.html");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        bugReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("https://sourceforge.net/p/triplea/_list/tickets");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        lobbyRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://www.tripleawarclub.org/modules/newbb/viewtopic.php?topic_id=100&forum=1");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        warClub.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://www.tripleawarclub.org/");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        devForum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://triplea.sourceforge.net/mywiki/Forum");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        donateLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("https://sourceforge.net/donate/index.php?group_id=44492");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        guidesLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://triplea.sourceforge.net/mywiki/Guides");
                }
                catch (Exception e1) {
                    ClientLogger.logQuietly(e1);
                }
            }
        });
        parentMenu.add(hostingLink);
        parentMenu.add(mapLink);
        parentMenu.add(bugReport);
        parentMenu.add(lobbyRules);
        parentMenu.add(warClub);
        parentMenu.add(devForum);
        parentMenu.add(donateLink);
        parentMenu.add(guidesLink);
    }

    protected void addGameSpecificHelpMenus(JMenu helpMenu) {
    }

    protected void addConsoleMenu(JMenu parentMenu) {
        parentMenu.add(new AbstractAction("Show Console..."){
            private static final long serialVersionUID = 6303760092518795718L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Console.getConsole().setVisible(true);
                Console.getConsole().append(DebugUtils.getMemory());
            }
        }).setMnemonic(67);
    }

    protected void addAboutMenu(JMenu parentMenu) {
        String text = "<h2>" + this.getData().getGameName() + "</h2>" + "<p><b>Engine Version:</b> " + EngineVersion.VERSION.toString() + "<br><b>Game:</b> " + this.getData().getGameName() + "<br><b>Game Version:</b>" + this.getData().getGameVersion() + "</p>" + "<p>For more information please visit,<br><br>" + "<b><a hlink='http://triplea.sourceforge.net/'>http://triplea.sourceforge.net/</a></b><br><br>";
        final JEditorPane editorPane = new JEditorPane();
        editorPane.setBorder(null);
        editorPane.setBackground(this.getBackground());
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        editorPane.setText(text);
        JScrollPane scroll = new JScrollPane(editorPane);
        scroll.setBorder(null);
        if (System.getProperty("mrj.version") == null) {
            parentMenu.addSeparator();
            parentMenu.add(new AbstractAction("About..."){
                private static final long serialVersionUID = 2861657714227435945L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, editorPane, "About " + ((MainGameFrame)BasicGameMenuBar.this.m_frame).getGame().getData().getGameName(), -1);
                }
            }).setMnemonic(65);
        } else {
            Application.getApplication().addApplicationListener(new ApplicationAdapter(){

                @Override
                public void handleAbout(ApplicationEvent event) {
                    event.setHandled(true);
                    JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, editorPane, "About " + ((MainGameFrame)BasicGameMenuBar.this.m_frame).getGame().getData().getGameName(), -1);
                }
            });
        }
    }

    protected void createFileMenu(JMenuBar menuBar) {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        this.addSaveMenu(fileMenu);
        this.addPostPBEM(fileMenu);
        fileMenu.addSeparator();
        this.addExitMenu(fileMenu);
    }

    public static File getSaveGameLocationDialog(Frame frame) {
        int choice;
        if (GameRunner.isMac()) {
            FileDialog fileDialog = new FileDialog(frame);
            fileDialog.setMode(1);
            SaveGameFileChooser.ensureDefaultDirExists();
            fileDialog.setDirectory(SaveGameFileChooser.DEFAULT_DIRECTORY.getPath());
            fileDialog.setFilenameFilter(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".tsvg") || name.endsWith(".svg");
                }
            });
            fileDialog.setVisible(true);
            String fileName = fileDialog.getFile();
            String dirName = fileDialog.getDirectory();
            if (fileName == null) {
                return null;
            }
            if (!fileName.endsWith(".tsvg")) {
                fileName = fileName + ".tsvg";
            }
            File f = new File(dirName, fileName);
            return f;
        }
        SaveGameFileChooser fileChooser = SaveGameFileChooser.getInstance();
        int rVal = fileChooser.showSaveDialog(frame);
        if (rVal != 0) {
            return null;
        }
        File f = fileChooser.getSelectedFile();
        if (GameRunner.isWindows()) {
            int slashIndex = Math.min(f.getPath().lastIndexOf("\\"), f.getPath().length());
            String filePath = f.getPath().substring(0, slashIndex);
            if (!fileChooser.getCurrentDirectory().toString().equals(filePath)) {
                JOptionPane.showConfirmDialog(frame, "Sub directories are not allowed in the file name.  Please rename it.", "Cancel?", -1, 2);
                return null;
            }
        }
        if (!f.getName().toLowerCase().endsWith(".tsvg")) {
            f = new File(f.getParent(), f.getName() + ".tsvg");
        }
        if (f.exists() && (choice = JOptionPane.showConfirmDialog(frame, "A file by that name already exists. Do you wish to over write it?", "Over-write?", 0, 2)) != 0) {
            return null;
        }
        return f;
    }

    protected void addSaveMenu(JMenu parent) {
        JMenuItem menuFileSave = new JMenuItem(new AbstractAction("Save..."){
            private static final long serialVersionUID = -8835148465905355231L;

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = BasicGameMenuBar.getSaveGameLocationDialog(BasicGameMenuBar.this.m_frame);
                if (f != null) {
                    BasicGameMenuBar.this.getGame().saveGame(f);
                    JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, "Game Saved", "Game Saved", 1);
                }
            }
        });
        menuFileSave.setMnemonic(83);
        menuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        parent.add(menuFileSave);
    }

    protected void addPostPBEM(JMenu parent) {
        if (!PBEMMessagePoster.GameDataHasPlayByEmailOrForumMessengers(this.getGame().getData())) {
            return;
        }
        JMenuItem menuPBEM = new JMenuItem(new AbstractAction("Post PBEM/PBF Gamesave..."){
            private static final long serialVersionUID = 5197939183318847906L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                GameData data = BasicGameMenuBar.this.getGame().getData();
                if (data == null || !PBEMMessagePoster.GameDataHasPlayByEmailOrForumMessengers(data)) {
                    return;
                }
                String title = "Manual Gamesave Post";
                try {
                    data.acquireReadLock();
                    GameStep step = data.getSequence().getStep();
                    PlayerID currentPlayer = step == null ? PlayerID.NULL_PLAYERID : (step.getPlayerID() == null ? PlayerID.NULL_PLAYERID : step.getPlayerID());
                    int round = data.getSequence().getRound();
                    HistoryLog historyLog = new HistoryLog();
                    historyLog.printFullTurn(data, false, GameStepPropertiesHelper.getTurnSummaryPlayers(data));
                    PBEMMessagePoster poster = new PBEMMessagePoster(BasicGameMenuBar.this.getData(), currentPlayer, round, "Manual Gamesave Post");
                    PBEMMessagePoster.postTurn("Manual Gamesave Post", historyLog, true, poster, null, BasicGameMenuBar.this.m_frame, null);
                }
                finally {
                    data.releaseReadLock();
                }
            }
        });
        menuPBEM.setMnemonic(80);
        menuPBEM.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        parent.add(menuPBEM);
    }

    protected void addExitMenu(JMenu parentMenu) {
        boolean isMac = GameRunner.isMac();
        JMenuItem leaveGameMenuExit = new JMenuItem(new AbstractAction("Leave Game"){
            private static final long serialVersionUID = 5438496165424252930L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MainGameFrame)BasicGameMenuBar.this.m_frame).leaveGame();
            }
        });
        leaveGameMenuExit.setMnemonic(76);
        if (isMac) {
            leaveGameMenuExit.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        } else {
            leaveGameMenuExit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        parentMenu.add(leaveGameMenuExit);
        if (isMac) {
            MacWrapper.registerMacShutdownHandler(this.m_frame);
        } else {
            JMenuItem menuFileExit = new JMenuItem(new AbstractAction("Exit"){
                private static final long serialVersionUID = 2801394552918725137L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((MainGameFrame)BasicGameMenuBar.this.m_frame).shutdown();
                }
            });
            menuFileExit.setMnemonic(69);
            parentMenu.add(menuFileExit);
        }
    }

    protected static boolean isJavaGreatThan5() {
        String version = System.getProperties().getProperty("java.version");
        return version.indexOf("1.5") == -1;
    }

    protected static boolean isJavaGreatThan6() {
        String version = System.getProperties().getProperty("java.version");
        return version.indexOf("1.5") == -1 && version.indexOf("1.6") == -1;
    }

    public static List<String> getLookAndFeelAvailableList() {
        ArrayList<String> substanceLooks = new ArrayList<String>();
        for (UIManager.LookAndFeelInfo look : UIManager.getInstalledLookAndFeels()) {
            substanceLooks.add(look.getClassName());
        }
        if (!BasicGameMenuBar.isJavaGreatThan6()) {
            substanceLooks.remove("javax.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        if (BasicGameMenuBar.isJavaGreatThan5()) {
            substanceLooks.addAll(new ArrayList<String>(Arrays.asList("org.pushingpixels.substance.api.skin.SubstanceAutumnLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlackSteelLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceBusinessBlueSteelLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceBusinessLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceCeruleanLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceChallengerDeepLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceCremeCoffeeLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceCremeLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceDustCoffeeLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceDustLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceEmeraldDuskLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceGeminiLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceGraphiteAquaLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceGraphiteGlassLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceGraphiteLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceMagellanLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceMarinerLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceMistAquaLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceMistSilverLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceModerateLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceNebulaBrickWallLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceNebulaLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceOfficeBlack2007LookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceOfficeBlue2007LookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceOfficeSilver2007LookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceRavenLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceSaharaLookAndFeel", "org.pushingpixels.substance.api.skin.SubstanceTwilightLookAndFeel")));
        }
        return substanceLooks;
    }

    public static Triple<JList, Map<String, String>, String> getLookAndFeelList() {
        LinkedHashMap<String, String> lookAndFeels = new LinkedHashMap<String, String>();
        try {
            List<String> substanceLooks = BasicGameMenuBar.getLookAndFeelAvailableList();
            for (String s : substanceLooks) {
                Class<?> c = Class.forName(s);
                LookAndFeel lf = (LookAndFeel)c.newInstance();
                lookAndFeels.put(lf.getName(), s);
            }
        }
        catch (Exception t) {
            t.printStackTrace();
            lookAndFeels.clear();
            lookAndFeels.put("Original", UIManager.getSystemLookAndFeelClassName());
            lookAndFeels.put("Metal", MetalLookAndFeel.class.getName());
            lookAndFeels.put("Platform Independent", UIManager.getCrossPlatformLookAndFeelClassName());
        }
        JList list = new JList(new Vector(lookAndFeels.keySet()));
        String currentKey = null;
        for (String s : lookAndFeels.keySet()) {
            String currentName = UIManager.getLookAndFeel().getClass().getName();
            if (!((String)lookAndFeels.get(s)).equals(currentName)) continue;
            currentKey = s;
            break;
        }
        list.setSelectedValue(currentKey, false);
        return new Triple(list, lookAndFeels, currentKey);
    }

    protected void addSetLookAndFeel(JMenu menuView) {
        menuView.add(new AbstractAction("Set Look and Feel..."){
            private static final long serialVersionUID = 379919988820952164L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Triple<JList, Map<String, String>, String> lookAndFeel = BasicGameMenuBar.getLookAndFeelList();
                JList list = (JList)lookAndFeel.getFirst();
                String currentKey = lookAndFeel.getThird();
                Map lookAndFeels = (Map)lookAndFeel.getSecond();
                if (JOptionPane.showConfirmDialog(BasicGameMenuBar.this.m_frame, list) == 0) {
                    String selectedValue = (String)list.getSelectedValue();
                    if (selectedValue == null) {
                        return;
                    }
                    if (selectedValue.equals(currentKey)) {
                        return;
                    }
                    GameRunner2.setDefaultLookAndFeel((String)lookAndFeels.get(selectedValue));
                    EventThreadJOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, "The look and feel will update when you restart TripleA", new CountDownLatchHandler(true));
                }
            }
        }).setMnemonic(70);
    }

    protected void addShowGameUuid(JMenu menuView) {
        menuView.add(new AbstractAction("Game UUID..."){
            private static final long serialVersionUID = 119615303846107510L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String id = (String)BasicGameMenuBar.this.getData().getProperties().get("GAME_UUID");
                JTextField text = new JTextField();
                text.setText(id);
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.add((Component)new JLabel("Game UUID:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel.add((Component)text, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                JOptionPane.showOptionDialog(JOptionPane.getFrameForComponent(BasicGameMenuBar.this), panel, "Game UUID", 0, 1, null, new String[]{"OK"}, "OK");
            }
        }).setMnemonic(85);
    }

    protected void addChatTimeMenu(JMenu parentMenu) {
        final JCheckBoxMenuItem chatTimeBox = new JCheckBoxMenuItem("Show Chat Times");
        chatTimeBox.setMnemonic(84);
        chatTimeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((MainGameFrame)BasicGameMenuBar.this.m_frame).setShowChatTime(chatTimeBox.isSelected());
            }
        });
        chatTimeBox.setSelected(false);
        parentMenu.add(chatTimeBox);
        chatTimeBox.setEnabled(MainFrame.getInstance() != null && MainFrame.getInstance().getChat() != null);
    }

    protected void addAISleepDuration(JMenu parentMenu) {
        JMenuItem AISleepDurationBox = new JMenuItem("AI Pause Duration...");
        AISleepDurationBox.setMnemonic(65);
        AISleepDurationBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IntTextField text = new IntTextField(50, 10000);
                text.setText(String.valueOf(AbstractUIContext.getAIPauseDuration()));
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                panel.add((Component)new JLabel("AI Pause Duration (ms):"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                panel.add((Component)text, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
                JOptionPane.showOptionDialog(JOptionPane.getFrameForComponent(BasicGameMenuBar.this), panel, "Set AI Pause Duration", 0, 1, null, new String[]{"OK"}, "OK");
                try {
                    AbstractUIContext.setAIPauseDuration(Integer.parseInt(text.getText()));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        });
        parentMenu.add(AISleepDurationBox);
    }

    protected void addGameOptionsMenu(JMenu menuGame) {
        if (!this.getGame().getData().getProperties().getEditableProperties().isEmpty()) {
            AbstractAction optionsAction = new AbstractAction("View Game Options..."){
                private static final long serialVersionUID = 8937205081994328616L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesUI ui = new PropertiesUI(BasicGameMenuBar.this.getGame().getData().getProperties().getEditableProperties(), false);
                    JOptionPane.showMessageDialog(BasicGameMenuBar.this.m_frame, ui, "Game options", -1);
                }
            };
            menuGame.add(optionsAction).setMnemonic(79);
        }
    }

    protected void addExportXML(JMenu parentMenu) {
        AbstractAction exportXML = new AbstractAction("Export game.xml file (Beta)..."){
            private static final long serialVersionUID = 8379478036021948990L;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.exportXMLFile();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void exportXMLFile() {
                String xmlFile;
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                File rootDir = new File(System.getProperties().getProperty("user.dir"));
                SimpleDateFormat formatDate = new SimpleDateFormat("yyyy_MM_dd");
                int round = 0;
                try {
                    BasicGameMenuBar.this.getData().acquireReadLock();
                    round = BasicGameMenuBar.this.getData().getSequence().getRound();
                }
                finally {
                    BasicGameMenuBar.this.getData().releaseReadLock();
                }
                String defaultFileName = "xml_" + formatDate.format(new Date()) + "_" + BasicGameMenuBar.this.getData().getGameName() + "_round_" + round;
                defaultFileName = IllegalCharacterRemover.removeIllegalCharacter(defaultFileName);
                defaultFileName = defaultFileName + ".xml";
                chooser.setSelectedFile(new File(rootDir, defaultFileName));
                if (chooser.showSaveDialog((Component)BasicGameMenuBar.this.m_frame) != 0) {
                    return;
                }
                GameData data = BasicGameMenuBar.this.getData();
                try {
                    data.acquireReadLock();
                    GameDataExporter exporter = new GameDataExporter(data, false);
                    xmlFile = exporter.getXML();
                }
                finally {
                    data.releaseReadLock();
                }
                try {
                    FileWriter writer = new FileWriter(chooser.getSelectedFile());
                    try {
                        writer.write(xmlFile);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        };
        parentMenu.add(exportXML).setMnemonic(88);
    }

    public IGame getGame() {
        return ((MainGameFrame)this.m_frame).getGame();
    }

    public GameData getData() {
        return ((MainGameFrame)this.m_frame).getGame().getData();
    }
}

