/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.common.ui;

import games.strategy.engine.framework.IGame;
import games.strategy.engine.framework.startup.mc.GameSelectorModel;
import games.strategy.engine.framework.startup.ui.InGameLobbyWatcher;
import games.strategy.engine.lobby.server.GameDescription;

public class InGameLobbyWatcherWrapper {
    private volatile InGameLobbyWatcher m_lobbyWatcher = null;

    public void setInGameLobbyWatcher(InGameLobbyWatcher watcher) {
        this.m_lobbyWatcher = watcher;
    }

    public InGameLobbyWatcher getInGameLobbyWatcher() {
        return this.m_lobbyWatcher;
    }

    public void shutDown() {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.shutDown();
        }
    }

    public boolean isActive() {
        return this.m_lobbyWatcher != null && this.m_lobbyWatcher.isActive();
    }

    public String getComments() {
        return this.m_lobbyWatcher == null ? "" : this.m_lobbyWatcher.getComments();
    }

    public void setGame(IGame game) {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.setGame(game);
        }
    }

    public void setGameComments(String comments) {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.setGameComments(comments);
        }
    }

    public void setGameSelectorModel(GameSelectorModel model) {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.setGameSelectorModel(model);
        }
    }

    public void setGameStatus(GameDescription.GameStatus status, IGame game) {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.setGameStatus(status, game);
        }
    }

    public void setPassworded(boolean passworded) {
        if (this.m_lobbyWatcher != null) {
            this.m_lobbyWatcher.setPassworded(passworded);
        }
    }

    public GameDescription getGameDescription() {
        if (this.m_lobbyWatcher != null) {
            return this.m_lobbyWatcher.getGameDescription();
        }
        return null;
    }
}

