/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.debug;

import games.strategy.debug.DebugUtils;
import games.strategy.debug.SynchedByteArrayOutputStream;
import games.strategy.debug.ThreadReader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.PrintStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;

public class Console
extends JFrame {
    private static final long serialVersionUID = -3489030525309243438L;
    private static Console s_console;
    private final JTextArea m_text = new JTextArea(20, 50);
    private final JToolBar m_actions = new JToolBar(0);
    private final Action m_copyAction = new AbstractAction("Copy to clipboard"){
        private static final long serialVersionUID = 1573097546768015070L;

        @Override
        public void actionPerformed(ActionEvent e) {
            String text = Console.this.m_text.getText();
            StringSelection select = new StringSelection(text);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(select, select);
        }
    };
    private final AbstractAction m_threadDiagnoseAction = new AbstractAction("Enumerate Threads"){
        private static final long serialVersionUID = 4414139104815149199L;

        @Override
        public void actionPerformed(ActionEvent e) {
            System.out.println(DebugUtils.getThreadDumps());
        }
    };
    private final AbstractAction m_memoryAction = new AbstractAction("Memory"){
        private static final long serialVersionUID = 1053036985791697566L;

        @Override
        public void actionPerformed(ActionEvent e) {
            Console.this.append(DebugUtils.getMemory());
        }
    };
    private final AbstractAction m_propertiesAction = new AbstractAction("Properties"){
        private static final long serialVersionUID = -8186358504886470902L;

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = DebugUtils.getProperties();
            Console.this.append(s);
        }
    };

    public static Console getConsole() {
        if (s_console == null) {
            s_console = new Console();
        }
        return s_console;
    }

    public Console() {
        super("An error has occured!");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_text.setLineWrap(true);
        this.m_text.setWrapStyleWord(true);
        JScrollPane scroll = new JScrollPane(this.m_text);
        this.getContentPane().add((Component)scroll, "Center");
        this.getContentPane().add((Component)this.m_actions, "South");
        this.m_actions.setFloatable(false);
        this.m_actions.add(this.m_threadDiagnoseAction);
        this.m_actions.add(this.m_memoryAction);
        this.m_actions.add(this.m_propertiesAction);
        this.m_actions.add(this.m_copyAction);
        this.pack();
    }

    public void append(String s) {
        this.m_text.append(s);
    }

    public void dumpStacks() {
        this.m_threadDiagnoseAction.actionPerformed(null);
    }

    public String getText() {
        return this.m_text.getText();
    }

    public void displayStandardError() {
        SynchedByteArrayOutputStream out = new SynchedByteArrayOutputStream(System.err);
        ThreadReader reader = new ThreadReader(out, this.m_text, true);
        Thread thread = new Thread((Runnable)reader, "Console std err reader");
        thread.setDaemon(true);
        thread.start();
        PrintStream print = new PrintStream(out);
        System.setErr(print);
    }

    public void displayStandardOutput() {
        SynchedByteArrayOutputStream out = new SynchedByteArrayOutputStream(System.out);
        ThreadReader reader = new ThreadReader(out, this.m_text, false);
        Thread thread = new Thread((Runnable)reader, "Console std out reader");
        thread.setDaemon(true);
        thread.start();
        PrintStream print = new PrintStream(out);
        System.setOut(print);
    }
}

