/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.debug;

import games.strategy.debug.Console;
import games.strategy.engine.EngineVersion;
import games.strategy.engine.framework.GameRunner2;
import java.awt.Frame;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;

public class DebugUtils {
    private static final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();

    public static String getThreadDumps() {
        long[] deadlocks;
        ThreadInfo[] threadInfo;
        StringBuilder result = new StringBuilder();
        result.append("THREAD DUMP\n");
        for (ThreadInfo info : threadInfo = threadMxBean.getThreadInfo(threadMxBean.getAllThreadIds(), Integer.MAX_VALUE)) {
            StackTraceElement[] stackTrace;
            if (info == null) continue;
            result.append("thread<" + info.getThreadId() + "," + info.getThreadName() + ">\n").append("state:" + (Object)((Object)info.getThreadState())).append("\n");
            if (info.getLockName() != null) {
                result.append("locked on:" + info.getLockName()).append(" locked owned by:<" + info.getLockOwnerId() + "," + info.getLockOwnerName() + ">\n");
            }
            for (StackTraceElement element : stackTrace = info.getStackTrace()) {
                result.append("  ");
                result.append(element);
                result.append("\n");
            }
            result.append("\n");
        }
        try {
            Method m = threadMxBean.getClass().getMethod("findDeadlockedThreads", new Class[0]);
            Object o = m.invoke((Object)threadMxBean, new Object[0]);
            deadlocks = (long[])o;
        }
        catch (Throwable t) {
            deadlocks = threadMxBean.findMonitorDeadlockedThreads();
        }
        if (deadlocks != null) {
            result.append("DEADLOCKS!!");
            for (long l : deadlocks) {
                result.append(l).append("\n");
            }
        }
        return result.toString();
    }

    public static String getMemory() {
        System.gc();
        System.runFinalization();
        System.gc();
        int mb = 0x100000;
        StringBuilder buf = new StringBuilder("Heap utilization statistics [MB]\r\n");
        Runtime runtime = Runtime.getRuntime();
        buf.append("Used Memory: " + (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L + "\r\n");
        buf.append("Free memory: " + runtime.freeMemory() / 0x100000L + "\r\n");
        buf.append("Total memory: " + runtime.totalMemory() / 0x100000L + "\r\n");
        buf.append("Max memory: " + runtime.maxMemory() / 0x100000L + "\r\n");
        int currentMaxSetting = GameRunner2.getMaxMemoryFromSystemIniFileInMB(GameRunner2.getSystemIni());
        if (currentMaxSetting > 0) {
            buf.append("Max Memory user setting within 22% of: " + currentMaxSetting + "\r\n");
        }
        return buf.toString();
    }

    public static String getProperties() {
        StringBuilder buf = new StringBuilder("SYSTEM PROPERTIES\n");
        Properties props = System.getProperties();
        ArrayList<Object> keys = new ArrayList<Object>(props.keySet());
        Collections.sort(keys);
        for (String string : keys) {
            String value = props.getProperty(string);
            buf.append(string).append(" ").append(value).append("\n");
        }
        return buf.toString();
    }

    public static String getDebugReportHeadless() {
        StringBuilder result = new StringBuilder(500);
        result.append(DebugUtils.getThreadDumps());
        result.append(DebugUtils.getProperties());
        result.append(DebugUtils.getMemory());
        result.append("ENGINE VERSION: ").append(EngineVersion.VERSION).append("\n");
        return result.toString();
    }

    public static String getDebugReportWithFramesAndWindows() {
        StringBuilder result = new StringBuilder(500);
        result.append("CONSOLE_OUTPUT:\n");
        result.append(Console.getConsole().getText());
        result.append("\n");
        result.append(DebugUtils.getThreadDumps());
        result.append(DebugUtils.getProperties());
        result.append(DebugUtils.getMemory());
        result.append(DebugUtils.getOpenAppWindows());
        result.append("ENGINE VERSION: ").append(EngineVersion.VERSION).append("\n");
        return result.toString();
    }

    public static String getOpenAppWindows() {
        StringBuilder builder = new StringBuilder("WINDOWS\n");
        for (Frame f : Frame.getFrames()) {
            if (!f.isVisible()) continue;
            builder.append("window:").append("class " + f.getClass()).append(" size " + f.getSize()).append(" title " + f.getTitle()).append("\n");
        }
        return builder.toString();
    }
}

