/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.debug;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

class SynchedByteArrayOutputStream
extends ByteArrayOutputStream {
    private final Object lock = new Object();
    private final PrintStream m_mirror;

    SynchedByteArrayOutputStream(PrintStream mirror) {
        this.m_mirror = mirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte b) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.m_mirror.write(b);
            super.write(b);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            super.write(b, off, len);
            this.m_mirror.write(b, off, len);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFully() {
        Object object = this.lock;
        synchronized (object) {
            if (super.size() == 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            String s = this.toString();
            this.reset();
            return s;
        }
    }
}

