/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.debug;

import games.strategy.debug.ClientLogger;
import games.strategy.debug.Console;
import games.strategy.debug.SynchedByteArrayOutputStream;
import javax.swing.JTextArea;

class ThreadReader
implements Runnable {
    private static final int CONSOLE_UPDATE_INTERVAL_MS = 100;
    private final JTextArea m_text;
    private final SynchedByteArrayOutputStream m_in;
    private final boolean m_displayConsoleOnWrite;

    ThreadReader(SynchedByteArrayOutputStream in, JTextArea text, boolean displayConsoleOnWrite) {
        this.m_in = in;
        this.m_text = text;
        this.m_displayConsoleOnWrite = displayConsoleOnWrite;
    }

    @Override
    public void run() {
        while (true) {
            this.m_text.append(this.m_in.readFully());
            if (this.m_displayConsoleOnWrite && !Console.getConsole().isVisible()) {
                Console.getConsole().setVisible(true);
            }
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                ClientLogger.logQuietly(e);
                continue;
            }
            break;
        }
    }
}

