/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.Chat;
import games.strategy.engine.chat.IChatListener;
import games.strategy.engine.chat.IPlayerActionFactory;
import games.strategy.engine.chat.IStatusListener;
import games.strategy.engine.chat.PlayerChatRenderer;
import games.strategy.net.INode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ChatPlayerPanel
extends JPanel
implements IChatListener {
    private static final long serialVersionUID = -3153022965393962945L;
    private static final Icon s_ignoreIcon;
    private JList m_players;
    private DefaultListModel m_listModel;
    private Chat m_chat;
    private final Set<String> m_hiddenPlayers = new HashSet<String>();
    private final IStatusListener m_statusListener;
    private ListCellRenderer m_setCellRenderer = new DefaultListCellRenderer();
    private final List<IPlayerActionFactory> m_actionFactories = new ArrayList<IPlayerActionFactory>();

    public ChatPlayerPanel(Chat chat) {
        this.createComponents();
        this.layoutComponents();
        this.setupListeners();
        this.setWidgetActivation();
        this.m_statusListener = new IStatusListener(){

            @Override
            public void statusChanged(INode node, String newStatus) {
                ChatPlayerPanel.this.repaint();
            }
        };
        this.setChat(chat);
    }

    public void addHiddenPlayerName(String name) {
        this.m_hiddenPlayers.add(name);
    }

    public void shutDown() {
        if (this.m_chat != null) {
            this.m_chat.removeChatListener(this);
            this.m_chat.getStatusManager().removeStatusListener(this.m_statusListener);
        }
        this.m_chat = null;
        this.setVisible(false);
        this.removeAll();
    }

    public void setChat(Chat chat) {
        if (this.m_chat != null) {
            this.m_chat.removeChatListener(this);
            this.m_chat.getStatusManager().removeStatusListener(this.m_statusListener);
        }
        this.m_chat = chat;
        if (chat != null) {
            chat.addChatListener(this);
            this.m_chat.getStatusManager().addStatusListener(this.m_statusListener);
        } else {
            this.updatePlayerList(Collections.<INode>emptyList());
        }
        this.repaint();
    }

    private void setDynamicPreferredSize() {
        List<INode> onlinePlayers = this.m_chat.GetOnlinePlayers();
        int maxNameLength = 0;
        FontMetrics fontMetrics = this.getFontMetrics(UIManager.getFont("TextField.font"));
        for (INode iNode : onlinePlayers) {
            maxNameLength = Math.max(maxNameLength, fontMetrics.stringWidth(iNode.getName()));
        }
        int iconCounter = 0;
        if (this.m_setCellRenderer instanceof PlayerChatRenderer) {
            iconCounter = ((PlayerChatRenderer)this.m_setCellRenderer).getMaxIconCounter();
        }
        this.setPreferredSize(new Dimension(maxNameLength + 40 + iconCounter * 14, 80));
    }

    private void createComponents() {
        this.m_listModel = new DefaultListModel();
        this.m_players = new JList(this.m_listModel);
        this.m_players.setFocusable(false);
        this.m_players.setCellRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (ChatPlayerPanel.this.m_setCellRenderer == null) {
                    return new JLabel();
                }
                INode node = (INode)value;
                DefaultListCellRenderer renderer = ChatPlayerPanel.this.m_setCellRenderer instanceof PlayerChatRenderer ? (DefaultListCellRenderer)ChatPlayerPanel.this.m_setCellRenderer.getListCellRendererComponent(list, node, index, isSelected, cellHasFocus) : (DefaultListCellRenderer)ChatPlayerPanel.this.m_setCellRenderer.getListCellRendererComponent(list, ChatPlayerPanel.this.getDisplayString(node), index, isSelected, cellHasFocus);
                if (ChatPlayerPanel.this.m_chat.isIgnored(node)) {
                    renderer.setIcon(s_ignoreIcon);
                }
                return renderer;
            }
        });
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_players), "Center");
    }

    private void setupListeners() {
        this.m_players.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ChatPlayerPanel.this.mouseOnPlayersList(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ChatPlayerPanel.this.mouseOnPlayersList(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                ChatPlayerPanel.this.mouseOnPlayersList(e);
            }
        });
        this.m_actionFactories.add(new IPlayerActionFactory(){

            @Override
            public List<Action> mouseOnPlayer(final INode clickedOn) {
                if (clickedOn.equals(ChatPlayerPanel.this.m_chat.getLocalNode())) {
                    return Collections.emptyList();
                }
                final boolean isIgnored = ChatPlayerPanel.this.m_chat.isIgnored(clickedOn);
                AbstractAction ignore = new AbstractAction(isIgnored ? "Stop Ignoring" : "Ignore"){
                    private static final long serialVersionUID = 6877883646085664875L;

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ChatPlayerPanel.this.m_chat.setIgnored(clickedOn, !isIgnored);
                        ChatPlayerPanel.this.repaint();
                    }
                };
                AbstractAction slap = new AbstractAction("Slap " + clickedOn.getName()){
                    private static final long serialVersionUID = -5514772068903406263L;

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        ChatPlayerPanel.this.m_chat.sendSlap(clickedOn.getName());
                    }
                };
                return Arrays.asList(slap, ignore);
            }
        });
    }

    private void setWidgetActivation() {
    }

    public void setPlayerRenderer(ListCellRenderer renderer) {
        this.m_setCellRenderer = renderer;
        this.setDynamicPreferredSize();
    }

    private void mouseOnPlayersList(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            return;
        }
        int index = this.m_players.locationToIndex(e.getPoint());
        if (index == -1) {
            return;
        }
        INode player = (INode)this.m_listModel.get(index);
        JPopupMenu menu = new JPopupMenu();
        boolean hasActions = false;
        for (IPlayerActionFactory factory : this.m_actionFactories) {
            List<Action> actions = factory.mouseOnPlayer(player);
            if (actions == null || actions.isEmpty()) continue;
            if (hasActions) {
                menu.addSeparator();
            }
            hasActions = true;
            for (Action a : actions) {
                menu.add(a);
            }
        }
        if (hasActions) {
            menu.show(this.m_players, e.getX(), e.getY());
        }
    }

    @Override
    public synchronized void updatePlayerList(final Collection<INode> players) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ChatPlayerPanel.this.m_listModel.clear();
                for (INode name : players) {
                    if (ChatPlayerPanel.this.m_hiddenPlayers.contains(name.getName())) continue;
                    ChatPlayerPanel.this.m_listModel.addElement(name);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }

    @Override
    public void addMessageWithSound(String message, String from, boolean thirdperson, String sound) {
    }

    @Override
    public void addMessage(String message, String from, boolean thirdperson) {
    }

    private String getDisplayString(INode node) {
        if (this.m_chat == null) {
            return "";
        }
        String extra = "";
        String notes = this.m_chat.getNotesForNode(node);
        if (notes != null && notes.length() > 0) {
            extra = extra + notes;
        }
        String status = this.m_chat.getStatusManager().getStatus(node);
        StringBuilder statusSB = new StringBuilder("");
        if (status != null && status.length() > 0) {
            if (status.length() > 25) {
                status = status.substring(0, 25);
            }
            for (int i = 0; i < status.length(); ++i) {
                char c = status.charAt(i);
                if (c >= '\u0300' && c <= '\u036f') continue;
                statusSB.append(c);
            }
            extra = extra + " (" + statusSB.toString() + ")";
        }
        if (extra.length() == 0) {
            return node.getName();
        }
        return node.getName() + extra;
    }

    @Override
    public void addStatusMessage(String message) {
    }

    public void addActionFactory(IPlayerActionFactory actionFactory) {
        this.m_actionFactories.add(actionFactory);
    }

    public void remove(IPlayerActionFactory actionFactory) {
        this.m_actionFactories.remove(actionFactory);
    }

    static {
        BufferedImage img;
        URL ignore = ChatPlayerPanel.class.getResource("ignore.png");
        if (ignore == null) {
            throw new IllegalStateException("Could not find ignore icon");
        }
        try {
            img = ImageIO.read(ignore);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        s_ignoreIcon = new ImageIcon(img);
    }
}

