/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.CompositeIcon;
import games.strategy.engine.data.PlayerList;
import games.strategy.engine.data.PlayerManager;
import games.strategy.engine.framework.IGame;
import games.strategy.net.INode;
import games.strategy.triplea.ui.IUIContext;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class PlayerChatRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -8195565028281374498L;
    private final IGame m_game;
    private final IUIContext m_uiContext;
    int m_maxIconCounter = 0;
    HashMap<String, List<Icon>> m_iconMap = new HashMap();
    HashMap<String, Set<String>> m_playerMap = new HashMap();

    public PlayerChatRenderer(IGame game, IUIContext uiContext) {
        this.m_game = game;
        this.m_uiContext = uiContext;
        this.setIconMap();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        List<Icon> icons = this.m_iconMap.get(value.toString());
        if (icons != null) {
            super.getListCellRendererComponent((JList<?>)list, ((INode)value).getName(), index, isSelected, cellHasFocus);
            this.setHorizontalTextPosition(2);
            this.setIcon(new CompositeIcon(icons));
        } else {
            StringBuilder sb = new StringBuilder(((INode)value).getName());
            Set<String> players = this.m_playerMap.get(value.toString());
            if (players != null && !players.isEmpty()) {
                sb.append(" (");
                Iterator<String> iter = players.iterator();
                while (iter.hasNext()) {
                    sb.append(iter.next());
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append(")");
            }
            super.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, cellHasFocus);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIconMap() {
        PlayerList playerList;
        PlayerManager playerManager = this.m_game.getPlayerManager();
        this.m_game.getData().acquireReadLock();
        try {
            playerList = this.m_game.getData().getPlayerList();
        }
        finally {
            this.m_game.getData().releaseReadLock();
        }
        for (INode playerNode : new HashSet<INode>(playerManager.getPlayerMapping().values())) {
            Set<String> players = playerManager.getPlayedBy(playerNode);
            if (players.size() <= 0) continue;
            ArrayList<ImageIcon> icons = new ArrayList<ImageIcon>(players.size());
            for (String player : players) {
                if (this.m_uiContext == null || this.m_uiContext.getFlagImageFactory() == null) continue;
                icons.add(new ImageIcon(this.m_uiContext.getFlagImageFactory().getSmallFlag(playerList.getPlayerID(player))));
            }
            this.m_maxIconCounter = Math.max(this.m_maxIconCounter, icons.size());
            this.m_playerMap.put(playerNode.toString(), players);
            if (this.m_uiContext == null) {
                this.m_iconMap.put(playerNode.toString(), null);
                continue;
            }
            this.m_iconMap.put(playerNode.toString(), icons);
        }
    }

    public int getMaxIconCounter() {
        return this.m_maxIconCounter;
    }
}

