/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.chat;

import games.strategy.engine.chat.IStatusChannel;
import games.strategy.engine.chat.IStatusController;
import games.strategy.engine.message.MessageContext;
import games.strategy.net.IConnectionChangeListener;
import games.strategy.net.INode;
import games.strategy.net.IServerMessenger;
import games.strategy.net.Messengers;
import java.util.HashMap;
import java.util.Map;

public class StatusController
implements IStatusController {
    private final Object m_mutex = new Object();
    private final Map<INode, String> m_status = new HashMap<INode, String>();
    private final Messengers m_messengers;

    public StatusController(Messengers messengers) {
        this.m_messengers = messengers;
        ((IServerMessenger)this.m_messengers.getMessenger()).addConnectionChangeListener(new IConnectionChangeListener(){

            @Override
            public void connectionRemoved(INode to) {
                StatusController.this.connectionRemoved(to);
            }

            @Override
            public void connectionAdded(INode to) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionRemoved(INode to) {
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_status.remove(to);
        }
        IStatusChannel channel = (IStatusChannel)this.m_messengers.getChannelMessenger().getChannelBroadcastor(IStatusChannel.STATUS_CHANNEL);
        channel.statusChanged(to, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<INode, String> getAllStatus() {
        Object object = this.m_mutex;
        synchronized (object) {
            return new HashMap<INode, String>(this.m_status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(String newStatus) {
        INode node = MessageContext.getSender();
        Object object = this.m_mutex;
        synchronized (object) {
            this.m_status.put(node, newStatus);
        }
        IStatusChannel channel = (IStatusChannel)this.m_messengers.getChannelMessenger().getChannelBroadcastor(IStatusChannel.STATUS_CHANNEL);
        channel.statusChanged(node, newStatus);
    }
}

