/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RemoveAvailableTech;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.triplea.delegate.TechAdvance;

class AddAvailableTech
extends Change {
    private static final long serialVersionUID = 5664428883866434959L;
    private final TechAdvance m_tech;
    private final TechnologyFrontier m_frontier;
    private final PlayerID m_player;

    public AddAvailableTech(TechnologyFrontier front, TechAdvance tech, PlayerID player) {
        if (front == null) {
            throw new IllegalArgumentException("Null tech category");
        }
        if (tech == null) {
            throw new IllegalArgumentException("Null tech");
        }
        this.m_tech = tech;
        this.m_frontier = front;
        this.m_player = player;
    }

    @Override
    public void perform(GameData data) {
        TechnologyFrontier front = this.m_player.getTechnologyFrontierList().getTechnologyFrontier(this.m_frontier.getName());
        front.addAdvance(this.m_tech);
    }

    @Override
    public Change invert() {
        return new RemoveAvailableTech(this.m_frontier, this.m_tech, this.m_player);
    }
}

