/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.AttachmentPropertyReset;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.IAttachment;
import games.strategy.util.PropertyUtil;

class AttachmentPropertyResetUndo
extends Change {
    private static final long serialVersionUID = 5943939650116851332L;
    private final Attachable m_attachedTo;
    private final String m_attachmentName;
    private final Object m_newValue;
    private final String m_property;

    AttachmentPropertyResetUndo(Attachable attachTo, String attachmentName, Object newValue, String property) {
        this.m_attachmentName = attachmentName;
        this.m_attachedTo = attachTo;
        this.m_newValue = newValue;
        this.m_property = property;
    }

    public Attachable getAttachedTo() {
        return this.m_attachedTo;
    }

    public String getAttachmentName() {
        return this.m_attachmentName;
    }

    @Override
    public void perform(GameData data) {
        IAttachment attachment = this.m_attachedTo.getAttachment(this.m_attachmentName);
        PropertyUtil.set(this.m_property, this.m_newValue, attachment, false);
    }

    @Override
    public Change invert() {
        return new AttachmentPropertyReset(this.m_attachedTo, this.m_attachmentName, this.m_newValue, this.m_property);
    }

    public String toString() {
        return "AttachmentPropertyClearUndo attached to:" + this.m_attachedTo + " name:" + this.m_attachmentName + " new value:" + this.m_newValue;
    }
}

