/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.util.IntegerMap;
import games.strategy.util.Util;
import java.util.Collection;
import java.util.Set;

public class BombingUnitDamageChange
extends Change {
    private static final long serialVersionUID = -6425858423179501847L;
    private final IntegerMap<Unit> m_hits;
    private final IntegerMap<Unit> m_undoHits;

    private BombingUnitDamageChange(IntegerMap<Unit> hits, IntegerMap<Unit> undoHits) {
        this.m_hits = hits;
        this.m_undoHits = undoHits;
    }

    public Collection<Unit> getUnits() {
        return this.m_hits.keySet();
    }

    BombingUnitDamageChange(IntegerMap<Unit> hits) {
        for (Unit u : hits.keySet()) {
            if (u instanceof TripleAUnit) continue;
            throw new IllegalArgumentException("BombingUnitDamage can only apply to a TripleAUnit object");
        }
        this.m_hits = hits.copy();
        this.m_undoHits = new IntegerMap();
        for (Unit item : this.m_hits.keySet()) {
            this.m_undoHits.put(item, item.getHits());
        }
    }

    @Override
    protected void perform(GameData data) {
        for (Unit item : this.m_hits.keySet()) {
            ((TripleAUnit)item).setUnitDamage(this.m_hits.getInt(item));
        }
        Set<Unit> units = this.m_hits.keySet();
        for (Territory element : data.getMap().getTerritories()) {
            if (!Util.someIntersect(element.getUnits().getUnits(), units)) continue;
            element.notifyChanged();
        }
    }

    @Override
    public Change invert() {
        return new BombingUnitDamageChange(this.m_undoHits, this.m_hits);
    }
}

