/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.IAttachment;
import games.strategy.util.PropertyUtil;

public class ChangeAttachmentChange
extends Change {
    private static final long serialVersionUID = -6447264150952218283L;
    private final Attachable m_attachedTo;
    private final String m_attachmentName;
    private final Object m_newValue;
    private final Object m_oldValue;
    private final String m_property;
    private boolean m_clearFirst = false;

    public Attachable getAttachedTo() {
        return this.m_attachedTo;
    }

    public String getAttachmentName() {
        return this.m_attachmentName;
    }

    ChangeAttachmentChange(IAttachment attachment, Object newValue, String property) {
        if (attachment == null) {
            throw new IllegalArgumentException("No attachment, newValue:" + newValue + " property:" + property);
        }
        this.m_attachedTo = attachment.getAttachedTo();
        this.m_clearFirst = false;
        this.m_attachmentName = attachment.getName();
        this.m_oldValue = PropertyUtil.getPropertyFieldObject(property, attachment);
        this.m_newValue = newValue;
        this.m_property = property;
    }

    ChangeAttachmentChange(IAttachment attachment, Object newValue, String property, boolean getRaw, boolean resetFirst) {
        if (attachment == null) {
            throw new IllegalArgumentException("No attachment, newValue:" + newValue + " property:" + property);
        }
        this.m_attachedTo = attachment.getAttachedTo();
        this.m_clearFirst = resetFirst;
        this.m_attachmentName = attachment.getName();
        this.m_oldValue = PropertyUtil.getPropertyFieldObject(property, attachment);
        this.m_newValue = newValue;
        this.m_property = property;
    }

    public ChangeAttachmentChange(Attachable attachTo, String attachmentName, Object newValue, Object oldValue, String property, boolean resetFirst) {
        this.m_attachmentName = attachmentName;
        this.m_attachedTo = attachTo;
        this.m_newValue = newValue;
        this.m_oldValue = oldValue;
        this.m_property = property;
        this.m_clearFirst = resetFirst;
    }

    @Override
    public void perform(GameData data) {
        IAttachment attachment = this.m_attachedTo.getAttachment(this.m_attachmentName);
        PropertyUtil.set(this.m_property, this.m_newValue, attachment, this.m_clearFirst);
    }

    @Override
    public Change invert() {
        return new ChangeAttachmentChange(this.m_attachedTo, this.m_attachmentName, this.m_oldValue, this.m_newValue, this.m_property, this.m_clearFirst);
    }

    public String toString() {
        return "ChangAttachmentChange attached to:" + this.m_attachedTo + " name:" + this.m_attachmentName + " new value:" + this.m_newValue + " old value:" + this.m_oldValue;
    }
}

