/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Logger;

public class CompositeRouteFinder {
    private static final Logger s_logger = Logger.getLogger(CompositeRouteFinder.class.getName());
    private final GameMap m_map;
    private final HashMap<Match<Territory>, Integer> m_matches;

    public static Logger GetStaticLogger() {
        return s_logger;
    }

    public CompositeRouteFinder(GameMap map, HashMap<Match<Territory>, Integer> matches) {
        this.m_map = map;
        this.m_matches = matches;
        s_logger.finer("Initializing CompositeRouteFinderClass...");
    }

    private HashSet<Territory> ToHashSet(Collection<Territory> ters) {
        HashSet<Territory> result = new HashSet<Territory>();
        for (Territory ter : ters) {
            result.add(ter);
        }
        return result;
    }

    public Route findRoute(Territory start, Territory end) {
        HashSet<Territory> allMatchingTers = this.ToHashSet(Match.getMatches(this.m_map.getTerritories(), new CompositeMatchOr(this.m_matches.keySet())));
        HashMap<Territory, Integer> terScoreMap = this.CreateScoreMap(allMatchingTers, start);
        HashMap<Territory, Integer> routeScoreMap = new HashMap<Territory, Integer>();
        int bestRouteToEndScore = Integer.MAX_VALUE;
        HashMap<Territory, Territory> previous = new HashMap<Territory, Territory>();
        ArrayList<Territory> routeLeadersToProcess = new ArrayList<Territory>();
        for (Territory ter : this.m_map.getNeighbors(start, Matches.territoryIsInList(allMatchingTers))) {
            int routeScore = terScoreMap.get(start) + terScoreMap.get(ter);
            routeScoreMap.put(ter, routeScore);
            routeLeadersToProcess.add(ter);
            previous.put(ter, start);
        }
        while (routeLeadersToProcess.size() > 0) {
            ArrayList<Territory> newLeaders = new ArrayList<Territory>();
            for (Territory oldLeader : routeLeadersToProcess) {
                for (Territory ter : this.m_map.getNeighbors(oldLeader, Matches.territoryIsInList(allMatchingTers))) {
                    int routeScore = (Integer)routeScoreMap.get(oldLeader) + terScoreMap.get(ter);
                    if (routeLeadersToProcess.contains(ter) || ter.equals(start) || previous.containsKey(ter) && routeScore >= (Integer)routeScoreMap.get(ter) || bestRouteToEndScore <= routeScore) continue;
                    routeScoreMap.put(ter, routeScore);
                    newLeaders.add(ter);
                    previous.put(ter, oldLeader);
                    if (!ter.equals(end) || routeScore >= bestRouteToEndScore) continue;
                    bestRouteToEndScore = routeScore;
                }
            }
            routeLeadersToProcess = newLeaders;
        }
        if (bestRouteToEndScore == Integer.MAX_VALUE) {
            return null;
        }
        return this.AssembleRoute(start, end, previous);
    }

    private Route AssembleRoute(Territory start, Territory end, HashMap<Territory, Territory> previous) {
        ArrayList<Territory> routeTers = new ArrayList<Territory>();
        Territory curTer = end;
        while (previous.containsKey(curTer)) {
            routeTers.add(curTer);
            curTer = previous.get(curTer);
        }
        routeTers.add(start);
        Collections.reverse(routeTers);
        return new Route(routeTers);
    }

    private HashMap<Territory, Integer> CreateScoreMap(Collection<Territory> ters, Territory startTer) {
        HashMap<Territory, Integer> result = new HashMap<Territory, Integer>();
        for (Territory ter : this.m_map.getTerritories()) {
            result.put(ter, this.GetTerScore(ter));
        }
        return result;
    }

    private Integer GetTerScore(Territory ter) {
        int bestMatchingScore = Integer.MAX_VALUE;
        for (Match<Territory> match : this.m_matches.keySet()) {
            int score = this.m_matches.get(match);
            if (score >= bestMatchingScore || !match.match(ter)) continue;
            bestMatchingScore = score;
        }
        return bestMatchingScore;
    }
}

