/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.AllianceTracker;
import games.strategy.engine.data.BattleRecordsList;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.DelegateList;
import games.strategy.engine.data.GameMap;
import games.strategy.engine.data.GameSequence;
import games.strategy.engine.data.GameStep;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.PlayerList;
import games.strategy.engine.data.ProductionFrontierList;
import games.strategy.engine.data.ProductionRuleList;
import games.strategy.engine.data.RelationshipTracker;
import games.strategy.engine.data.RelationshipTypeList;
import games.strategy.engine.data.RepairFrontierList;
import games.strategy.engine.data.RepairRuleList;
import games.strategy.engine.data.ResourceList;
import games.strategy.engine.data.TechnologyFrontier;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.TerritoryEffect;
import games.strategy.engine.data.UnitHolder;
import games.strategy.engine.data.UnitTypeList;
import games.strategy.engine.data.UnitsList;
import games.strategy.engine.data.events.GameDataChangeListener;
import games.strategy.engine.data.events.GameMapListener;
import games.strategy.engine.data.events.TerritoryListener;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.framework.IGameLoader;
import games.strategy.engine.framework.message.PlayerListing;
import games.strategy.engine.history.History;
import games.strategy.thread.LockUtil;
import games.strategy.triplea.ResourceLoader;
import games.strategy.util.ListenerList;
import games.strategy.util.Tuple;
import games.strategy.util.Version;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GameData
implements Serializable {
    private static final long serialVersionUID = -2612710634080125728L;
    public static final String GAME_UUID = "GAME_UUID";
    private final ReadWriteLock m_readWriteLock = new ReentrantReadWriteLock();
    private transient LockUtil m_lockUtil = new LockUtil();
    private volatile transient boolean m_forceInSwingEventThread = false;
    private String m_gameName;
    private Version m_gameVersion;
    private int m_diceSides;
    private transient ListenerList<TerritoryListener> m_territoryListeners = new ListenerList();
    private transient ListenerList<GameDataChangeListener> m_dataChangeListeners = new ListenerList();
    private transient ListenerList<GameMapListener> m_gameMapListeners = new ListenerList();
    private final AllianceTracker m_alliances = new AllianceTracker(this);
    private final RelationshipTracker m_relationships = new RelationshipTracker(this);
    private final DelegateList m_delegateList;
    private final GameMap m_map = new GameMap(this);
    private final PlayerList m_playerList = new PlayerList(this);
    private final ProductionFrontierList m_productionFrontierList = new ProductionFrontierList(this);
    private final ProductionRuleList m_productionRuleList = new ProductionRuleList(this);
    private final RepairFrontierList m_repairFrontierList = new RepairFrontierList(this);
    private final RepairRuleList m_repairRuleList = new RepairRuleList(this);
    private final ResourceList m_resourceList = new ResourceList(this);
    private final GameSequence m_sequence = new GameSequence(this);
    private final UnitTypeList m_unitTypeList = new UnitTypeList(this);
    private final RelationshipTypeList m_relationshipTypeList = new RelationshipTypeList(this);
    private final GameProperties m_properties = new GameProperties(this);
    private final UnitsList m_unitsList = new UnitsList();
    private final TechnologyFrontier m_technologyFrontier = new TechnologyFrontier("allTechsForGame", this);
    private transient ResourceLoader m_resourceLoader;
    private IGameLoader m_loader;
    private final History m_gameHistory = new History(this);
    private volatile transient boolean m_testLockIsHeld = false;
    private final List<Tuple<IAttachment, ArrayList<Tuple<String, String>>>> m_attachmentOrderAndValues = new ArrayList<Tuple<IAttachment, ArrayList<Tuple<String, String>>>>();
    private final Hashtable<String, TerritoryEffect> m_territoryEffectList = new Hashtable();
    private final BattleRecordsList m_battleRecordsList = new BattleRecordsList(this);

    public GameData() {
        this.m_delegateList = new DelegateList(this);
        this.m_properties.set(GAME_UUID, UUID.randomUUID().toString());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_lockUtil = new LockUtil();
    }

    public GameMap getMap() {
        return this.m_map;
    }

    private void ensureLockHeld() {
        if (!this.m_testLockIsHeld) {
            return;
        }
        if (this.m_readWriteLock == null) {
            return;
        }
        if (!this.m_lockUtil.isLockHeld(this.m_readWriteLock.readLock()) && !this.m_lockUtil.isLockHeld(this.m_readWriteLock.writeLock())) {
            new Exception("Lock not held").printStackTrace(System.out);
        }
    }

    public UnitsList getUnits() {
        return this.m_unitsList;
    }

    public PlayerList getPlayerList() {
        return this.m_playerList;
    }

    public ResourceList getResourceList() {
        this.ensureLockHeld();
        return this.m_resourceList;
    }

    public ProductionFrontierList getProductionFrontierList() {
        this.ensureLockHeld();
        return this.m_productionFrontierList;
    }

    public ProductionRuleList getProductionRuleList() {
        this.ensureLockHeld();
        return this.m_productionRuleList;
    }

    public TechnologyFrontier getTechnologyFrontier() {
        this.ensureLockHeld();
        return this.m_technologyFrontier;
    }

    public RepairFrontierList getRepairFrontierList() {
        this.ensureLockHeld();
        return this.m_repairFrontierList;
    }

    public RepairRuleList getRepairRuleList() {
        this.ensureLockHeld();
        return this.m_repairRuleList;
    }

    public AllianceTracker getAllianceTracker() {
        this.ensureLockHeld();
        return this.m_alliances;
    }

    public boolean areChangesOnlyInSwingEventThread() {
        return this.m_forceInSwingEventThread;
    }

    public void forceChangesOnlyInSwingEventThread() {
        this.m_forceInSwingEventThread = true;
    }

    public GameSequence getSequence() {
        this.ensureLockHeld();
        return this.m_sequence;
    }

    public UnitTypeList getUnitTypeList() {
        this.ensureLockHeld();
        return this.m_unitTypeList;
    }

    public DelegateList getDelegateList() {
        this.ensureLockHeld();
        return this.m_delegateList;
    }

    public UnitHolder getUnitHolder(String name, String type) {
        this.ensureLockHeld();
        if (type.equals("P")) {
            return this.m_playerList.getPlayerID(name);
        }
        if (type.equals("T")) {
            return this.m_map.getTerritory(name);
        }
        throw new IllegalStateException("Invalid type:" + type);
    }

    public GameProperties getProperties() {
        return this.m_properties;
    }

    public void addTerritoryListener(TerritoryListener listener) {
        this.m_territoryListeners.add(listener);
    }

    public void removeTerritoryListener(TerritoryListener listener) {
        this.m_territoryListeners.remove(listener);
    }

    public void addDataChangeListener(GameDataChangeListener listener) {
        this.m_dataChangeListeners.add(listener);
    }

    public void removeDataChangeListener(GameDataChangeListener listener) {
        this.m_dataChangeListeners.remove(listener);
    }

    public void addGameMapListener(GameMapListener listener) {
        this.m_gameMapListeners.add(listener);
    }

    public void removeGameMapListener(GameMapListener listener) {
        this.m_gameMapListeners.remove(listener);
    }

    void notifyTerritoryUnitsChanged(Territory t) {
        for (TerritoryListener listener : this.m_territoryListeners) {
            listener.unitsChanged(t);
        }
    }

    void notifyTerritoryAttachmentChanged(Territory t) {
        for (TerritoryListener listener : this.m_territoryListeners) {
            listener.attachmentChanged(t);
        }
    }

    void notifyTerritoryOwnerChanged(Territory t) {
        for (TerritoryListener listener : this.m_territoryListeners) {
            listener.ownerChanged(t);
        }
    }

    void notifyGameDataChanged(Change aChange) {
        for (GameDataChangeListener listener : this.m_dataChangeListeners) {
            listener.gameDataChanged(aChange);
        }
    }

    void notifyMapDataChanged() {
        for (GameMapListener listener : this.m_gameMapListeners) {
            listener.gameMapDataChanged();
        }
    }

    public IGameLoader getGameLoader() {
        return this.m_loader;
    }

    void setGameLoader(IGameLoader loader) {
        this.m_loader = loader;
    }

    void setGameVersion(Version version) {
        this.m_gameVersion = version;
    }

    public Version getGameVersion() {
        return this.m_gameVersion;
    }

    void setGameName(String gameName) {
        this.m_gameName = gameName;
    }

    public String getGameName() {
        return this.m_gameName;
    }

    void setDiceSides(int diceSides) {
        this.m_diceSides = diceSides > 0 && diceSides <= 200 ? diceSides : 6;
    }

    public int getDiceSides() {
        return this.m_diceSides;
    }

    public History getHistory() {
        return this.m_gameHistory;
    }

    public void postDeSerialize() {
        this.m_territoryListeners = new ListenerList();
        this.m_dataChangeListeners = new ListenerList();
        this.m_gameMapListeners = new ListenerList();
    }

    public void acquireReadLock() {
        if (this.m_readWriteLock == null) {
            return;
        }
        this.m_lockUtil.acquireLock(this.m_readWriteLock.readLock());
    }

    public void releaseReadLock() {
        if (this.m_readWriteLock == null) {
            return;
        }
        this.m_lockUtil.releaseLock(this.m_readWriteLock.readLock());
    }

    public void acquireWriteLock() {
        if (this.m_readWriteLock == null) {
            return;
        }
        this.m_lockUtil.acquireLock(this.m_readWriteLock.writeLock());
    }

    public void releaseWriteLock() {
        if (this.m_readWriteLock == null) {
            return;
        }
        this.m_lockUtil.releaseLock(this.m_readWriteLock.writeLock());
    }

    public void clearAllListeners() {
        this.m_dataChangeListeners.clear();
        this.m_territoryListeners.clear();
        this.m_gameMapListeners.clear();
        if (this.m_resourceLoader != null) {
            this.m_resourceLoader.close();
            this.m_resourceLoader = null;
        }
    }

    public void testLocksOnRead() {
        this.m_testLockIsHeld = true;
    }

    private ResourceLoader getResourceLoader() {
        if (this.m_resourceLoader != null) {
            return this.m_resourceLoader;
        }
        String mapName = (String)this.getProperties().get("mapName");
        if (mapName == null || mapName.trim().length() == 0) {
            mapName = this.m_gameName;
        }
        this.m_resourceLoader = ResourceLoader.getMapResourceLoader(mapName, false);
        if (this.m_resourceLoader == null) {
            throw new IllegalStateException("Map name property not set on game");
        }
        return this.m_resourceLoader;
    }

    public void addToAttachmentOrderAndValues(Tuple<IAttachment, ArrayList<Tuple<String, String>>> attachmentAndValues) {
        this.m_attachmentOrderAndValues.add(attachmentAndValues);
    }

    public List<Tuple<IAttachment, ArrayList<Tuple<String, String>>>> getAttachmentOrderAndValues() {
        return this.m_attachmentOrderAndValues;
    }

    public RelationshipTypeList getRelationshipTypeList() {
        this.ensureLockHeld();
        return this.m_relationshipTypeList;
    }

    public RelationshipTracker getRelationshipTracker() {
        this.ensureLockHeld();
        return this.m_relationships;
    }

    public Hashtable<String, TerritoryEffect> getTerritoryEffectList() {
        return this.m_territoryEffectList;
    }

    public BattleRecordsList getBattleRecordsList() {
        return this.m_battleRecordsList;
    }

    public void doPreGameStartDataModifications(PlayerListing playerListing) {
        HashSet<PlayerID> playersWhoShouldBeRemoved = new HashSet<PlayerID>();
        for (PlayerID p : this.m_playerList.getPlayers()) {
            if (!p.getCanBeDisabled() || playerListing.getPlayersEnabledListing().get(p.getName()).booleanValue()) continue;
            p.setIsDisabled(true);
            playersWhoShouldBeRemoved.add(p);
        }
        if (!playersWhoShouldBeRemoved.isEmpty()) {
            int currentIndex = this.m_sequence.getStepIndex();
            int index = 0;
            int toSubtract = 0;
            Iterator<GameStep> stepIter = this.m_sequence.iterator();
            while (stepIter.hasNext()) {
                GameStep step = stepIter.next();
                if (playersWhoShouldBeRemoved.contains(step.getPlayerID())) {
                    stepIter.remove();
                    if (index < currentIndex) {
                        ++toSubtract;
                    }
                }
                ++index;
            }
            this.m_sequence.setStepIndex(Math.max(0, Math.min(this.m_sequence.size() - 1, currentIndex - toSubtract)));
        }
    }
}

