/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.CompositeRouteFinder;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Route;
import games.strategy.engine.data.RouteFinder;
import games.strategy.engine.data.Territory;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchOr;
import games.strategy.util.IntegerMap;
import games.strategy.util.Match;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GameMap
extends GameDataComponent
implements Iterable<Territory> {
    private static final long serialVersionUID = -4606700588396439283L;
    private final List<Territory> m_territories = new ArrayList<Territory>();
    private final Map<Territory, Set<Territory>> m_connections = new HashMap<Territory, Set<Territory>>();
    private final Map<String, Territory> m_territoryLookup = new HashMap<String, Territory>();
    private int[] m_gridDimensions = null;
    private static Comparator<Territory> TERRITORY_GRID_ORDERING = new Comparator<Territory>(){

        @Override
        public int compare(Territory t1, Territory t2) {
            String name2;
            if (t1 == null && t2 == null || t1 == t2) {
                return 0;
            }
            if (t1 == null && t2 != null) {
                return 1;
            }
            if (t1 != null && t2 == null) {
                return -1;
            }
            if (t1.equals(t2)) {
                return 0;
            }
            int t1index = t1.getName().indexOf("_");
            int t2index = t2.getName().indexOf("_");
            if (t1index == -1 && t2index == -1) {
                return 0;
            }
            if (t1index == -1 && t2index != -1) {
                return 1;
            }
            if (t1index != -1 && t2index == -1) {
                return -1;
            }
            String name1 = t1.getName().substring(0, t1index);
            if (!name1.equals(name2 = t1.getName().substring(0, t2index))) {
                return name1.compareTo(name2);
            }
            String tname1y = t1.getName().replaceFirst(name1 + "_", "");
            tname1y = tname1y.substring(tname1y.indexOf("_") + 1, tname1y.length());
            int ty1 = Integer.parseInt(tname1y);
            String tname2y = t2.getName().replaceFirst(name2 + "_", "");
            int ty2 = Integer.parseInt(tname2y = tname2y.substring(tname2y.indexOf("_") + 1, tname2y.length()));
            if (ty1 < ty2) {
                return -1;
            }
            if (ty1 > ty2) {
                return 1;
            }
            String tname1x = t1.getName().replaceFirst(name1 + "_", "");
            tname1x = tname1x.substring(0, tname1x.indexOf("_"));
            int tx1 = Integer.parseInt(tname1x);
            String tname2x = t2.getName().replaceFirst(name2 + "_", "");
            int tx2 = Integer.parseInt(tname2x = tname2x.substring(0, tname2x.indexOf("_")));
            if (tx1 < tx2) {
                return -1;
            }
            if (tx1 > tx2) {
                return 1;
            }
            return 0;
        }
    };

    GameMap(GameData data) {
        super(data);
    }

    public void setGridDimensions(int ... gridDimensions) {
        this.m_gridDimensions = gridDimensions;
    }

    public int getXDimension() {
        if (this.m_gridDimensions == null || this.m_gridDimensions.length < 1) {
            return 0;
        }
        return this.m_gridDimensions[0];
    }

    public int getYDimension() {
        if (this.m_gridDimensions == null || this.m_gridDimensions.length < 2) {
            return 0;
        }
        return this.m_gridDimensions[1];
    }

    public Territory getTerritoryFromCoordinates(int ... coordinate) {
        return this.getTerritoryFromCoordinates(true, coordinate);
    }

    public Territory getTerritoryFromCoordinates(boolean allowNull, int ... coordinate) {
        if (this.m_gridDimensions == null) {
            if (allowNull) {
                return null;
            }
            throw new IllegalStateException("No Grid Dimensions");
        }
        if (!this.isCoordinateValid(coordinate)) {
            if (allowNull) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < coordinate.length; ++i) {
                sb.append(coordinate[i] + "");
                if (i + 1 >= coordinate.length) continue;
                sb.append(", ");
            }
            throw new IllegalStateException("No Territory at coordinates: " + sb.toString());
        }
        int listIndex = coordinate[0];
        int multiplier = 1;
        for (int i = 1; i < this.m_gridDimensions.length; ++i) {
            listIndex += coordinate[i] * (multiplier *= this.m_gridDimensions[i - 1]);
        }
        return (Territory)((ArrayList)this.m_territories).get(listIndex);
    }

    protected void reorderTerritoryList() {
        Collections.sort(this.m_territories, TERRITORY_GRID_ORDERING);
    }

    public boolean isCoordinateValid(int ... coordinate) {
        if (coordinate.length != this.m_gridDimensions.length) {
            return false;
        }
        for (int i = 0; i < this.m_gridDimensions.length; ++i) {
            if (coordinate[i] < this.m_gridDimensions[i] && coordinate[i] >= 0) continue;
            return false;
        }
        return true;
    }

    protected void addTerritory(Territory t1) {
        if (this.m_territories.contains(t1)) {
            throw new IllegalArgumentException("Map already contains " + t1.getName());
        }
        this.m_territories.add(t1);
        this.m_connections.put(t1, Collections.emptySet());
        this.m_territoryLookup.put(t1.getName(), t1);
    }

    protected void removeTerritory(Territory t1) {
        if (!this.m_territories.contains(t1)) {
            throw new IllegalArgumentException("Map does not contain " + t1.getName());
        }
        this.m_territories.remove(t1);
        this.m_connections.remove(t1);
        this.m_territoryLookup.remove(t1.getName());
        HashMap<Territory, HashSet<Territory>> tempConnections = new HashMap<Territory, HashSet<Territory>>();
        for (Map.Entry<Territory, Set<Territory>> entry : this.m_connections.entrySet()) {
            if (!entry.getValue().contains(t1)) continue;
            Set<Territory> current = entry.getValue();
            HashSet<Territory> modified = new HashSet<Territory>(current);
            modified.remove(t1);
            tempConnections.put(entry.getKey(), modified);
        }
        for (Map.Entry<Territory, Set<Territory>> entry : tempConnections.entrySet()) {
            this.m_connections.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
    }

    protected void addConnection(Territory t1, Territory t2) {
        if (t1.equals(t2)) {
            throw new IllegalArgumentException("Cannot connect a territory to itself");
        }
        if (!this.m_territories.contains(t1) || !this.m_territories.contains(t2)) {
            throw new IllegalArgumentException("Map doesnt know about one of " + t1 + " " + t2);
        }
        this.setConnection(t1, t2);
        this.setConnection(t2, t1);
    }

    protected void addOneWayConnection(Territory t1, Territory t2) {
        if (t1.equals(t2)) {
            throw new IllegalArgumentException("Cannot connect a territory to itself");
        }
        if (!this.m_territories.contains(t1) || !this.m_territories.contains(t2)) {
            throw new IllegalArgumentException("Map doesnt know about one of " + t1 + " " + t2);
        }
        this.setConnection(t1, t2);
    }

    private void setConnection(Territory from, Territory to) {
        Set<Territory> current = this.m_connections.get(from);
        HashSet<Territory> modified = new HashSet<Territory>(current);
        modified.add(to);
        this.m_connections.put(from, Collections.unmodifiableSet(modified));
    }

    public Territory getTerritory(String s) {
        return this.m_territoryLookup.get(s);
    }

    public Set<Territory> getNeighbors(Territory t) {
        Set<Territory> neighbors = this.m_connections.get(t);
        if (neighbors == null) {
            throw new IllegalArgumentException("No neighbors for:" + t);
        }
        return neighbors;
    }

    public Set<Territory> getNeighbors(Territory t, Match<Territory> cond) {
        if (cond == null) {
            return this.getNeighbors(t);
        }
        Set<Territory> possible = this.m_connections.get(t);
        HashSet<Territory> passed = new HashSet<Territory>();
        if (possible == null) {
            return passed;
        }
        for (Territory current : possible) {
            if (!cond.match(current)) continue;
            passed.add(current);
        }
        return passed;
    }

    public Set<Territory> getNeighbors(Territory territory, int distance) {
        if (distance < 0) {
            throw new IllegalArgumentException("Distance must be positive not:" + distance);
        }
        if (distance == 0) {
            return Collections.EMPTY_SET;
        }
        Set<Territory> start = this.getNeighbors(territory);
        if (distance == 1) {
            return start;
        }
        Set<Territory> neighbors = this.getNeighbors(start, new HashSet<Territory>(start), --distance);
        neighbors.remove(territory);
        return neighbors;
    }

    public Set<Territory> getNeighbors(Territory territory, int distance, Match<Territory> cond) {
        if (distance < 0) {
            throw new IllegalArgumentException("Distance must be positive not:" + distance);
        }
        if (distance == 0) {
            return Collections.EMPTY_SET;
        }
        Set<Territory> start = this.getNeighbors(territory, cond);
        if (distance == 1) {
            return start;
        }
        Set<Territory> neighbors = this.getNeighbors(start, new HashSet<Territory>(start), --distance, cond);
        neighbors.remove(territory);
        return neighbors;
    }

    public Set<Territory> getNeighbors(Set<Territory> frontier, int distance, Match<Territory> cond) {
        Set<Territory> rVal = this.getNeighbors(frontier, new HashSet<Territory>(frontier), distance, cond);
        rVal.removeAll(frontier);
        return rVal;
    }

    public Set<Territory> getNeighbors(Set<Territory> frontier, int distance) {
        Set<Territory> rVal = this.getNeighbors(frontier, new HashSet<Territory>(frontier), distance);
        rVal.removeAll(frontier);
        return rVal;
    }

    private Set<Territory> getNeighbors(Set<Territory> frontier, Set<Territory> searched, int distance, Match<Territory> cond) {
        if (distance == 0) {
            return searched;
        }
        Iterator<Territory> iter = frontier.iterator();
        HashSet<Territory> newFrontier = new HashSet<Territory>();
        while (iter.hasNext()) {
            Territory t = iter.next();
            newFrontier.addAll(this.getNeighbors(t, cond));
        }
        newFrontier.removeAll(searched);
        searched.addAll(newFrontier);
        return this.getNeighbors(newFrontier, searched, --distance, cond);
    }

    private Set<Territory> getNeighbors(Set<Territory> frontier, Set<Territory> searched, int distance) {
        if (distance == 0) {
            return searched;
        }
        Iterator<Territory> iter = frontier.iterator();
        HashSet<Territory> newFrontier = new HashSet<Territory>();
        while (iter.hasNext()) {
            Territory t = iter.next();
            newFrontier.addAll(this.getNeighbors(t));
        }
        newFrontier.removeAll(searched);
        searched.addAll(newFrontier);
        return this.getNeighbors(newFrontier, searched, --distance);
    }

    public Route getRoute(Territory t1, Territory t2) {
        return this.getRoute(t1, t2, Matches.TerritoryIsLandOrWater);
    }

    public Route getLandRoute(Territory t1, Territory t2) {
        return this.getRoute(t1, t2, Matches.TerritoryIsLand);
    }

    public Route getWaterRoute(Territory t1, Territory t2) {
        return this.getRoute(t1, t2, Matches.TerritoryIsWater);
    }

    public Route getRoute(Territory t1, Territory t2, Match<Territory> cond) {
        if (t1 == t2) {
            return new Route(t1, new Territory[0]);
        }
        if (this.getNeighbors(t1, cond).contains(t2)) {
            return new Route(t1, t2);
        }
        RouteFinder engine = new RouteFinder(this, cond);
        return engine.findRoute(t1, t2);
    }

    public Route getRoute_IgnoreEnd(Territory t1, Territory t2, Match<Territory> match) {
        return this.getRoute(t1, t2, new CompositeMatchOr<Territory>(Matches.territoryIs(t2), match));
    }

    public Route getCompositeRoute(Territory t1, Territory t2, HashMap<Match<Territory>, Integer> matches) {
        if (t1 == t2) {
            return new Route(t1, new Territory[0]);
        }
        CompositeMatchOr<Territory> allCond = new CompositeMatchOr<Territory>(matches.keySet());
        if (this.getNeighbors(t1, allCond).contains(t2)) {
            return new Route(t1, t2);
        }
        CompositeRouteFinder engine = new CompositeRouteFinder(this, matches);
        return engine.findRoute(t1, t2);
    }

    public Route getCompositeRoute_IgnoreEnd(Territory t1, Territory t2, HashMap<Match<Territory>, Integer> matches) {
        matches.put(Matches.territoryIs(t2), 0);
        return this.getCompositeRoute(t1, t2, matches);
    }

    public int getDistance(Territory t1, Territory t2) {
        return this.getDistance(t1, t2, Matches.TerritoryIsLandOrWater);
    }

    public int getLandDistance(Territory t1, Territory t2) {
        return this.getDistance(t1, t2, Matches.TerritoryIsLand);
    }

    public int getWaterDistance(Territory t1, Territory t2) {
        return this.getDistance(t1, t2, Matches.TerritoryIsWater);
    }

    public int getDistance(Territory t1, Territory t2, Match<Territory> cond) {
        if (t1.equals(t2)) {
            return 0;
        }
        HashSet<Territory> frontier = new HashSet<Territory>();
        frontier.add(t1);
        return this.getDistance(0, new HashSet<Territory>(), frontier, t2, cond);
    }

    public int getDistance_IgnoreEndForCondition(Territory t1, Territory t2, Match<Territory> cond) {
        return this.getDistance(t1, t2, new CompositeMatchOr<Territory>(Matches.territoryIs(t2), cond));
    }

    private int getDistance(int distance, Set<Territory> searched, Set<Territory> frontier, Territory target, Match<Territory> cond) {
        searched.addAll(frontier);
        HashSet<Territory> newFrontier = new HashSet<Territory>();
        for (Territory onFrontier : frontier) {
            Set<Territory> connections = this.m_connections.get(onFrontier);
            for (Territory nextFrontier : connections) {
                if (cond != null && !cond.match(nextFrontier)) continue;
                newFrontier.add(nextFrontier);
            }
        }
        if (newFrontier.contains(target)) {
            return distance + 1;
        }
        newFrontier.removeAll(searched);
        if (newFrontier.isEmpty()) {
            return -1;
        }
        return this.getDistance(distance + 1, searched, newFrontier, target, cond);
    }

    public IntegerMap<Territory> getDistance(Territory target, Collection<Territory> territories, Match<Territory> condition) {
        IntegerMap<Territory> rVal = new IntegerMap<Territory>();
        if (target == null || territories == null || territories.isEmpty()) {
            return rVal;
        }
        for (Territory t : territories) {
            rVal.put(t, this.getDistance(target, t, condition));
        }
        return rVal;
    }

    public List<Territory> getTerritories() {
        return Collections.unmodifiableList(this.m_territories);
    }

    @Override
    public Iterator<Territory> iterator() {
        return this.m_territories.iterator();
    }

    public List<Territory> getTerritoriesOwnedBy(PlayerID player) {
        Iterator<Territory> iter = this.m_territories.iterator();
        ArrayList<Territory> owner = new ArrayList<Territory>();
        while (iter.hasNext()) {
            Territory territory = iter.next();
            if (!territory.getOwner().equals(player)) continue;
            owner.add(territory);
        }
        return owner;
    }

    public boolean isValidRoute(Route route) {
        Territory previous = null;
        for (Territory t : route) {
            if (previous != null && !this.getNeighbors(previous).contains(t)) {
                return false;
            }
            previous = t;
        }
        return true;
    }

    public void notifyChanged() {
        this.getData().notifyMapDataChanged();
    }
}

