/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameObjectStreamData;
import games.strategy.engine.data.Unit;
import games.strategy.engine.framework.GameObjectStreamFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class GameObjectInputStream
extends ObjectInputStream {
    private final GameObjectStreamFactory m_dataSource;

    public GameObjectInputStream(GameObjectStreamFactory dataSource, InputStream input) throws IOException {
        super(input);
        this.m_dataSource = dataSource;
        this.enableResolveObject(true);
    }

    public GameData getData() {
        return this.m_dataSource.getData();
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        if (obj instanceof GameData) {
            return this.m_dataSource.getData();
        }
        if (obj instanceof GameObjectStreamData) {
            return ((GameObjectStreamData)obj).getReference(this.getData());
        }
        if (obj instanceof Unit) {
            return this.resolveUnit((Unit)obj);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolveUnit(Unit unit) {
        this.m_dataSource.getData().acquireReadLock();
        try {
            Unit local = this.m_dataSource.getData().getUnits().get(unit.getID());
            if (local != null) {
                Unit unit2 = local;
                return unit2;
            }
            this.getData().getUnits().put(unit);
            Unit unit3 = unit;
            return unit3;
        }
        finally {
            this.m_dataSource.getData().releaseReadLock();
        }
    }
}

