/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.Named;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.UnitType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GameObjectStreamData
implements Externalizable {
    private static final long serialVersionUID = 740501183336843321L;
    private String m_name;
    private GameType m_type;

    public static boolean canSerialize(Named obj) {
        return obj instanceof PlayerID || obj instanceof UnitType || obj instanceof Territory || obj instanceof ProductionRule || obj instanceof IAttachment || obj instanceof ProductionFrontier;
    }

    public GameObjectStreamData() {
    }

    public GameObjectStreamData(Named named) {
        this.m_name = named.getName();
        if (named instanceof PlayerID) {
            this.m_type = GameType.PLAYERID;
        } else if (named instanceof Territory) {
            this.m_type = GameType.TERRITORY;
        } else if (named instanceof UnitType) {
            this.m_type = GameType.UNITTYPE;
        } else if (named instanceof ProductionRule) {
            this.m_type = GameType.PRODUCTIONRULE;
        } else if (named instanceof ProductionFrontier) {
            this.m_type = GameType.PRODUCTIONFRONTIER;
        } else {
            throw new IllegalArgumentException("Wrong type:" + named);
        }
    }

    public Named getReference(GameData data) {
        if (data == null) {
            throw new IllegalArgumentException("Data cant be null");
        }
        data.acquireReadLock();
        try {
            switch (this.m_type) {
                case PLAYERID: {
                    PlayerID playerID = data.getPlayerList().getPlayerID(this.m_name);
                    return playerID;
                }
                case TERRITORY: {
                    Territory territory = data.getMap().getTerritory(this.m_name);
                    return territory;
                }
                case UNITTYPE: {
                    UnitType unitType = data.getUnitTypeList().getUnitType(this.m_name);
                    return unitType;
                }
                case PRODUCTIONRULE: {
                    ProductionRule productionRule = data.getProductionRuleList().getProductionRule(this.m_name);
                    return productionRule;
                }
                case PRODUCTIONFRONTIER: {
                    ProductionFrontier productionFrontier = data.getProductionFrontierList().getProductionFrontier(this.m_name);
                    return productionFrontier;
                }
            }
            throw new IllegalStateException("Unknown type" + this);
        }
        finally {
            data.releaseReadLock();
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_name = (String)in.readObject();
        this.m_type = GameType.values()[in.readByte()];
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_name);
        out.writeByte((byte)this.m_type.ordinal());
    }

    static enum GameType {
        PLAYERID,
        UNITTYPE,
        TERRITORY,
        PRODUCTIONRULE,
        PRODUCTIONFRONTIER;

    }
}

