/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Attachable;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.triplea.attatchments.TechAttachment;

class GenericTechChange
extends Change {
    private static final long serialVersionUID = -2439447526511535571L;
    private final Attachable m_attachedTo;
    private final String m_attachmentName;
    private final Boolean m_newValue;
    private final Boolean m_oldValue;
    private final String m_property;

    public Attachable getAttachedTo() {
        return this.m_attachedTo;
    }

    public String getAttachmentName() {
        return this.m_attachmentName;
    }

    GenericTechChange(TechAttachment attachment, Boolean newValue, String property) {
        if (attachment == null) {
            throw new IllegalArgumentException("No attachment, newValue:" + newValue + " property:" + property);
        }
        this.m_attachedTo = attachment.getAttachedTo();
        this.m_attachmentName = attachment.getName();
        this.m_oldValue = (boolean)attachment.hasGenericTech(property);
        this.m_newValue = (boolean)newValue;
        this.m_property = property;
    }

    public GenericTechChange(Attachable attachTo, String attachmentName, Boolean newValue, Boolean oldValue, String property) {
        this.m_attachmentName = attachmentName;
        this.m_attachedTo = attachTo;
        this.m_newValue = newValue;
        this.m_oldValue = oldValue;
        this.m_property = property;
    }

    @Override
    public void perform(GameData data) {
        TechAttachment attachment = (TechAttachment)this.m_attachedTo.getAttachment(this.m_attachmentName);
        attachment.setGenericTech(this.m_property, this.m_newValue);
    }

    @Override
    public Change invert() {
        return new GenericTechChange(this.m_attachedTo, this.m_attachmentName, this.m_oldValue, this.m_newValue, this.m_property);
    }

    public String toString() {
        return "GenericTechChange attached to:" + this.m_attachedTo + " name:" + this.m_attachmentName + " new value:" + this.m_newValue + " old value:" + this.m_oldValue;
    }
}

