/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.NamedUnitHolder;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.RepairFrontier;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.TechnologyFrontierList;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitCollection;
import games.strategy.triplea.delegate.Matches;
import games.strategy.util.CompositeMatchAnd;
import java.io.Serializable;
import java.util.LinkedHashMap;

public class PlayerID
extends NamedAttachable
implements NamedUnitHolder,
Serializable {
    private static final long serialVersionUID = -2284878450555315947L;
    private final boolean m_optional;
    private final boolean m_canBeDisabled;
    private boolean m_isDisabled = false;
    private final UnitCollection m_unitsHeld;
    private final ResourceCollection m_resources;
    private ProductionFrontier m_productionFrontier;
    private RepairFrontier m_repairFrontier;
    private final TechnologyFrontierList m_technologyFrontiers;
    private String m_whoAmI = "null:no_one";
    public static final PlayerID NULL_PLAYERID = new PlayerID("Neutral", true, false, null){
        private static final long serialVersionUID = -6596127754502509049L;

        @Override
        public boolean isNull() {
            return true;
        }
    };

    public PlayerID(String name, boolean optional, boolean canBeDisabled, GameData data) {
        super(name, data);
        this.m_optional = optional;
        this.m_canBeDisabled = canBeDisabled;
        this.m_unitsHeld = new UnitCollection(this, data);
        this.m_resources = new ResourceCollection(data);
        this.m_technologyFrontiers = new TechnologyFrontierList(data);
    }

    public boolean getOptional() {
        return this.m_optional;
    }

    public boolean getCanBeDisabled() {
        return this.m_canBeDisabled;
    }

    @Override
    public UnitCollection getUnits() {
        return this.m_unitsHeld;
    }

    public ResourceCollection getResources() {
        return this.m_resources;
    }

    public TechnologyFrontierList getTechnologyFrontierList() {
        return this.m_technologyFrontiers;
    }

    public void setProductionFrontier(ProductionFrontier frontier) {
        this.m_productionFrontier = frontier;
    }

    public ProductionFrontier getProductionFrontier() {
        return this.m_productionFrontier;
    }

    public void setRepairFrontier(RepairFrontier frontier) {
        this.m_repairFrontier = frontier;
    }

    public RepairFrontier getRepairFrontier() {
        return this.m_repairFrontier;
    }

    @Override
    public void notifyChanged() {
    }

    public boolean isNull() {
        return false;
    }

    @Override
    public String toString() {
        return "PlayerID named:" + this.getName();
    }

    @Override
    public String getType() {
        return "P";
    }

    public void setWhoAmI(String humanOrAI_colon_playerName) {
        String[] s = humanOrAI_colon_playerName.split(":");
        if (s.length != 2) {
            throw new IllegalStateException("whoAmI must have two strings, separated by a colon");
        }
        if (!(s[0].equalsIgnoreCase("AI") || s[0].equalsIgnoreCase("Human") || s[0].equalsIgnoreCase("null"))) {
            throw new IllegalStateException("whoAmI first part must be, ai or human or client");
        }
        this.m_whoAmI = humanOrAI_colon_playerName;
    }

    public String getWhoAmI() {
        return this.m_whoAmI;
    }

    public boolean isAI() {
        return this.m_whoAmI.split(":")[0].equalsIgnoreCase("AI");
    }

    public void setIsDisabled(boolean isDisabled) {
        this.m_isDisabled = isDisabled;
    }

    public boolean getIsDisabled() {
        return this.m_isDisabled;
    }

    public boolean amNotDeadYet(GameData data) {
        boolean hasFactory = false;
        boolean ownsLand = false;
        for (Territory t : data.getMap().getTerritories()) {
            if (t.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(this), Matches.unitHasAttackValueOfAtLeast(1), Matches.UnitCanMove, Matches.UnitIsLand))) {
                return true;
            }
            if (t.getOwner().equals(this)) {
                ownsLand = true;
            }
            if (t.getUnits().someMatch(new CompositeMatchAnd<Unit>(Matches.unitIsOwnedBy(this), Matches.UnitCanProduceUnits))) {
                hasFactory = true;
            }
            if (!ownsLand || !hasFactory) continue;
            return true;
        }
        return false;
    }

    public static LinkedHashMap<String, String> currentPlayers(GameData data) {
        LinkedHashMap<String, String> rVal = new LinkedHashMap<String, String>();
        if (data == null) {
            return rVal;
        }
        for (PlayerID player : data.getPlayerList().getPlayers()) {
            rVal.put(player.getName(), player.getWhoAmI().split(":")[1]);
        }
        return rVal;
    }

    @Override
    @Deprecated
    public GameData getData() {
        return super.getData();
    }
}

