/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PlayerList
extends GameDataComponent
implements Iterable<PlayerID> {
    private static final long serialVersionUID = -3895068111754745446L;
    private final Map<String, PlayerID> m_players = new LinkedHashMap<String, PlayerID>();

    public PlayerList(GameData data) {
        super(data);
    }

    protected void addPlayerID(PlayerID player) {
        this.m_players.put(player.getName(), player);
    }

    public int size() {
        return this.m_players.size();
    }

    public PlayerID getPlayerID(String name) {
        if (PlayerID.NULL_PLAYERID.getName().equals(name)) {
            return PlayerID.NULL_PLAYERID;
        }
        return this.m_players.get(name);
    }

    public String[] getNames() {
        String[] values = new String[this.size()];
        this.m_players.keySet().toArray(values);
        return values;
    }

    public List<PlayerID> getPlayers() {
        return new ArrayList<PlayerID>(this.m_players.values());
    }

    @Override
    public Iterator<PlayerID> iterator() {
        return this.getPlayers().iterator();
    }

    public Collection<String> getPlayersThatMayBeDisabled() {
        HashSet<String> disableable = new HashSet<String>();
        for (PlayerID p : this.m_players.values()) {
            if (!p.getCanBeDisabled() || p.getIsDisabled()) continue;
            disableable.add(p.getName());
        }
        return disableable;
    }

    public HashMap<String, Boolean> getPlayersEnabledListing() {
        HashMap<String, Boolean> playersEnabledListing = new HashMap<String, Boolean>();
        for (PlayerID p : this.m_players.values()) {
            playersEnabledListing.put(p.getName(), !p.getIsDisabled());
        }
        return playersEnabledListing;
    }
}

