/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.RelationshipType;
import games.strategy.triplea.delegate.Matches;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RelationshipInterpreter
extends GameDataComponent {
    private static final long serialVersionUID = -643454441052535241L;

    public RelationshipInterpreter(GameData data) {
        super(data);
    }

    public boolean isAllied(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeIsAllied.match(this.getRelationshipType(p1, p2));
    }

    public boolean isAlliedWithAnyOfThesePlayers(PlayerID p1, Collection<PlayerID> p2s) {
        for (PlayerID p2 : p2s) {
            if (!Matches.RelationshipTypeIsAllied.match(this.getRelationshipType(p1, p2))) continue;
            return true;
        }
        return false;
    }

    public Set<PlayerID> getAllies(PlayerID p1, boolean includeSelf) {
        HashSet<PlayerID> allies = new HashSet<PlayerID>();
        for (PlayerID player : this.getData().getPlayerList().getPlayers()) {
            if (!Matches.RelationshipTypeIsAllied.match(this.getRelationshipType(p1, player))) continue;
            allies.add(player);
        }
        if (includeSelf) {
            allies.add(p1);
        } else {
            allies.remove(p1);
        }
        return allies;
    }

    public boolean isAtWar(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeIsAtWar.match(this.getRelationshipType(p1, p2));
    }

    public boolean isAtWarWithAnyOfThesePlayers(PlayerID p1, Collection<PlayerID> p2s) {
        for (PlayerID p2 : p2s) {
            if (!Matches.RelationshipTypeIsAtWar.match(this.getRelationshipType(p1, p2))) continue;
            return true;
        }
        return false;
    }

    public Set<PlayerID> getEnemies(PlayerID p1) {
        HashSet<PlayerID> enemies = new HashSet<PlayerID>();
        for (PlayerID player : this.getData().getPlayerList().getPlayers()) {
            if (!Matches.RelationshipTypeIsAtWar.match(this.getRelationshipType(p1, player))) continue;
            enemies.add(player);
        }
        enemies.remove(p1);
        return enemies;
    }

    public boolean isNeutral(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeIsNeutral.match(this.getRelationshipType(p1, p2));
    }

    public boolean isNeutralWithAnyOfThesePlayers(PlayerID p1, Collection<PlayerID> p2s) {
        for (PlayerID p2 : p2s) {
            if (!Matches.RelationshipTypeIsNeutral.match(this.getRelationshipType(p1, p2))) continue;
            return true;
        }
        return false;
    }

    public Set<PlayerID> getNeutralities(PlayerID p1) {
        HashSet<PlayerID> neutrals = new HashSet<PlayerID>();
        for (PlayerID player : this.getData().getPlayerList().getPlayers()) {
            if (!Matches.RelationshipTypeIsNeutral.match(this.getRelationshipType(p1, player))) continue;
            neutrals.add(player);
        }
        neutrals.remove(p1);
        return neutrals;
    }

    public boolean canMoveLandUnitsOverOwnedLand(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeCanMoveLandUnitsOverOwnedLand.match(this.getRelationshipType(p1, p2));
    }

    public boolean canMoveAirUnitsOverOwnedLand(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeCanMoveAirUnitsOverOwnedLand.match(this.getRelationshipType(p1, p2));
    }

    public boolean canLandAirUnitsOnOwnedLand(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeCanLandAirUnitsOnOwnedLand.match(this.getRelationshipType(p1, p2));
    }

    public String getUpkeepCost(PlayerID p1, PlayerID p2) {
        return this.getRelationshipType(p1, p2).getRelationshipTypeAttachment().getUpkeepCost();
    }

    public boolean alliancesCanChainTogether(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeIsAlliedAndAlliancesCanChainTogether.match(this.getRelationshipType(p1, p2));
    }

    public boolean isDefaultWarPosition(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeIsDefaultWarPosition.match(this.getRelationshipType(p1, p2));
    }

    public boolean canTakeOverOwnedTerritory(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeCanTakeOverOwnedTerritory.match(this.getRelationshipType(p1, p2));
    }

    public boolean givesBackOriginalTerritories(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeGivesBackOriginalTerritories.match(this.getRelationshipType(p1, p2));
    }

    public boolean canMoveIntoDuringCombatMove(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeCanMoveIntoDuringCombatMove.match(this.getRelationshipType(p1, p2));
    }

    public boolean canMoveThroughCanals(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeCanMoveThroughCanals.match(this.getRelationshipType(p1, p2));
    }

    public boolean rocketsCanFlyOver(PlayerID p1, PlayerID p2) {
        return Matches.RelationshipTypeRocketsCanFlyOver.match(this.getRelationshipType(p1, p2));
    }

    RelationshipType getRelationshipType(PlayerID p1, PlayerID p2) {
        return this.getData().getRelationshipTracker().getRelationshipType(p1, p2);
    }
}

