/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.AddUnits;
import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.Unit;
import games.strategy.engine.data.UnitCollection;
import games.strategy.engine.data.UnitHolder;
import java.util.ArrayList;
import java.util.Collection;

class RemoveUnits
extends Change {
    static final long serialVersionUID = -6410444472951010568L;
    private final String m_name;
    private final Collection<Unit> m_units;
    private final String m_type;

    RemoveUnits(UnitCollection collection, Collection<Unit> units) {
        this(collection.getHolder().getName(), collection.getHolder().getType(), units);
    }

    RemoveUnits(String name, String type, Collection<Unit> units) {
        this.m_units = new ArrayList<Unit>(units);
        this.m_name = name;
        this.m_type = type;
    }

    RemoveUnits(String name, String type, Collection<Unit> units, boolean isCasualty) {
        this.m_type = type;
        this.m_units = new ArrayList<Unit>(units);
        this.m_name = name;
    }

    @Override
    public Change invert() {
        return new AddUnits(this.m_name, this.m_type, this.m_units);
    }

    @Override
    protected void perform(GameData data) {
        UnitHolder holder = data.getUnitHolder(this.m_name, this.m_type);
        if (!holder.getUnits().containsAll(this.m_units)) {
            throw new IllegalStateException("Not all units present in:" + this.m_name + ".  Trying to remove:" + this.m_units + " present:" + holder.getUnits().getUnits());
        }
        holder.getUnits().removeAllUnits(this.m_units);
    }

    public String toString() {
        return "Remove unit change. Remove from:" + this.m_name + " units:" + this.m_units;
    }
}

