/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.GameDataComponent;
import games.strategy.engine.data.Resource;
import games.strategy.util.IntegerMap;

public class ResourceCollection
extends GameDataComponent {
    private static final long serialVersionUID = -1247795977888113757L;
    private final IntegerMap<Resource> m_resources = new IntegerMap();

    public ResourceCollection(GameData data) {
        super(data);
    }

    public ResourceCollection(ResourceCollection other) {
        super(other.getData());
        this.m_resources.add(other.m_resources);
    }

    public ResourceCollection(ResourceCollection[] others, GameData data) {
        super(data);
        for (ResourceCollection other : others) {
            this.m_resources.add(other.m_resources);
        }
    }

    public ResourceCollection(GameData data, IntegerMap<Resource> resources) {
        this(data);
        this.m_resources.add(resources);
    }

    public void addResource(Resource resource, int quantity) {
        if (quantity < 0) {
            throw new IllegalArgumentException("quantity must be positive");
        }
        this.change(resource, quantity);
    }

    public void add(ResourceCollection otherResources) {
        this.m_resources.add(otherResources.m_resources);
    }

    public void removeResource(Resource resource, int quantity) {
        if (quantity < 0) {
            throw new IllegalArgumentException("quantity must be positive");
        }
        int current = this.getQuantity(resource);
        if (current - quantity < 0) {
            throw new IllegalArgumentException("Cant remove more than player has of resource: " + resource.getName() + ". current:" + current + " toRemove: " + quantity);
        }
        this.change(resource, -quantity);
    }

    public void removeAllOfResource(Resource resource) {
        this.m_resources.removeKey(resource);
    }

    private void change(Resource resource, int quantity) {
        this.m_resources.add(resource, quantity);
    }

    public void putResource(Resource resource, int quantity) {
        if (quantity < 0) {
            throw new IllegalArgumentException("quantity must be positive");
        }
        this.m_resources.put(resource, quantity);
    }

    public int getQuantity(Resource resource) {
        return this.m_resources.getInt(resource);
    }

    public IntegerMap<Resource> getResourcesCopy() {
        return new IntegerMap<Resource>(this.m_resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQuantity(String name) {
        this.getData().acquireReadLock();
        try {
            Resource resource = this.getData().getResourceList().getResource(name);
            if (resource == null) {
                throw new IllegalArgumentException("No resource named:" + name);
            }
            int n = this.getQuantity(resource);
            return n;
        }
        finally {
            this.getData().releaseReadLock();
        }
    }

    public boolean has(IntegerMap<Resource> map) {
        return this.m_resources.greaterThanOrEqualTo(map);
    }

    public ResourceCollection difference(ResourceCollection otherCollection) {
        ResourceCollection returnCollection = new ResourceCollection(this.getData(), this.m_resources);
        returnCollection.subtract(otherCollection);
        return returnCollection;
    }

    private void subtract(ResourceCollection resourceCollection) {
        this.subtract(resourceCollection.m_resources);
    }

    public void subtract(IntegerMap<Resource> cost) {
        for (Resource resource : cost.keySet()) {
            this.removeResource(resource, cost.getInt(resource));
        }
    }

    public void subtract(IntegerMap<Resource> cost, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.subtract(cost);
        }
    }

    public void add(IntegerMap<Resource> resources) {
        for (Resource resource : resources.keySet()) {
            this.addResource(resource, resources.getInt(resource));
        }
    }

    public void add(IntegerMap<Resource> resources, int quantity) {
        for (int i = 0; i < quantity; ++i) {
            this.add(resources);
        }
    }

    public void discount(double discount) {
        this.multiplyAllValuesBy(discount, 3);
    }

    public void multiplyAllValuesBy(double multiplyBy, int roundType) {
        this.m_resources.multiplyAllValuesBy(multiplyBy, roundType);
    }

    public int fitsHowOften(IntegerMap<Resource> cost) {
        if (cost.size() == 0 || cost.totalValues() <= 0 && cost.isPositive()) {
            return Integer.MAX_VALUE;
        }
        ResourceCollection resources = new ResourceCollection(this.getData(), this.m_resources);
        for (int i = 0; i <= 10000; ++i) {
            try {
                resources.subtract(cost);
                continue;
            }
            catch (IllegalArgumentException iae) {
                return i;
            }
        }
        return 10000;
    }

    public String toString() {
        return ResourceCollection.toString(this.m_resources, this.getData(), ", ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(IntegerMap<Resource> resources, GameData data, String lineSeparator) {
        if (resources == null || resources.isEmpty() || resources.allValuesEqual(0)) {
            return "nothing";
        }
        StringBuilder sb = new StringBuilder();
        Resource pus = null;
        data.acquireReadLock();
        try {
            pus = data.getResourceList().getResource("PUs");
        }
        catch (NullPointerException e) {
            for (Resource r : resources.keySet()) {
                if (!r.getName().equals("PUs")) continue;
                pus = r;
                break;
            }
        }
        finally {
            data.releaseReadLock();
        }
        if (pus == null) {
            throw new IllegalStateException("Possible deserialization error: PUs is null");
        }
        if (resources.getInt(pus) != 0) {
            sb.append(lineSeparator);
            sb.append(resources.getInt(pus));
            sb.append(" ");
            sb.append(pus.getName());
        }
        for (Resource resource : resources.keySet()) {
            if (resource.equals(pus)) continue;
            sb.append(lineSeparator);
            sb.append(resources.getInt(resource));
            sb.append(" ");
            sb.append(resource.getName());
        }
        return sb.toString().replaceFirst(lineSeparator, "");
    }

    public String toStringForHTML() {
        return ResourceCollection.toStringForHTML(this.m_resources, this.getData());
    }

    public static String toStringForHTML(IntegerMap<Resource> resources, GameData data) {
        return ResourceCollection.toString(resources, data, "<br />");
    }

    public void multiply(int times) {
        IntegerMap<Resource> base = new IntegerMap<Resource>(this.m_resources);
        this.add(base, times - 1);
    }

    public boolean isEmpty() {
        return this.m_resources.isEmpty();
    }
}

