/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ResourceCollection;
import games.strategy.engine.data.RouteScripted;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.delegate.MoveValidator;
import games.strategy.util.CompositeMatchAnd;
import games.strategy.util.Match;
import games.strategy.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Route
implements Serializable,
Iterable<Territory> {
    private static final long serialVersionUID = 8743882455488948557L;
    static final List<Territory> emptyTerritoryList = Collections.unmodifiableList(new ArrayList());
    static final Integer defaultMovementCost = new Integer(1);
    private final List<Territory> m_steps = new ArrayList<Territory>();
    private Territory m_start;

    public Route() {
    }

    public Route(List<Territory> route) {
        this.setStart(route.get(0));
        if (route.size() == 1) {
            return;
        }
        for (Territory t : route.subList(1, route.size())) {
            this.add(t);
        }
    }

    public Route(Territory start, Territory ... route) {
        this.setStart(start);
        for (Territory t : route) {
            this.add(t);
        }
    }

    public static Route join(Route r1, Route r2) {
        if (r1 == null || r2 == null) {
            return null;
        }
        if (r1.numberOfSteps() == 0 ? !r1.getStart().equals(r2.getStart()) : !r1.getEnd().equals(r2.getStart())) {
            throw new IllegalArgumentException("Cannot join, r1 doesnt end where r2 starts. r1:" + r1 + " r2:" + r2);
        }
        ArrayList<Territory> c1 = new ArrayList<Territory>(r1.m_steps);
        c1.add(r1.getStart());
        ArrayList<Territory> c2 = new ArrayList<Territory>(r2.m_steps);
        if (!Util.intersection(c1, c2).isEmpty()) {
            return null;
        }
        Route joined = new Route();
        joined.setStart(r1.getStart());
        for (Territory t : r1.getSteps()) {
            joined.add(t);
        }
        for (Territory t : r2.getSteps()) {
            joined.add(t);
        }
        return joined;
    }

    public static Route subRoute(Route route, Territory end) {
        if (!route.getAllTerritories().contains(end)) {
            throw new IllegalArgumentException("Cannot take subroute if route does not contain end");
        }
        if (route.getStart().equals(end)) {
            return new RouteScripted(end);
        }
        Route subRoute = new Route();
        subRoute.setStart(route.getStart());
        for (Territory t : route.getSteps()) {
            subRoute.add(t);
            if (!t.equals(end)) continue;
            return subRoute;
        }
        return subRoute;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Route other = (Route)o;
        if (other.numberOfSteps() != this.numberOfSteps()) {
            return false;
        }
        if (!other.getStart().equals(this.getStart())) {
            return false;
        }
        return other.getAllTerritories().equals(this.getAllTerritories());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void setStart(Territory t) {
        if (t == null) {
            throw new IllegalStateException("Null territory");
        }
        this.m_start = t;
    }

    public Territory getStart() {
        return this.m_start;
    }

    public boolean crossesWater() {
        boolean startLand = !this.m_start.isWater();
        boolean overWater = false;
        Iterator<Territory> routeIter = this.m_steps.iterator();
        Territory terr = null;
        while (routeIter.hasNext()) {
            terr = routeIter.next();
            if (!terr.isWater()) continue;
            overWater = true;
        }
        if (terr == null) {
            return false;
        }
        return startLand && overWater && !terr.isWater();
    }

    public void add(Territory t) {
        if (t == null) {
            throw new IllegalStateException("Null territory");
        }
        if (t.equals(this.m_start) || this.m_steps.contains(t)) {
            throw new IllegalArgumentException("Loops not allowed in m_routes, route:" + this + " new territory:" + t);
        }
        this.m_steps.add(t);
    }

    @Deprecated
    public int getLength() {
        return this.m_steps.size();
    }

    public int getMovementCost(Unit u) {
        return this.m_steps.size();
    }

    public int numberOfSteps() {
        return this.m_steps.size();
    }

    public int numberOfStepsIncludingStart() {
        return this.getAllTerritories().size();
    }

    public Territory getTerritoryAtStep(int i) {
        return this.m_steps.get(i);
    }

    public boolean allMatch(Match<Territory> aMatch) {
        for (Territory t : this.m_steps) {
            if (aMatch.match(t)) continue;
            return false;
        }
        return true;
    }

    public boolean someMatch(Match<Territory> aMatch) {
        for (Territory t : this.m_steps) {
            if (!aMatch.match(t)) continue;
            return true;
        }
        return false;
    }

    public boolean allMatchAllSteps(Match<Territory> aMatch) {
        for (Territory t : this.getAllTerritories()) {
            if (aMatch.match(t)) continue;
            return false;
        }
        return true;
    }

    public boolean someMatchAllSteps(Match<Territory> aMatch) {
        for (Territory t : this.getAllTerritories()) {
            if (!aMatch.match(t)) continue;
            return true;
        }
        return false;
    }

    public boolean allMatchMiddleSteps(Match<Territory> aMatch, boolean defaultWhenNoMiddleSteps) {
        List<Territory> middle = this.getMiddleSteps();
        if (middle.isEmpty()) {
            return defaultWhenNoMiddleSteps;
        }
        for (Territory t : middle) {
            if (aMatch.match(t)) continue;
            return false;
        }
        return true;
    }

    public boolean someMatchMiddleSteps(Match<Territory> aMatch, boolean defaultWhenNoMiddleSteps) {
        List<Territory> middle = this.getMiddleSteps();
        if (middle.isEmpty()) {
            return defaultWhenNoMiddleSteps;
        }
        for (Territory t : middle) {
            if (!aMatch.match(t)) continue;
            return true;
        }
        return false;
    }

    public Collection<Territory> getMatches(Match<Territory> aMatch) {
        return Match.getMatches(this.m_steps, aMatch);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Route:").append(this.m_start);
        for (Territory t : this.getSteps()) {
            buf.append(" -> ");
            buf.append(t.getName());
        }
        return buf.toString();
    }

    @Deprecated
    public List<Territory> getTerritories() {
        return this.getAllTerritories();
    }

    public List<Territory> getAllTerritories() {
        ArrayList<Territory> list = new ArrayList<Territory>(this.m_steps);
        list.add(0, this.m_start);
        return list;
    }

    public List<Territory> getSteps() {
        if (this.numberOfSteps() > 0) {
            return new ArrayList<Territory>(this.m_steps);
        }
        return emptyTerritoryList;
    }

    public List<Territory> getMiddleSteps() {
        if (this.numberOfSteps() > 1) {
            return new ArrayList<Territory>(this.m_steps).subList(0, this.numberOfSteps() - 1);
        }
        return emptyTerritoryList;
    }

    public Territory getEnd() {
        if (this.m_steps.size() == 0) {
            return null;
        }
        return this.m_steps.get(this.m_steps.size() - 1);
    }

    public boolean extend(Route baseRoute) {
        if (!this.m_start.equals(baseRoute.m_start)) {
            return false;
        }
        if (baseRoute.numberOfSteps() > this.numberOfSteps()) {
            return false;
        }
        for (int i = 0; i < baseRoute.m_steps.size(); ++i) {
            if (baseRoute.getTerritoryAtStep(i).equals(this.getTerritoryAtStep(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Territory> iterator() {
        return Collections.unmodifiableList(this.getAllTerritories()).iterator();
    }

    public boolean hasSteps() {
        return !this.m_steps.isEmpty();
    }

    public boolean hasNoSteps() {
        return !this.hasSteps();
    }

    public boolean hasExactlyOneStep() {
        return this.m_steps.size() == 1;
    }

    public Territory getTerritoryBeforeEnd() {
        if (this.m_steps.size() <= 1) {
            return this.getStart();
        }
        return this.getTerritoryAtStep(this.m_steps.size() - 2);
    }

    public boolean isUnload() {
        if (this.hasNoSteps()) {
            return false;
        }
        return this.getStart().isWater() && !this.getEnd().isWater();
    }

    public boolean isLoad() {
        if (this.hasNoSteps()) {
            return false;
        }
        return !this.getStart().isWater() && this.getEnd().isWater();
    }

    public boolean hasMoreThenOneStep() {
        return this.m_steps.size() > 1;
    }

    public boolean hasNeutralBeforeEnd() {
        for (Territory current : this.getMiddleSteps()) {
            if (current.isWater() || !current.getOwner().equals(PlayerID.NULL_PLAYERID)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWater() {
        if (this.getStart().isWater()) {
            return true;
        }
        return Match.someMatch(this.getSteps(), Matches.TerritoryIsWater);
    }

    public boolean hasLand() {
        if (!this.getStart().isWater()) {
            return true;
        }
        return !Match.allMatch(this.getAllTerritories(), Matches.TerritoryIsWater);
    }

    public int getLargestMovementCost(Collection<Unit> units) {
        int largestCost = 0;
        for (Unit unit : units) {
            largestCost = Math.max(largestCost, this.getMovementCost(unit));
        }
        return largestCost;
    }

    public int getMovementLeft(Unit unit) {
        int movementLeft = ((TripleAUnit)unit).getMovementLeft() - this.getMovementCost(unit);
        return movementLeft;
    }

    public ResourceCollection getMovementFuelCostCharge(Unit unit, GameData data) {
        ResourceCollection col = new ResourceCollection(data);
        if (Matches.unitIsBeingTransported().match(unit)) {
            return col;
        }
        UnitAttachment ua = UnitAttachment.get(unit.getType());
        col.add(ua.getFuelCost());
        col.multiply(this.getMovementCost(unit));
        return col;
    }

    public static ResourceCollection getMovementFuelCostCharge(Collection<Unit> unitsAll, Route route, PlayerID currentPlayer, GameData data) {
        HashSet<Unit> units = new HashSet<Unit>(unitsAll);
        units.removeAll(Match.getMatches(unitsAll, Matches.unitIsBeingTransportedByOrIsDependentOfSomeUnitInThisList(unitsAll, route, currentPlayer, data, true)));
        ResourceCollection movementCharge = new ResourceCollection(data);
        for (Unit unit : units) {
            movementCharge.add(route.getMovementFuelCostCharge(unit, data));
        }
        return movementCharge;
    }

    protected static Set<Unit> getOwnedAirMovingWithOwnedCarriers(Collection<Unit> unitsAll, PlayerID currentPlayer, GameData data) {
        List<Unit> ownedFighters = Match.getMatches(unitsAll, new CompositeMatchAnd(Matches.UnitCanLandOnCarrier, Matches.UnitIsAir, Matches.unitIsOwnedBy(currentPlayer)));
        if (ownedFighters.isEmpty()) {
            return new HashSet<Unit>();
        }
        List<Unit> ownedCarriers = Match.getMatches(unitsAll, new CompositeMatchAnd(Matches.UnitIsCarrier, Matches.UnitIsSea, Matches.unitIsOwnedBy(currentPlayer)));
        if (ownedCarriers.isEmpty()) {
            return new HashSet<Unit>();
        }
        HashSet<Unit> ownedFightersOnOwnedCarriers = new HashSet<Unit>();
        for (Unit carrier : ownedCarriers) {
            Collection<Unit> carrying = MoveValidator.getCanCarry(carrier, ownedFighters, currentPlayer, data);
            ownedFighters.removeAll(carrying);
            ownedFightersOnOwnedCarriers.addAll(carrying);
        }
        return ownedFightersOnOwnedCarriers;
    }
}

