/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.Change;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.properties.GameProperties;

class SetPropertyChange
extends Change {
    private static final long serialVersionUID = -1377597975513821508L;
    private final String m_property;
    private final Object m_value;
    private final Object m_oldValue;

    SetPropertyChange(String property, Object value, GameProperties properties) {
        this.m_property = property;
        this.m_value = value;
        this.m_oldValue = properties.get(property);
    }

    private SetPropertyChange(String property, Object value, Object oldValue) {
        this.m_property = property;
        this.m_value = value;
        this.m_oldValue = oldValue;
    }

    @Override
    public Change invert() {
        return new SetPropertyChange(this.m_property, this.m_oldValue, this.m_value);
    }

    @Override
    protected void perform(GameData data) {
        data.getProperties().set(this.m_property, this.m_value);
    }
}

