/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data;

import games.strategy.engine.data.GameData;
import games.strategy.engine.data.NamedAttachable;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionRule;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.triplea.TripleAUnit;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.image.UnitImageFactory;
import games.strategy.triplea.ui.IUIContext;
import games.strategy.triplea.ui.TooltipProperties;
import games.strategy.util.LocalizeHTML;
import java.awt.Image;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnitType
extends NamedAttachable
implements Serializable {
    private static final long serialVersionUID = 4885339076798905247L;

    public UnitType(String name, GameData data) {
        super(name, data);
    }

    public List<Unit> create(int quantity, PlayerID owner) {
        return this.create(quantity, owner, false);
    }

    public List<Unit> create(int quantity, PlayerID owner, boolean isTemp) {
        return this.create(quantity, owner, isTemp, 0, 0);
    }

    public List<Unit> create(int quantity, PlayerID owner, boolean isTemp, int hitsTaken, int bombingUnitDamage) {
        ArrayList<Unit> collection = new ArrayList<Unit>();
        for (int i = 0; i < quantity; ++i) {
            collection.add(this.create(owner, isTemp, hitsTaken, bombingUnitDamage));
        }
        return collection;
    }

    private Unit create(PlayerID owner, boolean isTemp, int hitsTaken, int bombingUnitDamage) {
        Unit u = this.getData().getGameLoader().getUnitFactory().createUnit(this, owner, this.getData());
        u.setHits(hitsTaken);
        if (u instanceof TripleAUnit) {
            ((TripleAUnit)u).setUnitDamage(bombingUnitDamage);
        }
        if (!isTemp) {
            this.getData().getUnits().put(u);
        }
        return u;
    }

    private Unit create(PlayerID owner, boolean isTemp) {
        return this.create(owner, isTemp, 0, 0);
    }

    public Unit create(PlayerID owner) {
        return this.create(owner, false);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof UnitType)) {
            return false;
        }
        return ((UnitType)o).getName().equals(this.getName());
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getTooltip(PlayerID playerId, boolean useHTML) {
        String customTip = TooltipProperties.getInstance().getToolTip(this, playerId);
        if (customTip == null || customTip.trim().length() <= 0) {
            return UnitAttachment.get(this).toStringShortAndOnlyImportantDifferences(playerId == null ? PlayerID.NULL_PLAYERID : playerId, useHTML, false);
        }
        return LocalizeHTML.localizeImgLinksInHTML(customTip.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<PlayerID, List<UnitType>> getAllPlayerUnitsWithImages(GameData data, IUIContext uiContext, boolean forceIncludeNeutralPlayer) {
        LinkedHashMap<PlayerID, List<UnitType>> rVal = new LinkedHashMap<PlayerID, List<UnitType>>();
        data.acquireReadLock();
        try {
            for (PlayerID p : data.getPlayerList().getPlayers()) {
                rVal.put(p, UnitType.getPlayerUnitsWithImages(p, data, uiContext));
            }
            HashSet unitsSoFar = new HashSet();
            for (List l : rVal.values()) {
                unitsSoFar.addAll(l);
            }
            Set<UnitType> all = data.getUnitTypeList().getAllUnitTypes();
            all.removeAll(unitsSoFar);
            if (forceIncludeNeutralPlayer || !all.isEmpty()) {
                rVal.put(PlayerID.NULL_PLAYERID, UnitType.getPlayerUnitsWithImages(PlayerID.NULL_PLAYERID, data, uiContext));
                unitsSoFar.addAll(rVal.get(PlayerID.NULL_PLAYERID));
                all.removeAll(unitsSoFar);
                if (!all.isEmpty()) {
                    rVal.put(null, new ArrayList<UnitType>(all));
                }
            }
        }
        finally {
            data.releaseReadLock();
        }
        return rVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<UnitType> getPlayerUnitsWithImages(PlayerID player, GameData data, IUIContext uiContext) {
        ArrayList<UnitType> rVal = new ArrayList<UnitType>();
        data.acquireReadLock();
        try {
            UnitType ut;
            if (player.getProductionFrontier() != null) {
                for (ProductionRule productionRule : player.getProductionFrontier()) {
                    for (Map.Entry entry : productionRule.getResults().entrySet()) {
                        if (!UnitType.class.isAssignableFrom(((NamedAttachable)entry.getKey()).getClass()) || rVal.contains(ut = (UnitType)entry.getKey())) continue;
                        rVal.add(ut);
                    }
                }
            }
            for (Territory t : data.getMap()) {
                for (Unit unit : t.getUnits()) {
                    if (!unit.getOwner().equals(player) || rVal.contains(ut = unit.getType())) continue;
                    rVal.add(ut);
                }
            }
            for (UnitType ut2 : data.getUnitTypeList().getAllUnitTypes()) {
                if (rVal.contains(ut2)) continue;
                try {
                    Image image;
                    UnitImageFactory imageFactory = uiContext.getUnitImageFactory();
                    if (imageFactory == null || (image = imageFactory.getImage(ut2, player, data, false, false)) == null || rVal.contains(ut2)) continue;
                    rVal.add(ut2);
                }
                catch (Exception e) {}
            }
        }
        finally {
            data.releaseReadLock();
        }
        return rVal;
    }
}

