/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.DefaultAttachmentExporter;
import games.strategy.engine.data.export.IAttachmentExporter;
import games.strategy.engine.data.export.PlayerAttachmentExporter;
import games.strategy.engine.data.export.RulesAttachmentExporter;
import games.strategy.engine.data.export.TechAttachmentExporter;
import games.strategy.engine.data.export.TerritoryAttachmentExporter;
import games.strategy.engine.data.export.TriggerAttachmentExporter;
import games.strategy.engine.data.export.UnitAttachmentExporter;
import games.strategy.engine.data.export.UnitSupportAttachmentExporter;
import games.strategy.triplea.attatchments.CanalAttachment;
import games.strategy.triplea.attatchments.PlayerAttachment;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.TechAttachment;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.attatchments.TriggerAttachment;
import games.strategy.triplea.attatchments.UnitAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;

public class AttachmentExporterFactory {
    public static IAttachmentExporter getExporter(IAttachment attachment) throws AttachmentExportException {
        if (attachment.getClass() == CanalAttachment.class) {
            return new DefaultAttachmentExporter();
        }
        if (attachment.getClass() == RulesAttachment.class) {
            return new RulesAttachmentExporter();
        }
        if (attachment.getClass() == TechAttachment.class) {
            return new TechAttachmentExporter();
        }
        if (attachment.getClass() == TerritoryAttachment.class) {
            return new TerritoryAttachmentExporter();
        }
        if (attachment.getClass() == TriggerAttachment.class) {
            return new TriggerAttachmentExporter();
        }
        if (attachment.getClass() == UnitAttachment.class) {
            return new UnitAttachmentExporter();
        }
        if (attachment.getClass() == UnitSupportAttachment.class) {
            return new UnitSupportAttachmentExporter();
        }
        if (attachment.getClass() == PlayerAttachment.class) {
            return new PlayerAttachmentExporter();
        }
        throw new AttachmentExportException("No exportor defined for: " + attachment.getClass().getCanonicalName());
    }
}

