/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.ProductionFrontier;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.DefaultAttachmentExporter;
import games.strategy.triplea.attatchments.RulesAttachment;
import games.strategy.triplea.attatchments.UnitSupportAttachment;
import games.strategy.triplea.delegate.TechAdvance;
import games.strategy.util.IntegerMap;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TriggerAttachmentExporter
extends DefaultAttachmentExporter {
    @Override
    protected String printOption(Field field, IAttachment attachment) throws AttachmentExportException {
        String fieldName = field.getName();
        if (fieldName.equals("m_trigger")) {
            return this.mTriggerHandler(field, attachment);
        }
        if (fieldName.equals("m_frontier")) {
            return this.mFrontierHandler(field, attachment);
        }
        if (fieldName.equals("m_tech")) {
            return this.mTechHandler(field, attachment);
        }
        if (fieldName.equals("m_players")) {
            return this.mPlayersHandler(field, attachment);
        }
        if (fieldName.equals("m_support")) {
            return this.mSupportHandler(field, attachment);
        }
        if (fieldName.equals("m_purchase")) {
            return this.mPurchaseHandler(field, attachment);
        }
        if (fieldName.equals("m_placement")) {
            return this.mPlacementHandler(field, attachment);
        }
        if (fieldName.equals("m_unitProperty")) {
            return this.mUnitPropertyHandler(field, attachment);
        }
        if (fieldName.equals("m_availableTechs")) {
            return this.mAvailableTechsHandler(field, attachment);
        }
        return super.printOption(field, attachment);
    }

    private String mAvailableTechsHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            Map availableTechsCategoryMap = (Map)field.get(attachment);
            String returnValue = "";
            if (availableTechsCategoryMap == null) {
                return "";
            }
            for (String category : availableTechsCategoryMap.keySet()) {
                Map availableTechMap = (Map)availableTechsCategoryMap.get(category);
                Iterator techAdvances = availableTechMap.keySet().iterator();
                String tList = "";
                while (techAdvances.hasNext()) {
                    TechAdvance techAdvance = (TechAdvance)techAdvances.next();
                    String add = (Boolean)availableTechMap.get(techAdvance) != false ? "" : "-";
                    tList = tList + ":" + add + techAdvance.getName();
                }
                returnValue = returnValue + super.printDefaultOption("availableTech", category + tList);
            }
            return returnValue;
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mAvailableTechsHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mAvailableTechsHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mUnitPropertyHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            String returnValue = "";
            List unitPropertyList = (List)field.get(attachment);
            if (unitPropertyList == null) {
                return "";
            }
            for (String unitProperty : unitPropertyList) {
                String[] s = unitProperty.split(":");
                returnValue = returnValue + super.printCountOption("unitProperty", s[0], s[1]);
            }
            return returnValue;
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mUnitPropertyHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mUnitPropertyHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mPlacementHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            String returnValue = "";
            Map placements = (Map)field.get(attachment);
            if (placements == null) {
                return "";
            }
            for (Territory territory : placements.keySet()) {
                IntegerMap unitMap = (IntegerMap)placements.get(territory);
                for (UnitType unit : unitMap.keySet()) {
                    int number = unitMap.getInt(unit);
                    returnValue = returnValue + super.printCountOption("placement", territory.getName() + ":" + unit.getName(), "" + number);
                }
            }
            return returnValue;
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mPlacementHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mPlacementHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mPurchaseHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printUnitIntegerMap(field, attachment);
    }

    private String mSupportHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            Map unitSupportAttachmentMap = (Map)field.get(attachment);
            if (unitSupportAttachmentMap == null) {
                return "";
            }
            Iterator unitSupportAttachments = unitSupportAttachmentMap.keySet().iterator();
            String returnValue = "";
            while (unitSupportAttachments.hasNext()) {
                String add;
                UnitSupportAttachment supportAttachment = (UnitSupportAttachment)unitSupportAttachments.next();
                String string = add = (Boolean)unitSupportAttachmentMap.get(supportAttachment) != false ? "" : "-";
                if (returnValue.length() > 0) {
                    returnValue = returnValue + ":";
                }
                returnValue = returnValue + add + supportAttachment.getName();
            }
            return this.printDefaultOption("support", returnValue);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mSupportHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mSupportHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mPlayersHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            List playerIds = (List)field.get(attachment);
            Iterator iplayerIds = playerIds.iterator();
            String returnValue = "";
            if (iplayerIds.hasNext()) {
                returnValue = ((PlayerID)iplayerIds.next()).getName();
            }
            while (iplayerIds.hasNext()) {
                returnValue = returnValue + ":" + ((PlayerID)iplayerIds.next()).getName();
            }
            if (returnValue.length() == 0) {
                return "";
            }
            return this.printDefaultOption("players", returnValue);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mPlayersHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mTechHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            List techAdvanceList = (List)field.get(attachment);
            Iterator iTechAdvances = techAdvanceList.iterator();
            String returnValue = "";
            if (iTechAdvances.hasNext()) {
                returnValue = ((TechAdvance)iTechAdvances.next()).getName();
            }
            while (iTechAdvances.hasNext()) {
                returnValue = returnValue + ":" + ((TechAdvance)iTechAdvances.next()).getName();
            }
            if (returnValue.length() == 0) {
                return "";
            }
            return this.printDefaultOption("tech", returnValue);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mTechHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mTechHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mFrontierHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            ProductionFrontier frontier = (ProductionFrontier)field.get(attachment);
            if (frontier == null) {
                return "";
            }
            return super.printDefaultOption("frontier", frontier.getName());
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mFrontierHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mFrontierHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }

    private String mTriggerHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            List ruleAttachmentList = (List)field.get(attachment);
            Iterator rules = ruleAttachmentList.iterator();
            String returnValue = "";
            if (rules.hasNext()) {
                returnValue = ((RulesAttachment)rules.next()).getName();
            }
            while (rules.hasNext()) {
                RulesAttachment rule = (RulesAttachment)rules.next();
                returnValue = returnValue + ":" + rule.getName();
            }
            return this.printDefaultOption("trigger", returnValue);
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mTriggerHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mTriggerHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }
}

