/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.DefaultAttachmentExporter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class UnitAttachmentExporter
extends DefaultAttachmentExporter {
    @Override
    protected String printOption(Field field, IAttachment attachment) throws AttachmentExportException {
        String fieldName = field.getName();
        if (fieldName.equals("m_requiresUnits")) {
            return this.mRequiresUnitsHandler(field, attachment);
        }
        if (fieldName.equals("m_canBeGivenByTerritoryTo")) {
            return this.mCanBeGivenByTerritoryToHandler(field, attachment);
        }
        if (fieldName.equals("m_destroyedWhenCapturedBy")) {
            return this.mDestroyedWhenCapturedByHandler(field, attachment);
        }
        if (fieldName.equals("m_givesMovement")) {
            return this.mGivesMovementHandler(field, attachment);
        }
        if (fieldName.equals("m_consumesUnits")) {
            return this.consumesUnitsHandler(field, attachment);
        }
        if (fieldName.equals("m_createsUnitsList")) {
            return this.mCreatesUnitsListHandler(field, attachment);
        }
        if (fieldName.equals("m_canBeCapturedOnEnteringBy")) {
            return this.mCanBeCapturedOnEnteringByHandler(field, attachment);
        }
        return super.printOption(field, attachment);
    }

    private String consumesUnitsHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printUnitIntegerMap(field, attachment);
    }

    private String mCanBeCapturedOnEnteringByHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printPlayerList(field, attachment);
    }

    private String mCreatesUnitsListHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printUnitIntegerMap(field, attachment);
    }

    private String mGivesMovementHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printUnitIntegerMap(field, attachment);
    }

    private String mDestroyedWhenCapturedByHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printPlayerList(field, attachment);
    }

    private String mCanBeGivenByTerritoryToHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printPlayerList(field, attachment);
    }

    private String mRequiresUnitsHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            ArrayList requiresUnitListList = (ArrayList)field.get(attachment);
            Iterator iRequiresListList = requiresUnitListList.iterator();
            String returnValue = "";
            while (iRequiresListList.hasNext()) {
                Iterator<Object> iRequiresList = Arrays.asList((Object[])iRequiresListList.next()).iterator();
                String value = (String)iRequiresList.next();
                while (iRequiresList.hasNext()) {
                    value = value + ":" + (String)iRequiresList.next();
                }
                returnValue = returnValue + this.printDefaultOption("requiresUnits", value);
            }
            return returnValue;
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mRequiresUnitsHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mRequiresUnitsHandler on field: " + field.getName() + " on Attachment: " + attachment.getName());
        }
    }
}

