/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.export;

import games.strategy.engine.data.IAttachment;
import games.strategy.engine.data.UnitType;
import games.strategy.engine.data.export.AttachmentExportException;
import games.strategy.engine.data.export.DefaultAttachmentExporter;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;

public class UnitSupportAttachmentExporter
extends DefaultAttachmentExporter {
    @Override
    protected String printOption(Field field, IAttachment attachment) throws AttachmentExportException {
        String fieldName = field.getName();
        if (fieldName.equals("m_unitType")) {
            return this.mUnitTypeHandler(field, attachment);
        }
        if (fieldName.equals("m_players")) {
            return this.mPlayersHandler(field, attachment);
        }
        if (fieldName.equals("m_offence") || fieldName.equals("m_defence") || fieldName.equals("m_roll") || fieldName.equals("m_strength") || fieldName.equals("m_allied") || fieldName.equals("m_enemy")) {
            return "";
        }
        return super.printOption(field, attachment);
    }

    private String mPlayersHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        return this.printPlayerList(field, attachment);
    }

    private String mUnitTypeHandler(Field field, IAttachment attachment) throws AttachmentExportException {
        try {
            Set unitTypes = (Set)field.get(attachment);
            Iterator iUnitTypes = unitTypes.iterator();
            String returnValue = "";
            if (iUnitTypes.hasNext()) {
                returnValue = ((UnitType)iUnitTypes.next()).getName();
            }
            while (iUnitTypes.hasNext()) {
                returnValue = returnValue + ":" + ((UnitType)iUnitTypes.next()).getName();
            }
            if (returnValue.length() > 0) {
                return this.printDefaultOption("unitType", returnValue);
            }
            return "";
        }
        catch (IllegalArgumentException e) {
            throw new AttachmentExportException("e: " + e + " for mUnitTypesHandler on field: " + field + "  on Attachment: " + attachment.getName());
        }
        catch (IllegalAccessException e) {
            throw new AttachmentExportException("e: " + e + " for mUnitTypesHandler on field: " + field + "  on Attachment: " + attachment.getName());
        }
    }
}

