/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class BooleanProperty
extends AEditableProperty {
    private static final long serialVersionUID = -7265501762343216435L;
    private boolean mValue;

    public BooleanProperty(String name, String description, boolean defaultValue) {
        super(name, description);
        this.mValue = defaultValue;
    }

    @Override
    public Object getValue() {
        return this.mValue ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setValue(Object value) throws IllegalArgumentException {
        this.mValue = (Boolean)value;
    }

    public void setValue(boolean value) {
        this.mValue = value;
    }

    @Override
    public JComponent getEditorComponent() {
        final JCheckBox box = new JCheckBox("");
        box.setSelected(this.mValue);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BooleanProperty.this.mValue = box.isSelected();
            }
        });
        return box;
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Boolean;
    }
}

