/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;

public class CollectionProperty<T>
extends AEditableProperty {
    private static final long serialVersionUID = 5338055034530377261L;
    private List<T> m_values;

    public CollectionProperty(String name, String description, Collection<T> values) {
        super(name, description);
        this.m_values = new ArrayList<T>(values);
    }

    @Override
    public Object getValue() {
        return this.m_values;
    }

    public List<T> getValueT() {
        return this.m_values;
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        this.m_values = (List)value;
    }

    public void setValueT(List<T> value) {
        this.m_values = value;
    }

    @Override
    public int getRowsNeeded() {
        return this.m_values == null ? 1 : Math.max(1, this.m_values.size());
    }

    @Override
    public JComponent getEditorComponent() {
        if (this.m_values == null) {
            return new JTable();
        }
        Object[][] tableD = new Object[this.m_values.size()][1];
        for (int i = 0; i < this.m_values.size(); ++i) {
            tableD[i][0] = this.m_values.get(i);
        }
        JTable table = new JTable(tableD, new Object[]{"Values: "});
        table.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        return table;
    }

    @Override
    public boolean validate(Object value) {
        if (value == null) {
            return false;
        }
        return List.class.isAssignableFrom(value.getClass());
    }
}

