/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ComboProperty<T>
extends AEditableProperty {
    private static final long serialVersionUID = -3098612299805630587L;
    private final List<T> m_possibleValues;
    private T m_value;

    public ComboProperty(String name, String description, T defaultValue, Collection<T> possibleValues) {
        this(name, description, defaultValue, possibleValues, false);
    }

    public ComboProperty(String name, String description, T defaultValue, Collection<T> possibleValues, boolean allowNone) {
        super(name, description);
        if (!allowNone && !possibleValues.contains(defaultValue) && defaultValue == null) {
            throw new IllegalStateException("possible values does not contain default");
        }
        if (allowNone && !possibleValues.contains(defaultValue) && !possibleValues.isEmpty()) {
            this.m_value = possibleValues.iterator().next();
        } else if (allowNone && !possibleValues.contains(defaultValue)) {
            try {
                this.m_value = "";
            }
            catch (Exception e) {
                this.m_value = null;
            }
        } else {
            this.m_value = defaultValue;
        }
        this.m_possibleValues = new ArrayList<T>(possibleValues);
    }

    @Override
    public Object getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        this.m_value = value;
    }

    public void setValueT(T value) {
        this.m_value = value;
    }

    @Override
    public JComponent getEditorComponent() {
        final JComboBox<T> box = new JComboBox<T>(new Vector<T>(this.m_possibleValues));
        box.setSelectedItem(this.m_value);
        box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboProperty.this.m_value = box.getSelectedItem();
            }
        });
        return box;
    }

    @Override
    public boolean validate(Object value) {
        if (this.m_possibleValues == null || this.m_possibleValues.isEmpty()) {
            return false;
        }
        try {
            if (this.m_possibleValues.contains(value)) {
                return true;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return false;
    }
}

