/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.AEditableProperty;
import games.strategy.engine.framework.GameRunner2;
import games.strategy.ui.DoubleTextField;
import games.strategy.ui.DoubleTextFieldChangeListener;
import java.io.File;
import java.math.BigDecimal;
import javax.swing.JComponent;

public class DoubleProperty
extends AEditableProperty {
    private static final long serialVersionUID = 5521967819500867581L;
    private final double m_max;
    private final double m_min;
    private double m_value;
    private final int m_places;

    public DoubleProperty(String name, String description, double max, double min, double def, int numberOfPlaces) {
        super(name, description);
        if (max < min) {
            throw new IllegalThreadStateException("Max must be greater than min");
        }
        if (def > max || def < min) {
            throw new IllegalThreadStateException("Default value out of range");
        }
        this.m_max = max;
        this.m_min = min;
        this.m_places = numberOfPlaces;
        this.m_value = DoubleProperty.roundToPlace(def, numberOfPlaces, 3);
    }

    public static double roundToPlace(double number, int places, int BigDecimalRoundingMode) {
        BigDecimal bd = new BigDecimal(number);
        bd = bd.setScale(places, BigDecimalRoundingMode);
        return bd.doubleValue();
    }

    @Override
    public Double getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(Object value) throws ClassCastException {
        if (value instanceof String) {
            throw new RuntimeException("Double and Number properties are no longer stored as Strings. You should delete your option cache, located at " + new File(GameRunner2.getUserRootFolder(), "optionCache").toString());
        }
        this.m_value = DoubleProperty.roundToPlace((Double)value, this.m_places, 3);
    }

    @Override
    public JComponent getEditorComponent() {
        DoubleTextField field = new DoubleTextField(this.m_min, this.m_max);
        field.setValue(this.m_value);
        field.addChangeListener(new DoubleTextFieldChangeListener(){

            @Override
            public void changedValue(DoubleTextField aField) {
                DoubleProperty.this.m_value = aField.getValue();
            }
        });
        return field;
    }

    @Override
    public boolean validate(Object value) {
        if (value instanceof Double) {
            double d;
            try {
                d = DoubleProperty.roundToPlace((Double)value, this.m_places, 3);
            }
            catch (Exception e) {
                return false;
            }
            if (d <= this.m_max && d >= this.m_min) {
                return true;
            }
        }
        return false;
    }
}

