/*
 * Decompiled with CFR 0.152.
 */
package games.strategy.engine.data.properties;

import games.strategy.engine.data.properties.BooleanProperty;
import games.strategy.engine.data.properties.ComboProperty;
import games.strategy.engine.data.properties.GameProperties;
import games.strategy.engine.data.properties.IEditableProperty;
import games.strategy.engine.data.properties.NumberProperty;
import games.strategy.engine.data.properties.StringProperty;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertiesUI
extends JPanel {
    private static final long serialVersionUID = 3870459799384582310L;
    private final List<? extends IEditableProperty> m_properties;
    private int m_nextRow;
    private int m_labelColumn;

    public static void main(String[] args) {
        GameProperties properties = new GameProperties(null);
        properties.addEditableProperty(new BooleanProperty("bool1 default false", null, false));
        properties.addEditableProperty(new BooleanProperty("bool2 default true", null, true));
        properties.addEditableProperty(new StringProperty("String", null, "default"));
        properties.addEditableProperty(new NumberProperty("Number [10,20]", null, 20, 12, 15));
        ArrayList<String> listValues = new ArrayList<String>();
        listValues.add("apples");
        listValues.add("oranges");
        listValues.add("bananas");
        properties.addEditableProperty(new ComboProperty<String>("List", null, "apples", listValues));
        PropertiesUI ui = new PropertiesUI(properties, true);
        JFrame frame = new JFrame();
        frame.getContentPane().add(ui);
        frame.pack();
        frame.setVisible(true);
    }

    public PropertiesUI(GameProperties gameProperties, boolean editable) {
        this(gameProperties.getEditableProperties(), editable);
    }

    public PropertiesUI(List<? extends IEditableProperty> properties, boolean editable) {
        this.init();
        this.m_properties = properties;
        for (IEditableProperty iEditableProperty : this.m_properties) {
            if (this.m_nextRow >= 15) {
                this.m_labelColumn += 2;
                this.m_nextRow = 0;
            }
            if (editable) {
                this.addItem(iEditableProperty.getName(), iEditableProperty.getEditorComponent(), iEditableProperty.getDescription(), iEditableProperty.getRowsNeeded());
                continue;
            }
            this.addItem(iEditableProperty.getName(), iEditableProperty.getViewComponent(), iEditableProperty.getDescription(), iEditableProperty.getRowsNeeded());
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 99;
        constraints.insets = new Insets(10, 0, 0, 0);
        constraints.weighty = 1.0;
        constraints.fill = 3;
        JLabel verticalFillLabel = new JLabel();
        this.add((Component)verticalFillLabel, constraints);
    }

    private void addItem(String labelText, JComponent item, String tooltip, int rowsNeeded) {
        JLabel label = new JLabel(labelText);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.gridx = this.m_labelColumn;
        labelConstraints.gridy = this.m_nextRow;
        labelConstraints.gridheight = rowsNeeded;
        labelConstraints.insets = new Insets(10, 10, 0, 0);
        labelConstraints.anchor = 12;
        labelConstraints.fill = 0;
        this.add((Component)label, labelConstraints);
        GridBagConstraints itemConstraints = new GridBagConstraints();
        itemConstraints.gridx = this.m_labelColumn + 1;
        itemConstraints.gridy = this.m_nextRow;
        itemConstraints.gridheight = rowsNeeded;
        itemConstraints.insets = new Insets(10, 10, 0, 10);
        itemConstraints.weightx = 1.0;
        itemConstraints.anchor = 17;
        itemConstraints.fill = 0;
        this.add((Component)item, itemConstraints);
        if (tooltip != null && tooltip.length() > 0) {
            label.setToolTipText(tooltip);
            item.setToolTipText(tooltip);
        }
        this.m_nextRow += rowsNeeded;
    }
}

